/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology.tsv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.okapi.common.BOMAwareInputStream;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.terminology.ConceptEntry;
import net.sf.okapi.lib.terminology.IGlossaryReader;

public class TSVReader
implements IGlossaryReader {
    private ConceptEntry nextEntry;
    private BufferedReader reader;
    private LocaleId srcLoc;
    private LocaleId trgLoc;

    public TSVReader(LocaleId srcLoc, LocaleId trgLoc) {
        this.srcLoc = srcLoc;
        this.trgLoc = trgLoc;
    }

    @Override
    public void open(File file) {
        try {
            this.open(new FileInputStream(file));
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }

    @Override
    public void open(InputStream input) {
        try {
            this.close();
            String encoding = "UTF-8";
            BOMAwareInputStream bis = new BOMAwareInputStream(input, encoding);
            encoding = bis.detectEncoding();
            this.reader = new BufferedReader(new InputStreamReader((InputStream)bis, encoding));
            this.readNext();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error opening the URI.\n" + e.getLocalizedMessage());
        }
    }

    @Override
    public void close() {
        this.nextEntry = null;
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public ConceptEntry next() {
        ConceptEntry currentEntry = this.nextEntry;
        this.readNext();
        return currentEntry;
    }

    private void readNext() {
        try {
            String[] parts;
            String line;
            this.nextEntry = null;
            do {
                if ((line = this.reader.readLine()) != null) continue;
                return;
            } while ((line = line.trim()).isEmpty() || (parts = line.split("\\t")).length <= 1);
            ConceptEntry cent = new ConceptEntry();
            cent.addTerm(this.srcLoc, parts[0]);
            cent.addTerm(this.trgLoc, parts[1]);
            this.nextEntry = cent;
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error when reading." + e.getLocalizedMessage(), e);
        }
    }
}

