/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.its.DataCategory;
import net.sf.okapi.lib.xliff2.its.IITSItem;

public class TextAnalysis
extends DataCategory {
    private Double taConfidence;
    private String taClassRef;
    private String taSource;
    private String taIdent;
    private String taIdentRef;

    @Override
    public String getDataCategoryName() {
        return "text-analysis";
    }

    @Override
    public void validate() {
        if (this.taClassRef == null && this.taSource == null && this.taIdentRef == null) {
            throw new XLIFFException("If taClassRef is not defined you must have either taSource/taIndent or taIdentRef defined.");
        }
        if (this.taSource != null) {
            if (this.taIdent == null) {
                throw new XLIFFException("If taSource is defined taIndent must also be defined.");
            }
        } else if (this.taIdent != null) {
            throw new XLIFFException("If taIdent is defined taSource must also be defined.");
        }
        if (this.taIdentRef != null && (this.taSource != null || this.taIdent != null)) {
            throw new XLIFFException("If taIdentRef is defined neither taSource nor taIdent can be defined.");
        }
        if (this.taConfidence != null && this.getAnnotatorRef() == null) {
            throw new XLIFFException("An annotator reference must be defined when taConfidence is defined.");
        }
    }

    public Double getTaConfidence() {
        return this.taConfidence;
    }

    public void setTaConfidence(Double taConfidence) {
        if (taConfidence != null && (taConfidence < 0.0 || taConfidence > 1.0)) {
            throw new InvalidParameterException(String.format("The taConfidence value '%f' is out of the [0.0 to 1.0] range.", taConfidence));
        }
        this.taConfidence = taConfidence;
    }

    public String getTaClassRef() {
        return this.taClassRef;
    }

    public void setTaClassRef(String taClassRef) {
        this.taClassRef = taClassRef;
    }

    public String getTaSource() {
        return this.taSource;
    }

    public void setTaSource(String taSource) {
        this.taSource = taSource;
    }

    public String getTaIdent() {
        return this.taIdent;
    }

    public void setTaIdent(String taIdent) {
        this.taIdent = taIdent;
    }

    public String getTaIdentRef() {
        return this.taIdentRef;
    }

    public void setTaIdentRef(String taIdentRef) {
        this.taIdentRef = taIdentRef;
    }

    @Override
    public IITSItem createCopy() {
        TextAnalysis newItem = new TextAnalysis();
        newItem.setAnnotatorRef(this.getAnnotatorRef());
        newItem.taClassRef = this.taClassRef;
        newItem.taConfidence = this.taConfidence;
        newItem.taIdent = this.taIdent;
        newItem.taIdentRef = this.taIdentRef;
        newItem.taSource = this.taSource;
        return newItem;
    }
}

