/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

class LanguageData {
    private static final Pattern HYPHEN = Pattern.compile("-");
    private static final String[][] EMPTY_DOUBLE_STRING_ARRAY = new String[0][];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String PREFIX = "prefix: ";
    private static final String SUPPRESS_SCRIPT = "suppress-script: ";
    private static final String SUBTAG = "subtag: ";
    private static final String TAG = "tag: ";
    private static final String TYPE = "type: ";
    private static final String DEPRECATED = "deprecated: ";
    private static final String PREFERRED_VALUE = "preferred-value: ";
    private SortedSet<String> languageSet = new TreeSet<String>();
    private SortedSet<String> extlangSet = new TreeSet<String>();
    private SortedSet<String> scriptSet = new TreeSet<String>();
    private SortedSet<String> regionSet = new TreeSet<String>();
    private SortedSet<String> variantSet = new TreeSet<String>();
    private SortedSet<String> grandfatheredSet = new TreeSet<String>();
    private SortedSet<String> redundantSet = new TreeSet<String>();
    private SortedSet<String> deprecatedLangSet = new TreeSet<String>();
    private SortedSet<String> deprecatedSet = new TreeSet<String>();
    private Map<String, String> suppressedScriptByLanguageMap = new HashMap<String, String>();
    private Map<String, String> prefixByExtlangMap = new HashMap<String, String>();
    private Map<String, String> preferredValueByLanguageMap = new HashMap<String, String>();
    private Map<String, Set<String[]>> prefixesByVariantMap = new HashMap<String, Set<String[]>>();
    private String[] languages = null;
    private String[] extlangs = null;
    private String[] scripts = null;
    private String[] regions = null;
    private String[] variants = null;
    private String[] grandfathered = null;
    private String[] redundant = null;
    private String[] deprecatedLang = null;
    private String[] deprecated = null;
    private int[] suppressedScriptByLanguage = null;
    private int[] prefixByExtlang = null;
    private String[][][] prefixesByVariant = null;

    LanguageData() throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/language-subtag-registry.txt");
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader in = new BufferedReader(isr);){
            while (this.consumeRecord(in)) {
            }
        }
        this.prepareArrays();
    }

    private void prepareArrays() throws IOException {
        int index;
        this.scripts = this.scriptSet.toArray(EMPTY_STRING_ARRAY);
        this.regions = this.regionSet.toArray(EMPTY_STRING_ARRAY);
        this.grandfathered = this.grandfatheredSet.toArray(EMPTY_STRING_ARRAY);
        this.redundant = this.redundantSet.toArray(EMPTY_STRING_ARRAY);
        this.deprecated = this.deprecatedSet.toArray(EMPTY_STRING_ARRAY);
        this.deprecatedLang = this.deprecatedLangSet.toArray(EMPTY_STRING_ARRAY);
        int i = 0;
        this.languages = new String[this.languageSet.size()];
        this.suppressedScriptByLanguage = new int[this.languageSet.size()];
        Iterator iterator = this.languageSet.iterator();
        while (iterator.hasNext()) {
            String language;
            this.languages[i] = language = (String)iterator.next();
            String suppressed = this.suppressedScriptByLanguageMap.get(language);
            if (suppressed == null) {
                this.suppressedScriptByLanguage[i] = -1;
            } else {
                index = Arrays.binarySearch(this.scripts, suppressed);
                if (index < 0) {
                    throw new IOException("Malformed registry: reference to non-existent script.");
                }
                this.suppressedScriptByLanguage[i] = index;
            }
            ++i;
        }
        i = 0;
        this.extlangs = new String[this.extlangSet.size()];
        this.prefixByExtlang = new int[this.extlangSet.size()];
        iterator = this.extlangSet.iterator();
        while (iterator.hasNext()) {
            String extlang;
            this.extlangs[i] = extlang = (String)iterator.next();
            String prefix = this.prefixByExtlangMap.get(extlang);
            if (prefix == null) {
                this.prefixByExtlang[i] = -1;
            } else {
                index = Arrays.binarySearch(this.languages, prefix);
                if (index < 0) {
                    throw new IOException("Malformed registry: reference to non-existent prefix for extlang.");
                }
                this.prefixByExtlang[i] = index;
            }
            ++i;
        }
        i = 0;
        this.variants = new String[this.variantSet.size()];
        this.prefixesByVariant = new String[this.variantSet.size()][][];
        iterator = this.variantSet.iterator();
        while (iterator.hasNext()) {
            String variant;
            this.variants[i] = variant = (String)iterator.next();
            Set<String[]> prefixes = this.prefixesByVariantMap.get(variant);
            this.prefixesByVariant[i] = prefixes != null ? (String[][])prefixes.toArray((T[])EMPTY_DOUBLE_STRING_ARRAY) : EMPTY_DOUBLE_STRING_ARRAY;
            ++i;
        }
    }

    private boolean consumeRecord(BufferedReader in) throws IOException {
        boolean hasMore = true;
        String type = null;
        String subtag = null;
        String suppressScript = null;
        String preferredValue = null;
        HashSet<String[]> prefixes = new HashSet<String[]>();
        String singlePrefix = null;
        boolean depr = false;
        String line = null;
        while (true) {
            if ((line = in.readLine()) == null) {
                hasMore = false;
                break;
            }
            if ("%%".equals(line = line.toLowerCase())) break;
            if (line.startsWith(TYPE)) {
                type = line.substring(TYPE.length()).trim().intern();
                continue;
            }
            if (line.startsWith(SUBTAG)) {
                subtag = line.substring(SUBTAG.length()).trim().intern();
                continue;
            }
            if (line.startsWith(TAG)) {
                subtag = line.substring(TAG.length()).trim().intern();
                continue;
            }
            if (line.startsWith(SUPPRESS_SCRIPT)) {
                suppressScript = line.substring(SUPPRESS_SCRIPT.length()).trim().intern();
                continue;
            }
            if (line.startsWith(PREFIX)) {
                String[] prefixSubtags = HYPHEN.split(line.substring(PREFIX.length()).trim());
                for (int i = 0; i < prefixSubtags.length; ++i) {
                    prefixSubtags[i] = prefixSubtags[i].intern();
                }
                prefixes.add(prefixSubtags);
                singlePrefix = prefixSubtags[0];
                continue;
            }
            if (line.startsWith(DEPRECATED)) {
                depr = true;
                continue;
            }
            if (!line.startsWith(PREFERRED_VALUE)) continue;
            preferredValue = line.substring(PREFERRED_VALUE.length()).trim().intern();
            this.preferredValueByLanguageMap.put(subtag, preferredValue);
        }
        if (subtag == null) {
            return hasMore;
        }
        if (depr) {
            if ("language".equals(type)) {
                this.deprecatedLangSet.add(subtag);
            } else {
                this.deprecatedSet.add(subtag);
            }
        }
        if ("language".equals(type)) {
            this.languageSet.add(subtag);
            this.suppressedScriptByLanguageMap.put(subtag, suppressScript);
        }
        if ("extlang".equals(type)) {
            this.extlangSet.add(subtag);
            this.prefixByExtlangMap.put(subtag, singlePrefix);
        } else if ("region".equals(type)) {
            this.regionSet.add(subtag);
        } else if ("script".equals(type)) {
            this.scriptSet.add(subtag);
        } else if ("variant".equals(type)) {
            this.variantSet.add(subtag);
            this.prefixesByVariantMap.put(subtag, prefixes);
        } else if ("grandfathered".equals(type)) {
            this.grandfatheredSet.add(subtag);
        } else if ("redundant".equals(type)) {
            this.redundantSet.add(subtag);
        }
        return hasMore;
    }

    public String[] getLanguages() {
        return this.languages;
    }

    public String[] getExtlangs() {
        return this.extlangs;
    }

    public String[][][] getPrefixesByVariant() {
        return this.prefixesByVariant;
    }

    public int[] getPrefixByExtlang() {
        return this.prefixByExtlang;
    }

    public String[] getRegions() {
        return this.regions;
    }

    public String[] getScripts() {
        return this.scripts;
    }

    public int[] getSuppressedScriptByLanguage() {
        return this.suppressedScriptByLanguage;
    }

    public String[] getVariants() {
        return this.variants;
    }

    public String[] getDeprecated() {
        return this.deprecated;
    }

    public Map<String, String> getPreferredValueByLanguageMap() {
        return this.preferredValueByLanguageMap;
    }

    public String[] getGrandfathered() {
        return this.grandfathered;
    }

    public String[] getRedundant() {
        return this.redundant;
    }

    public String[] getDeprecatedLang() {
        return this.deprecatedLang;
    }
}

