/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.walker.strategy;

import java.util.List;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.document.FileNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.walker.IXliffVisitor;
import net.sf.okapi.lib.xliff2.walker.VisitationContext;
import net.sf.okapi.lib.xliff2.walker.XliffWalker;
import net.sf.okapi.lib.xliff2.walker.selector.PathSelectorUtils;
import net.sf.okapi.lib.xliff2.walker.selector.XliffWalkerPathSelector;
import net.sf.okapi.lib.xliff2.walker.strategy.IXliffWalkerStrategy;

public class FlexibleXliffWalkerStrategy
implements IXliffWalkerStrategy {
    private final List<XliffWalkerPathSelector> pathSelectors;

    FlexibleXliffWalkerStrategy(List<XliffWalkerPathSelector> pathSelectors) {
        this.pathSelectors = pathSelectors;
    }

    @Override
    public void doWalk(XLIFFDocument doc, XliffWalker walker) {
        if (doc == null) {
            throw new IllegalArgumentException("A valid XLIFF document must be provided.");
        }
        for (XliffWalkerPathSelector fileNodePathSelector : this.pathSelectors) {
            String[] fileNodeIds;
            for (String fileNodeID : fileNodeIds = PathSelectorUtils.resolveFileNodeIds(doc, fileNodePathSelector)) {
                FileNode fileNode = doc.getFileNode(fileNodeID);
                for (IXliffVisitor<FileNode> visitor : walker.getFileNodeVisitors(fileNodeID)) {
                    visitor.visit(fileNode, new VisitationContext(fileNodeID, fileNode));
                }
                for (XliffWalkerPathSelector unitNodePathSelector : fileNodePathSelector.getChildrenNodes()) {
                    UnitNode[] unitNodes;
                    for (UnitNode unitNode : unitNodes = PathSelectorUtils.resolveUnitNodes(fileNode, unitNodePathSelector)) {
                        for (IXliffVisitor<UnitNode> visitor : walker.getUnitNodeVisitors(fileNodeID, unitNode.get().getId())) {
                            visitor.visit(unitNode, new VisitationContext(fileNodeID, fileNode, unitNode));
                        }
                        for (XliffWalkerPathSelector segmentPathSelector : unitNodePathSelector.getChildrenNodes()) {
                            PathSelectorUtils.Pair<Integer, Segment>[] indexedSegments;
                            for (PathSelectorUtils.Pair<Integer, Segment> indexedSegment : indexedSegments = PathSelectorUtils.resolveSegments(unitNode, segmentPathSelector)) {
                                for (IXliffVisitor<Segment> visitor : walker.getSegmentVisitors(fileNodeID, unitNode.get().getId(), indexedSegment.getLeft())) {
                                    visitor.visit(indexedSegment.getRight(), new VisitationContext(fileNodeID, fileNode, unitNode, indexedSegment.getLeft()));
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

