/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.externalcommand;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.externalcommand.Parameters;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class ExternalCommandStep
extends BasePipelineStep {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String INPUT_FILE_VAR = "inputPath";
    private static final String OUTPUT_FILE_VAR = "outputPath";
    private boolean done = false;
    private Parameters parameters = new Parameters();
    private Executor executor;
    private ExecuteWatchdog watchdog;
    private URI outputURI;

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(IParameters params) {
        this.parameters = (Parameters)params;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public String getDescription() {
        return "Execute an external command line.";
    }

    @Override
    public String getName() {
        return "External Command";
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.done = false;
        this.executor = new DefaultExecutor();
        if (this.parameters.getTimeout() > 0) {
            this.watchdog = new ExecuteWatchdog((long)this.parameters.getTimeout() * 1000L);
            this.executor.setWatchdog(this.watchdog);
        }
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        int exitValue;
        HashMap<String, Object> subtitutions = new HashMap<String, Object>();
        RawDocument rawDoc = event.getRawDocument();
        String inputPath = new File(rawDoc.getInputURI()).getPath();
        subtitutions.put(INPUT_FILE_VAR, inputPath);
        Object outputPath = inputPath + ".out";
        if (this.isLastOutputStep() && this.outputURI != null && !this.outputURI.getPath().isEmpty()) {
            outputPath = new File(this.outputURI).getPath();
        }
        subtitutions.put(OUTPUT_FILE_VAR, outputPath);
        subtitutions.put("srcLangName", rawDoc.getSourceLocale().toJavaLocale().getDisplayLanguage(Locale.ENGLISH));
        subtitutions.put("srcLang", rawDoc.getSourceLocale().getLanguage());
        subtitutions.put("srcBCP47", rawDoc.getSourceLocale().toBCP47());
        subtitutions.put("trgLangName", rawDoc.getTargetLocale().toJavaLocale().getDisplayLanguage(Locale.ENGLISH));
        subtitutions.put("trgLang", rawDoc.getTargetLocale().getLanguage());
        subtitutions.put("trgBCP47", rawDoc.getTargetLocale().toBCP47());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)out, (OutputStream)err);
        String[] parts = ExternalCommandStep.splitCommand(this.parameters.getCommand());
        CommandLine cl = new CommandLine(parts[0]);
        cl.setSubstitutionMap(subtitutions);
        for (int i = 1; i < parts.length; ++i) {
            cl.addArgument(parts[i], false);
        }
        try {
            psh.start();
            this.LOGGER.info("External Command: {}", (Object)cl.toString());
            exitValue = this.executor.execute(cl);
        }
        catch (ExecuteException e) {
            throw new OkapiException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        if (this.watchdog != null && this.watchdog.killedProcess()) {
            throw new OkapiException("Command line process timed out: " + out.toString());
        }
        if (this.executor.isFailure(exitValue)) {
            throw new OkapiException("Command line process failed: " + err.toString());
        }
        try {
            psh.stop();
            out.close();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing process output streamm.", e);
        }
        try {
            err.close();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing process error streamm", e);
        }
        RawDocument outRawDoc = null;
        outRawDoc = new RawDocument(new File((String)outputPath).toURI(), rawDoc.getEncoding(), rawDoc.getSourceLocale(), rawDoc.getTargetLocale());
        event.setResource(outRawDoc);
        this.done = true;
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        return event;
    }

    public static String[] splitCommand(String cmd) {
        if ((cmd = cmd.trim()).length() == 0) {
            return new String[]{""};
        }
        StringBuilder arg = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        boolean noQuote = false;
        int currentQuote = 0;
        for (int i = 0; i < cmd.length(); ++i) {
            int c = cmd.charAt(i);
            if (c == currentQuote) {
                currentQuote = 0;
                continue;
            }
            if (c == 34 && currentQuote == 0) {
                currentQuote = 34;
                continue;
            }
            if (c == 39 && currentQuote == 0) {
                currentQuote = 39;
                continue;
            }
            if (c == 92 && i + 1 < cmd.length()) {
                char next = cmd.charAt(i + 1);
                if (currentQuote == 0 && Character.isWhitespace(next) || currentQuote == 34 && next == '\"') {
                    arg.append(next);
                    ++i;
                    continue;
                }
                arg.append((char)c);
                continue;
            }
            if (Character.isWhitespace((char)c) && currentQuote == 0) {
                if (arg.length() <= 0) continue;
                result.add(arg.toString());
                arg = new StringBuilder();
                continue;
            }
            arg.append((char)c);
        }
        if (arg.length() > 0) {
            result.add(arg.toString());
        }
        return result.toArray(new String[0]);
    }
}

