/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.gcaligner;

import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.steps.gcaligner.AlignmentScorer;
import net.sf.okapi.steps.gcaligner.DpFunction;
import net.sf.okapi.steps.gcaligner.DpMatrix;
import net.sf.okapi.steps.gcaligner.DpMatrixCell;
import net.sf.okapi.steps.gcaligner.Penalties;

public class AlignmentFunction<T>
implements DpFunction<T> {
    private LocaleId m_sourceLocale;
    private LocaleId m_targetLocale;
    private List<AlignmentScorer<T>> m_scorerList;
    private Penalties penalties;

    public AlignmentFunction(LocaleId p_sourceLocale, LocaleId p_targetLocale, List<AlignmentScorer<T>> scorerList, Penalties penalties) {
        this.m_scorerList = scorerList;
        this.penalties = penalties;
        this.m_sourceLocale = p_sourceLocale;
        this.m_targetLocale = p_targetLocale;
        for (AlignmentScorer<T> s : this.m_scorerList) {
            s.setLocales(this.m_sourceLocale, this.m_targetLocale);
        }
    }

    @Override
    public void setCellScore(int p_xPos, int p_yPos, DpMatrix<T> p_matrix) {
        if (p_xPos == 0 && p_yPos == 0) {
            return;
        }
        DpMatrixCell currentCell = this.getCell(p_xPos, p_yPos, p_matrix);
        DpMatrixCell insertionCell = this.getCell(p_xPos, p_yPos - 1, p_matrix);
        DpMatrixCell deletionCell = this.getCell(p_xPos - 1, p_yPos, p_matrix);
        DpMatrixCell substitutionCell = this.getCell(p_xPos - 1, p_yPos - 1, p_matrix);
        DpMatrixCell contractionCell = this.getCell(p_xPos - 2, p_yPos - 1, p_matrix);
        DpMatrixCell expansionCell = this.getCell(p_xPos - 1, p_yPos - 2, p_matrix);
        DpMatrixCell meldingCell = this.getCell(p_xPos - 2, p_yPos - 2, p_matrix);
        int deletionScore = this.getDeletionScore(deletionCell, p_xPos, p_matrix);
        int insertionScore = this.getInsertionScore(insertionCell, p_yPos, p_matrix);
        int substitutionScore = this.getSubstitutionScore(substitutionCell, p_xPos, p_yPos, p_matrix);
        int contractionScore = this.getContractionScore(contractionCell, p_xPos, p_yPos, p_matrix);
        int expansionScore = this.getExpansionScore(expansionCell, p_xPos, p_yPos, p_matrix);
        int meldingScore = this.getMeldingScore(meldingCell, p_xPos, p_yPos, p_matrix);
        this.setScoreAndLink(currentCell, deletionCell, insertionCell, substitutionCell, contractionCell, expansionCell, meldingCell, deletionScore, insertionScore, substitutionScore, contractionScore, expansionScore, meldingScore);
    }

    private DpMatrixCell getCell(int p_xPos, int p_yPos, DpMatrix<T> p_matrix) {
        DpMatrixCell cell = null;
        if (p_xPos >= 0 && p_yPos >= 0) {
            cell = p_matrix.getCell(p_xPos, p_yPos);
        }
        return cell;
    }

    private int getDeletionScore(DpMatrixCell p_deletionCell, int p_xPos, DpMatrix<T> p_matrix) {
        int score = Integer.MAX_VALUE;
        if (p_deletionCell != null) {
            score = 0;
            T seg = p_matrix.getAlignmentElementX(p_xPos);
            for (AlignmentScorer<T> scorer : this.m_scorerList) {
                score += scorer.deletionScore(seg);
            }
            score += p_deletionCell.getScore() + this.penalties.penalty0_1;
        }
        return score;
    }

    private int getInsertionScore(DpMatrixCell p_insertionCell, int p_yPos, DpMatrix<T> p_matrix) {
        int score = Integer.MAX_VALUE;
        if (p_insertionCell != null) {
            score = 0;
            T seg = p_matrix.getAlignmentElementY(p_yPos);
            for (AlignmentScorer<T> scorer : this.m_scorerList) {
                score += scorer.insertionScore(seg);
            }
            score += p_insertionCell.getScore() + this.penalties.penalty0_1;
        }
        return score;
    }

    private int getSubstitutionScore(DpMatrixCell p_substitutionCell, int p_xPos, int p_yPos, DpMatrix<T> p_matrix) {
        int score = Integer.MAX_VALUE;
        if (p_substitutionCell != null) {
            score = 0;
            T sourceSeg = p_matrix.getAlignmentElementX(p_xPos);
            T targetSeg = p_matrix.getAlignmentElementY(p_yPos);
            for (AlignmentScorer<T> scorer : this.m_scorerList) {
                score += scorer.substitutionScore(sourceSeg, targetSeg);
            }
            score += p_substitutionCell.getScore();
        }
        return score;
    }

    private int getContractionScore(DpMatrixCell p_contractionCell, int p_xPos, int p_yPos, DpMatrix<T> p_matrix) {
        int score = Integer.MAX_VALUE;
        if (p_contractionCell != null) {
            score = 0;
            T currentSourceSeg = p_matrix.getAlignmentElementX(p_xPos);
            T prevSourceSeg = p_matrix.getAlignmentElementX(p_xPos - 1);
            T targetSeg = p_matrix.getAlignmentElementY(p_yPos);
            for (AlignmentScorer<T> scorer : this.m_scorerList) {
                score += scorer.contractionScore(currentSourceSeg, prevSourceSeg, targetSeg);
            }
            score += p_contractionCell.getScore() + this.penalties.penalty2_1;
        }
        return score;
    }

    private int getExpansionScore(DpMatrixCell p_expansionCell, int p_xPos, int p_yPos, DpMatrix<T> p_matrix) {
        int score = Integer.MAX_VALUE;
        if (p_expansionCell != null) {
            score = 0;
            T srcSeg = p_matrix.getAlignmentElementX(p_xPos);
            T currentTargetSeg = p_matrix.getAlignmentElementY(p_yPos);
            T prevTargetSeg = p_matrix.getAlignmentElementY(p_yPos - 1);
            for (AlignmentScorer<T> scorer : this.m_scorerList) {
                score += scorer.expansionScore(srcSeg, currentTargetSeg, prevTargetSeg);
            }
            score += p_expansionCell.getScore() + this.penalties.penalty2_1;
        }
        return score;
    }

    private int getMeldingScore(DpMatrixCell p_meldingCell, int p_xPos, int p_yPos, DpMatrix<T> p_matrix) {
        int score = Integer.MAX_VALUE;
        if (p_meldingCell != null) {
            score = 0;
            T currentSourceSeg = p_matrix.getAlignmentElementX(p_xPos);
            T currentTargetSeg = p_matrix.getAlignmentElementY(p_yPos);
            T prevTargetSeg = p_matrix.getAlignmentElementY(p_yPos - 1);
            for (AlignmentScorer<T> scorer : this.m_scorerList) {
                score += scorer.meldingScore(currentSourceSeg, prevTargetSeg, currentTargetSeg, prevTargetSeg);
            }
            score += p_meldingCell.getScore() + this.penalties.penalty2_2;
        }
        return score;
    }

    private void setScoreAndLink(DpMatrixCell p_currentCell, DpMatrixCell p_deletionCell, DpMatrixCell p_insertionCell, DpMatrixCell p_substitutionCell, DpMatrixCell p_contractionCell, DpMatrixCell p_expansionCell, DpMatrixCell p_meldingCell, int p_deletionScore, int p_insertionScore, int p_substitutionScore, int p_contractionScore, int p_expansionScore, int p_meldingScore) {
        DpMatrixCell backLink = null;
        int minScore = Integer.MAX_VALUE;
        if (minScore > p_deletionScore) {
            minScore = p_deletionScore;
            backLink = p_deletionCell;
        }
        if (minScore > p_insertionScore) {
            minScore = p_insertionScore;
            backLink = p_insertionCell;
        }
        if (minScore > p_substitutionScore) {
            minScore = p_substitutionScore;
            backLink = p_substitutionCell;
        }
        if (minScore > p_contractionScore) {
            minScore = p_contractionScore;
            backLink = p_contractionCell;
        }
        if (minScore > p_expansionScore) {
            minScore = p_expansionScore;
            backLink = p_expansionCell;
        }
        if (minScore > p_meldingScore) {
            minScore = p_meldingScore;
            backLink = p_meldingCell;
        }
        p_currentCell.setScoreAndLink(minScore, backLink);
    }
}

