/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.idbasedcopy;

import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.idbasedcopy.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class IdBasedCopyStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private IFilterConfigurationMapper fcMapper;
    private LocaleId targetLocale;
    private RawDocument toCopyInput = null;
    private Map<String, ITextUnit> toCopy;
    private boolean useTargetText;

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.toCopyInput = secondInput;
    }

    @Override
    public String getDescription() {
        return "Copies the source text of the second input into the target of the first input based on matching id.\nExpects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Id-Based Copy";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        this.useTargetText = event.getStartDocument().isMultilingual();
        if (this.toCopyInput == null) {
            this.logger.warn("Second input file is not specified.");
            this.toCopy = null;
        } else {
            this.readEntriesToCopy();
        }
        return event;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        if (this.toCopy != null && !this.toCopy.isEmpty()) {
            for (String id : this.toCopy.keySet()) {
                this.logger.warn("Id '{}' is in the second file, but not in the main input.", (Object)id);
            }
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        TextContainer tc;
        if (this.toCopy == null) {
            return event;
        }
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        ITextUnit toCopyTu = this.toCopy.get(tu.getName());
        if (toCopyTu != null && (tc = this.useTargetText ? toCopyTu.getTarget(this.targetLocale) : toCopyTu.getSource()) != null) {
            tu.setTarget(this.targetLocale, tc);
            this.toCopy.remove(tu.getName());
            if (this.params.getMarkAsTranslateNo()) {
                tu.setIsTranslatable(false);
            }
            if (this.params.getMarkAsApproved()) {
                tu.setTargetProperty(this.targetLocale, new Property("approved", "yes", Property.FILTER_AND_DISPLAY));
            }
        }
        return event;
    }

    private void readEntriesToCopy() {
        this.toCopy = new HashMap<String, ITextUnit>();
        try (IFilter filter = this.fcMapper.createFilter(this.toCopyInput.getFilterConfigId(), null);){
            filter.open(this.toCopyInput);
            while (filter.hasNext()) {
                Event event = filter.next();
                if (event.getEventType() != EventType.TEXT_UNIT) continue;
                ITextUnit tu = event.getTextUnit();
                String id = tu.getName();
                if (Util.isEmpty(id)) {
                    this.logger.warn("Entry without id detected in second file.");
                    continue;
                }
                if (this.toCopy.get(id) != null) {
                    this.logger.warn("Duplicate id detected: {}", (Object)id);
                    continue;
                }
                this.toCopy.put(id, tu);
            }
        }
    }
}

