/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.inlinescodeschecker;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.lib.verification.InlineCodesChecker;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.steps.inlinescodeschecker.Parameters;

@UsingParameters(value=Parameters.class)
public class InlineCodesCheckerStep
extends BasePipelineStep {
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private InlineCodesChecker inlineCodesChecker = new InlineCodesChecker();
    private Parameters params = new Parameters();
    private net.sf.okapi.lib.verification.Parameters fullParams = new net.sf.okapi.lib.verification.Parameters();

    @Override
    public String getName() {
        return "Inline Codes Quality Check";
    }

    @Override
    public String getDescription() {
        return "Compare source and target for inline code differences. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.fullParams.fromString(this.params.toString());
        this.inlineCodesChecker.startProcess(this.sourceLocale, this.targetLocale, this.fullParams, new ArrayList<Issue>());
        return event;
    }

    @Override
    protected Event handleStartSubDocument(Event event) {
        this.inlineCodesChecker.processStartSubDocument(event.getStartSubDocument());
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        this.inlineCodesChecker.processStartDocument((StartDocument)event.getResource(), null);
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        this.inlineCodesChecker.processTextUnit(event.getTextUnit());
        return event;
    }

    protected List<Issue> getIssues() {
        return this.inlineCodesChecker.getIssues();
    }
}

