/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.ttxsplitter;

import java.text.BreakIterator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;

public class WordCounter {
    private final BreakIterator breaker;

    public WordCounter(LocaleId locId) {
        this.breaker = BreakIterator.getWordInstance(locId.toJavaLocale());
    }

    public long getWordCount(String text) {
        if (Util.isEmpty(text)) {
            return 0L;
        }
        long res = 0L;
        this.breaker.setText(text);
        int start = this.breaker.first();
        int end = this.breaker.next();
        while (end != -1) {
            for (int i = start; i < end; ++i) {
                if (!Character.isLetterOrDigit(text.codePointAt(i))) continue;
                ++res;
                break;
            }
            start = end;
            end = this.breaker.next();
        }
        return res;
    }
}

