/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.common;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.tokenization.Token;
import net.sf.okapi.steps.tokenization.Tokens;
import net.sf.okapi.steps.wordcount.CharacterCounter;
import net.sf.okapi.steps.wordcount.common.TokenCountStep;

public abstract class TokenCharacterCountStep
extends TokenCountStep {
    @Override
    protected long count(Segment segment, LocaleId locale) {
        return TokenCharacterCountStep.countTokenChars(this.getTokens(segment, locale), locale);
    }

    @Override
    protected long count(TextContainer textContainer, LocaleId locale) {
        return TokenCharacterCountStep.countTokenChars(this.getTokens(textContainer, locale), locale);
    }

    public static long countTokenChars(Tokens tokens, LocaleId locale) {
        if (tokens == null || locale == null) {
            return 0L;
        }
        long total = 0L;
        for (Token t : tokens) {
            total += CharacterCounter.count(t.getValue(), locale);
        }
        return total;
    }
}

