/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputDialog {
    private Shell shell;
    private Text edField;
    private String result = null;
    private String help;
    private OKCancelPanel pnlActions;
    private boolean allowEmptyValue = false;
    private Font customFont;

    public InputDialog(Shell parent, String captionText, String labelText, String defaultInputText, String helpFile, int buttonOptions, int multiline, int maxWidth) {
        GridData gdTmp;
        this.help = helpFile;
        this.shell = new Shell(parent, 65648);
        if (captionText != null) {
            this.shell.setText(captionText);
        }
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout((Layout)new GridLayout());
        Composite cmpTmp = new Composite((Composite)this.shell, 2048);
        cmpTmp.setLayoutData((Object)new GridData(1808));
        GridLayout layTmp = new GridLayout(buttonOptions > 0 ? 2 : 1, false);
        cmpTmp.setLayout((Layout)layTmp);
        Label label = new Label(cmpTmp, 0);
        label.setText(labelText);
        if (buttonOptions > 0) {
            gdTmp = new GridData();
            gdTmp.horizontalSpan = 2;
            label.setLayoutData((Object)gdTmp);
        }
        int opt = 2052;
        if (multiline > 0) {
            opt = 2626;
        }
        this.edField = new Text(cmpTmp, opt);
        gdTmp = new GridData(1808);
        if (buttonOptions == 0) {
            gdTmp.horizontalSpan = 2;
        } else {
            Button btGet = new Button(cmpTmp, 8);
            btGet.setText("...");
            btGet.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputDialog.this.getFolder();
                }
            });
        }
        if (multiline > 0) {
            gdTmp.heightHint = multiline;
        }
        this.edField.setLayoutData((Object)gdTmp);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog.this.result = null;
                if (e.widget.getData().equals("h")) {
                    UIUtil.start(InputDialog.this.help);
                    return;
                }
                if (e.widget.getData().equals("o") && !InputDialog.this.saveData()) {
                    return;
                }
                InputDialog.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, helpFile != null);
        this.pnlActions.setLayoutData(new GridData(768));
        this.shell.setDefaultButton(this.pnlActions.btOK);
        this.shell.pack();
        Point size = this.shell.getSize();
        if (maxWidth > -1 && size.x > maxWidth) {
            size.x = maxWidth;
        }
        this.shell.setMinimumSize(size);
        if (size.x < 450) {
            size.x = 450;
        }
        if (defaultInputText != null) {
            this.edField.setText(defaultInputText);
        }
        this.shell.setSize(size);
        Dialogs.centerWindow(this.shell, parent);
    }

    public String showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        this.dispose();
        return this.result;
    }

    private void dispose() {
        if (this.customFont != null) {
            this.customFont.dispose();
            this.customFont = null;
        }
    }

    public void changeFontSize(int change) {
        Font font = this.edField.getFont();
        Device device = font.getDevice();
        FontData[] fontData = font.getFontData();
        fontData[0].setHeight(fontData[0].getHeight() + change);
        Font tmpFont = this.customFont;
        this.customFont = new Font(device, fontData[0]);
        this.edField.setFont(this.customFont);
        if (tmpFont != null) {
            tmpFont.dispose();
        }
    }

    public void setInputValue(String value) {
        if (value == null) {
            this.edField.setText("");
        } else {
            this.edField.setText(value);
        }
    }

    public void setAllowEmptyValue(boolean value) {
        this.allowEmptyValue = value;
    }

    public void setReadOnly(boolean value) {
        this.pnlActions.btOK.setEnabled(!value);
    }

    private void getFolder() {
        try {
            DirectoryDialog dlg = new DirectoryDialog(this.shell);
            dlg.setFilterPath(this.edField.getText());
            String dir = dlg.open();
            if (dir == null) {
                return;
            }
            this.edField.setText(dir);
            this.edField.selectAll();
            this.edField.setFocus();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
        }
    }

    private boolean saveData() {
        this.result = this.edField.getText();
        if (this.result.length() == 0) {
            if (this.allowEmptyValue) {
                return true;
            }
            this.edField.selectAll();
            this.edField.setFocus();
            return false;
        }
        return true;
    }
}

