/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import java.nio.charset.Charset;
import java.util.List;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.filters.FilterConfigurationEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InputDocumentPanel
extends Composite {
    private Label stDocument;
    private Text edDocument;
    private Label stConfigId;
    private Text edConfigId;
    private Button btGetFile;
    private Button btGetConfigId;
    private Label stEncoding;
    private Text edEncoding;
    private Label stSourceLocale;
    private Text edSourceLocale;
    private Label stTargetLocale;
    private Text edTargetLocale;
    private String title;
    private String filterNames;
    private String filterExtensions;
    private IFilterConfigurationMapper fcMapper;

    public InputDocumentPanel(Composite parent, int flags, int horizontalSpan, String documentLabel, String getDocumentLabel, IFilterConfigurationMapper fcMapper) {
        super(parent, flags);
        this.createContent(horizontalSpan, documentLabel, getDocumentLabel, fcMapper);
    }

    private void createContent(int horizontalSpan, String docLabel, String getDocLabel, IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
        this.title = "Select a File";
        GridLayout layTmp = new GridLayout(3, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.setLayout((Layout)layTmp);
        GridData gdTmp = new GridData(768);
        gdTmp.horizontalSpan = horizontalSpan;
        this.setLayoutData(gdTmp);
        if (docLabel != null) {
            this.stDocument = new Label((Composite)this, 0);
            this.stDocument.setText(docLabel);
            gdTmp = new GridData();
            gdTmp.horizontalSpan = 3;
            this.stDocument.setLayoutData((Object)gdTmp);
        }
        this.edDocument = new Text((Composite)this, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.edDocument.setLayoutData((Object)gdTmp);
        this.btGetFile = new Button((Composite)this, 8);
        if (getDocLabel == null) {
            this.btGetFile.setText("...");
        } else {
            this.btGetFile.setText(getDocLabel);
        }
        this.btGetFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDocumentPanel.this.browsePath();
            }
        });
        this.stConfigId = new Label((Composite)this, 0);
        this.stConfigId.setText("Configuration:");
        this.edConfigId = new Text((Composite)this, 2048);
        this.edConfigId.setLayoutData((Object)new GridData(768));
        this.btGetConfigId = new Button((Composite)this, 8);
        this.btGetConfigId.setText("...");
        this.btGetConfigId.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDocumentPanel.this.browseConfiguration();
            }
        });
        this.stEncoding = new Label((Composite)this, 0);
        this.stEncoding.setText("Encoding:");
        this.edEncoding = new Text((Composite)this, 2048);
        this.edEncoding.setLayoutData((Object)new GridData(768));
        new Label((Composite)this, 0);
        this.stSourceLocale = new Label((Composite)this, 0);
        this.stSourceLocale.setText("Source locale:");
        this.edSourceLocale = new Text((Composite)this, 2048);
        this.edSourceLocale.setLayoutData((Object)new GridData(768));
        new Label((Composite)this, 0);
        this.stTargetLocale = new Label((Composite)this, 0);
        this.stTargetLocale.setText("Target locale:");
        this.edTargetLocale = new Text((Composite)this, 2048);
        this.edTargetLocale.setLayoutData((Object)new GridData(768));
        new Label((Composite)this, 0);
    }

    public String getDocumentPath() {
        return this.edDocument.getText();
    }

    public void setDocumentPath(String path) {
        this.edDocument.setText(path == null ? "" : path);
    }

    public String getFilterConfigurationId() {
        return this.edConfigId.getText();
    }

    public void setFilterConfigurationId(String configId) {
        this.edConfigId.setText(configId == null ? "" : configId);
    }

    public String getEncoding() {
        return this.edEncoding.getText();
    }

    public void setEncoding(String encoding) {
        this.edEncoding.setText(encoding == null ? "" : encoding);
    }

    public LocaleId getSourceLocale() {
        if (this.edSourceLocale.getText().isEmpty()) {
            return LocaleId.EMPTY;
        }
        return LocaleId.fromString((String)this.edSourceLocale.getText());
    }

    public void setSourceLocale(LocaleId sourceLocale) {
        this.edSourceLocale.setText(sourceLocale == null ? "" : sourceLocale.toString());
    }

    public LocaleId getTargetLocale() {
        if (this.edTargetLocale.getText().isEmpty()) {
            return LocaleId.EMPTY;
        }
        return LocaleId.fromString((String)this.edTargetLocale.getText());
    }

    public void setTargetLocale(LocaleId targetLocale) {
        this.edTargetLocale.setText(targetLocale == null ? "" : targetLocale.toString());
    }

    public void guessConfiguration() {
        String ext = Util.getExtension((String)this.edDocument.getText());
        FilterConfiguration fc = this.fcMapper.getDefaultConfigurationFromExtension(ext);
        if (fc != null) {
            this.edConfigId.setText(fc.configId);
        }
    }

    public void guessLocales() {
        if (this.edSourceLocale.getEditable()) {
            List list = FileUtil.guessLanguages((String)this.edDocument.getText());
            if (!list.isEmpty()) {
                this.edSourceLocale.setText((String)list.get(0));
            }
            if (list.size() == 2) {
                this.edTargetLocale.setText((String)list.get(1));
            } else if (list.size() > 2) {
                StringBuilder tmp = new StringBuilder((String)list.get(1));
                for (int i = 2; i < list.size(); ++i) {
                    tmp.append(" or " + (String)list.get(i));
                }
                this.edTargetLocale.setText(tmp.toString());
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.stDocument != null) {
            this.stDocument.setEnabled(enabled);
        }
        this.edDocument.setEnabled(enabled);
        this.btGetFile.setEnabled(enabled);
        this.edConfigId.setEnabled(enabled);
        this.btGetConfigId.setEnabled(enabled);
        this.edEncoding.setEnabled(enabled);
        this.edSourceLocale.setEnabled(enabled);
        this.edTargetLocale.setEnabled(enabled);
    }

    public void setLocalesEditable(boolean editable) {
        this.edSourceLocale.setEditable(editable);
        this.edTargetLocale.setEditable(editable);
    }

    public void setEditable(boolean editable) {
        if (this.stDocument != null) {
            this.stDocument.setEnabled(editable);
        }
        this.edDocument.setEditable(editable);
        this.btGetFile.setEnabled(editable);
        this.edConfigId.setEditable(editable);
        this.btGetConfigId.setEnabled(editable);
        this.edEncoding.setEditable(editable);
        this.edSourceLocale.setEditable(editable);
        this.edTargetLocale.setEditable(editable);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBrowseFilters(String filterNames, String filterExtensions) {
        this.filterNames = filterNames;
        this.filterExtensions = filterExtensions;
    }

    private void browseConfiguration() {
        try {
            FilterConfigurationEditor fcEditor = new FilterConfigurationEditor();
            String res = fcEditor.editConfigurations(this.fcMapper, this.edConfigId.getText());
            if (res != null) {
                this.edConfigId.setText(res);
                this.edConfigId.selectAll();
                this.edConfigId.setFocus();
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.getShell(), e.getLocalizedMessage(), null);
        }
    }

    private void browsePath() {
        try {
            FilterConfiguration fc;
            String oldExt = Util.getExtension((String)this.edDocument.getText());
            String[] paths = Dialogs.browseFilenames(this.getShell(), this.title, false, null, this.filterNames, this.filterExtensions);
            if (paths == null) {
                return;
            }
            this.edDocument.setText(paths[0]);
            this.edDocument.selectAll();
            this.edDocument.setFocus();
            String newExt = Util.getExtension((String)paths[0]);
            if ((this.edConfigId.getText().isEmpty() || !oldExt.equalsIgnoreCase(newExt)) && (fc = this.fcMapper.getDefaultConfigurationFromExtension(newExt)) != null) {
                this.edConfigId.setText(fc.configId);
            }
            this.guessLocales();
        }
        catch (Throwable e) {
            Dialogs.showError(this.getShell(), e.getLocalizedMessage(), null);
        }
    }

    public boolean validate(boolean showError) {
        if (this.edDocument.getText().trim().isEmpty()) {
            if (showError) {
                Dialogs.showError(this.getShell(), "The document path must not be empty.", null);
                this.edDocument.setFocus();
            }
            return false;
        }
        String tmp = this.edConfigId.getText();
        if (this.fcMapper.getConfiguration(tmp) == null) {
            if (showError) {
                Dialogs.showError(this.getShell(), String.format("The string '%s' is not a known configuration ID.", tmp), null);
                this.edConfigId.setFocus();
            }
            return false;
        }
        tmp = this.edEncoding.getText();
        try {
            Charset.forName(tmp);
        }
        catch (Throwable e) {
            if (showError) {
                Dialogs.showError(this.getShell(), String.format("The encoding '%s' is either unknown or not supported.", tmp), null);
                this.edEncoding.setFocus();
            }
            return false;
        }
        tmp = this.edSourceLocale.getText();
        try {
            LocaleId.fromString((String)tmp);
        }
        catch (Throwable e) {
            if (showError) {
                Dialogs.showError(this.getShell(), String.format("The source locale '%s' is not a valid locale.", tmp), null);
                this.edSourceLocale.setFocus();
            }
            return false;
        }
        tmp = this.edTargetLocale.getText();
        try {
            LocaleId.fromString((String)tmp);
        }
        catch (Throwable e) {
            if (showError) {
                Dialogs.showError(this.getShell(), String.format("The target locale '%s' is not a valid locale.", tmp), null);
                this.edTargetLocale.setFocus();
            }
            return false;
        }
        return true;
    }
}

