/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.filters;

import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.filters.IFilterConfigurationInfoEditor;
import net.sf.okapi.common.ui.filters.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FilterConfigurationInfoEditor
implements IFilterConfigurationInfoEditor {
    private Shell shell;
    private FilterConfiguration config;
    private Text edIdentifier;
    private Text edName;
    private Text edDescription;
    private Text edParametersLocation;
    private boolean result;

    @Override
    public void create(Shell parent) {
        this.shell = new Shell(parent, 65648);
        this.shell.setText(Res.getString("FilterConfigurationInfoEditor.caption"));
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)this.shell, 0);
        label.setText(Res.getString("FilterConfigurationInfoEditor.identifier"));
        this.edIdentifier = new Text((Composite)this.shell, 2048);
        this.edIdentifier.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)this.shell, 0);
        label.setText(Res.getString("FilterConfigurationInfoEditor.paramsLocation"));
        this.edParametersLocation = new Text((Composite)this.shell, 2048);
        this.edParametersLocation.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)this.shell, 0);
        label.setText(Res.getString("FilterConfigurationInfoEditor.name"));
        this.edName = new Text((Composite)this.shell, 2048);
        this.edName.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)this.shell, 0);
        label.setText(Res.getString("FilterConfigurationInfoEditor.description"));
        this.edDescription = new Text((Composite)this.shell, 2624);
        GridData gdTmp = new GridData(1808);
        gdTmp.heightHint = 40;
        this.edDescription.setLayoutData((Object)gdTmp);
        SelectionAdapter actions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConfigurationInfoEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!FilterConfigurationInfoEditor.this.saveData()) {
                        return;
                    }
                    FilterConfigurationInfoEditor.this.result = true;
                }
                FilterConfigurationInfoEditor.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, actions, false);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        pnlActions.setLayoutData(gdTmp);
        this.shell.setDefaultButton(pnlActions.btOK);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 450) {
            startSize.x = 450;
        }
        this.shell.setSize(startSize);
        Dialogs.centerWindow(this.shell, parent);
    }

    private void setData(FilterConfiguration config) {
        this.config = config;
        this.edIdentifier.setText(config.configId);
        this.edParametersLocation.setText(config.parametersLocation);
        this.edName.setText(config.name);
        this.edDescription.setText(config.description);
    }

    private boolean saveData() {
        String tmp = this.edIdentifier.getText();
        if (tmp.length() == 0) {
            this.edIdentifier.setFocus();
            return false;
        }
        tmp = this.edParametersLocation.getText();
        if (tmp.length() == 0) {
            this.edParametersLocation.setFocus();
            return false;
        }
        tmp = this.edName.getText();
        if (tmp.length() == 0) {
            this.edName.setFocus();
            return false;
        }
        this.config.configId = this.edIdentifier.getText();
        this.config.parametersLocation = this.edParametersLocation.getText();
        this.config.name = this.edName.getText();
        this.config.description = this.edDescription.getText();
        return true;
    }

    @Override
    public boolean showDialog(FilterConfiguration config, IFilterConfigurationMapper mapper) {
        this.setData(config);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }
}

