/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml.ui;

import java.util.ResourceBundle;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.ui.Inputs;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

@EditorFor(value=Parameters.class)
public class Editor
implements IParametersEditor {
    private ResourceBundle resourceBundle;
    private Parameters params;
    private boolean readOnly;
    private IHelp help;
    private Shell shell;
    private Inputs inputs;
    private boolean edited;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters paramsObject, boolean readOnly, IContext context) {
        this.resourceBundle = ResourceBundle.getBundle("net.sf.okapi.filters.idml.ui.Editor");
        this.params = (Parameters)paramsObject;
        this.readOnly = readOnly;
        this.help = (IHelp)context.getObject("help");
        this.edited = false;
        try {
            this.shell = this.shellWith((Shell)context.getObject("shell"));
            this.configureInputs();
            this.configureActions();
            this.configureGeneralListeners();
            this.shell.pack();
            this.shell.open();
            Display display = this.shell.getShell().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return this.edited;
    }

    private Shell shellWith(Shell parent) {
        Shell shell = new Shell(parent, 65648);
        shell.setText(this.resourceBundle.getString("idml-filter-parameters"));
        if (parent != null) {
            UIUtil.inheritIcon(shell, parent);
        }
        shell.setLayout((Layout)new GridLayout());
        return shell;
    }

    private void configureInputs() {
        this.inputs = new Inputs.Default(ResourceBundle.getBundle("net.sf.okapi.filters.idml.ui.Inputs"), this.shell);
        this.inputs.configureFrom(this.params);
    }

    private void configureActions() {
        SelectionAdapter actionsHandler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("h".equals(e.widget.getData())) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("IDML Filter");
                    }
                } else if ("o".equals(e.widget.getData())) {
                    Editor.this.params.reset();
                    try {
                        Editor.this.inputs.saveTo(Editor.this.params);
                        Editor.this.edited = true;
                        Editor.this.shell.close();
                    }
                    catch (Exception ex) {
                        Dialogs.showError(Editor.this.shell, ex.getLocalizedMessage(), null);
                    }
                } else {
                    Editor.this.shell.close();
                }
            }
        };
        OKCancelPanel actionsPanel = new OKCancelPanel((Composite)this.shell, 0, actionsHandler, true);
        actionsPanel.setLayoutData(new GridData(768));
        actionsPanel.btOK.setEnabled(!this.readOnly);
        if (!this.readOnly) {
            this.shell.setDefaultButton(actionsPanel.btOK);
        }
    }

    private void configureGeneralListeners() {
        this.shell.addListener(31, event -> {
            if (event.detail == 2) {
                this.shell.close();
            }
        });
    }

    public IParameters createParameters() {
        return new Parameters();
    }
}

