/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml.ui;

import java.util.ResourceBundle;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.ui.ResponsiveTable;
import net.sf.okapi.common.ui.filters.InlineCodeFinderPanel;
import net.sf.okapi.common.ui.filters.ResponsiveTableFontMappingsInput;
import net.sf.okapi.common.ui.filters.ResponsiveTableFontMappingsOutput;
import net.sf.okapi.filters.idml.Parameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

interface Inputs {
    public void configureFrom(Parameters var1);

    public void saveTo(Parameters var1);

    public static final class Default
    implements Inputs {
        private final ResourceBundle resourceBundle;
        private final Shell shell;
        private Text maxAttributeSizeText;
        private Text specialCharacterPattern;
        private Button untagXmlStructuresButton;
        private Button extractNotesButton;
        private Button extractMasterSpreadsButton;
        private Button extractHiddenLayersButton;
        private Button extractHiddenPasteboardItemsButton;
        private Button skipDiscretionaryHyphensButton;
        private Button extractBreaksInlineButton;
        private Button extractHyperlinkTextSourcesInlineButton;
        private Button extractCustomTextVariablesButton;
        private Button extractIndexTopicsButton;
        private Button extractExternalHyperlinksButton;
        private ResponsiveTable fontMappingsTable;
        private Button ignoreCharacterKerningButton;
        private Text characterKerningMinIgnoranceThresholdText;
        private Text characterKerningMaxIgnoranceThresholdText;
        private Button ignoreCharacterTrackingButton;
        private Text characterTrackingMinIgnoranceThresholdText;
        private Text characterTrackingMaxIgnoranceThresholdText;
        private Button ignoreCharacterLeadingButton;
        private Text characterLeadingMinIgnoranceThresholdText;
        private Text characterLeadingMaxIgnoranceThresholdText;
        private Button ignoreCharacterBaselineShiftButton;
        private Text characterBaselineShiftMinIgnoranceThresholdText;
        private Text characterBaselineShiftMaxIgnoranceThresholdText;
        private Button useCodefinderButton;
        private InlineCodeFinderPanel pnlCodeFinder;

        Default(ResourceBundle resourceBundle, Shell shell) {
            this.resourceBundle = resourceBundle;
            this.shell = shell;
        }

        @Override
        public void configureFrom(Parameters parameters) {
            Composite c = new Composite((Composite)this.shell, 0);
            c.setLayout((Layout)new GridLayout(2, false));
            Composite lc = new Composite(c, 0);
            lc.setLayout((Layout)new GridLayout());
            lc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.maxAttributeSizeText = this.labelAndTextFor(lc, "maximum-attribute-size", Integer.toUnsignedString(parameters.getMaxAttributeSize()));
            this.specialCharacterPattern = this.labelAndTextFor(lc, "special-character-pattern", parameters.specialCharacterPattern().toString());
            this.untagXmlStructuresButton = this.buttonFor(lc, "untag-xml-structures", parameters.getUntagXmlStructures());
            this.extractNotesButton = this.buttonFor(lc, "extract-notes", parameters.getExtractNotes());
            this.extractMasterSpreadsButton = this.buttonFor(lc, "extract-master-spreads", parameters.getExtractMasterSpreads());
            this.extractHiddenLayersButton = this.buttonFor(lc, "extract-hidden-layers", parameters.getExtractHiddenLayers());
            this.extractHiddenPasteboardItemsButton = this.buttonFor(lc, "extract-hidden-pasteboard-items", parameters.getExtractHiddenPasteboardItems());
            this.skipDiscretionaryHyphensButton = this.buttonFor(lc, "skip-discretionary-hyphens", parameters.getSkipDiscretionaryHyphens());
            this.extractBreaksInlineButton = this.buttonFor(lc, "extract-breaks-inline", parameters.getExtractBreaksInline());
            this.extractHyperlinkTextSourcesInlineButton = this.buttonFor(lc, "extract-hyperlink-text-sources-inline", parameters.getExtractHyperlinkTextSourcesInline());
            this.extractCustomTextVariablesButton = this.buttonFor(lc, "extract-custom-text-variables", parameters.getExtractCustomTextVariables());
            this.extractIndexTopicsButton = this.buttonFor(lc, "extract-index-topics", parameters.getExtractIndexTopics());
            this.extractExternalHyperlinksButton = this.buttonFor(lc, "extract-external-hyperlinks", parameters.getExtractExternalHyperlinks());
            this.labelFor(lc, "font-mappings");
            this.fontMappingsTable = (ResponsiveTable)parameters.fontMappings().writtenTo((FontMappings.Output)new ResponsiveTableFontMappingsOutput(new ResponsiveTable.Default(new Table(lc, 67586), new Menu((Decorations)this.shell, 8), new Menu((Decorations)this.shell, 8))));
            this.useCodefinderButton = this.buttonFor(lc, "use-codefinder", parameters.getUseCodeFinder());
            this.pnlCodeFinder = new InlineCodeFinderPanel(lc, 0);
            this.pnlCodeFinder.setLayoutData(new GridData(1808));
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.updateInlineCodes();
                }
            };
            this.useCodefinderButton.addSelectionListener((SelectionListener)listener);
            Composite rc = new Composite(c, 0);
            rc.setLayout((Layout)new GridLayout());
            rc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.labelFor(rc, "ignored-styles");
            this.ignoreCharacterKerningButton = this.buttonFor(rc, "ignore-character-kerning", parameters.getIgnoreCharacterKerning());
            this.characterKerningMinIgnoranceThresholdText = this.labelAndTextFor(rc, "character-kerning-minimum-ignorance-threshold", parameters.getCharacterKerningMinIgnoranceThreshold());
            this.characterKerningMaxIgnoranceThresholdText = this.labelAndTextFor(rc, "character-kerning-maximum-ignorance-threshold", parameters.getCharacterKerningMaxIgnoranceThreshold());
            this.ignoreCharacterTrackingButton = this.buttonFor(rc, "ignore-character-tracking", parameters.getIgnoreCharacterTracking());
            this.characterTrackingMinIgnoranceThresholdText = this.labelAndTextFor(rc, "character-tracking-minimum-ignorance-threshold", parameters.getCharacterTrackingMinIgnoranceThreshold());
            this.characterTrackingMaxIgnoranceThresholdText = this.labelAndTextFor(rc, "character-tracking-maximum-ignorance-threshold", parameters.getCharacterTrackingMaxIgnoranceThreshold());
            this.ignoreCharacterLeadingButton = this.buttonFor(rc, "ignore-character-leading", parameters.getIgnoreCharacterLeading());
            this.characterLeadingMinIgnoranceThresholdText = this.labelAndTextFor(rc, "character-leading-minimum-ignorance-threshold", parameters.getCharacterLeadingMinIgnoranceThreshold());
            this.characterLeadingMaxIgnoranceThresholdText = this.labelAndTextFor(rc, "character-leading-maximum-ignorance-threshold", parameters.getCharacterLeadingMaxIgnoranceThreshold());
            this.ignoreCharacterBaselineShiftButton = this.buttonFor(rc, "ignore-character-baseline-shift", parameters.getIgnoreCharacterBaselineShift());
            this.characterBaselineShiftMinIgnoranceThresholdText = this.labelAndTextFor(rc, "character-baseline-shift-minimum-ignorance-threshold", parameters.getCharacterBaselineShiftMinIgnoranceThreshold());
            this.characterBaselineShiftMaxIgnoranceThresholdText = this.labelAndTextFor(rc, "character-baseline-shift-maximum-ignorance-threshold", parameters.getCharacterBaselineShiftMaxIgnoranceThreshold());
        }

        private Button buttonFor(Composite composite, String key, boolean selection) {
            Button b = new Button(composite, 32);
            b.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            b.setText(this.resourceBundle.getString(key));
            b.setSelection(selection);
            return b;
        }

        private Label labelFor(Composite composite, String key) {
            Label l = new Label(composite, 0);
            l.setText(this.resourceBundle.getString(key));
            return l;
        }

        private Text textFor(Composite composite, String text) {
            Text t = new Text(composite, 2048);
            t.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            t.setText(text);
            return t;
        }

        private Text labelAndTextFor(Composite composite, String labelKey, String text) {
            this.labelFor(composite, labelKey);
            return this.textFor(composite, text);
        }

        @Override
        public void saveTo(Parameters parameters) {
            parameters.setMaxAttributeSize(Integer.parseUnsignedInt(this.maxAttributeSizeText.getText()));
            parameters.specialCharacterPattern(this.specialCharacterPattern.getText());
            parameters.setUntagXmlStructures(this.untagXmlStructuresButton.getSelection());
            parameters.setExtractNotes(this.extractNotesButton.getSelection());
            parameters.setExtractMasterSpreads(this.extractMasterSpreadsButton.getSelection());
            parameters.setExtractHiddenLayers(this.extractHiddenLayersButton.getSelection());
            parameters.setExtractHiddenPasteboardItems(this.extractHiddenPasteboardItemsButton.getSelection());
            parameters.setSkipDiscretionaryHyphens(this.skipDiscretionaryHyphensButton.getSelection());
            parameters.setExtractBreaksInline(this.extractBreaksInlineButton.getSelection());
            parameters.setExtractHyperlinkTextSourcesInline(this.extractHyperlinkTextSourcesInlineButton.getSelection());
            parameters.setExtractCustomTextVariables(this.extractCustomTextVariablesButton.getSelection());
            parameters.setExtractIndexTopics(this.extractIndexTopicsButton.getSelection());
            parameters.setExtractExternalHyperlinks(this.extractExternalHyperlinksButton.getSelection());
            parameters.fontMappings().addFrom((FontMappings.Input)new ResponsiveTableFontMappingsInput(this.fontMappingsTable));
            parameters.setIgnoreCharacterKerning(this.ignoreCharacterKerningButton.getSelection());
            parameters.setCharacterKerningMinIgnoranceThreshold(this.characterKerningMinIgnoranceThresholdText.getText());
            parameters.setCharacterKerningMaxIgnoranceThreshold(this.characterKerningMaxIgnoranceThresholdText.getText());
            parameters.setIgnoreCharacterTracking(this.ignoreCharacterTrackingButton.getSelection());
            parameters.setCharacterTrackingMinIgnoranceThreshold(this.characterTrackingMinIgnoranceThresholdText.getText());
            parameters.setCharacterTrackingMaxIgnoranceThreshold(this.characterTrackingMaxIgnoranceThresholdText.getText());
            parameters.setIgnoreCharacterLeading(this.ignoreCharacterLeadingButton.getSelection());
            parameters.setCharacterLeadingMinIgnoranceThreshold(this.characterLeadingMinIgnoranceThresholdText.getText());
            parameters.setCharacterLeadingMaxIgnoranceThreshold(this.characterLeadingMaxIgnoranceThresholdText.getText());
            parameters.setIgnoreCharacterBaselineShift(this.ignoreCharacterBaselineShiftButton.getSelection());
            parameters.setCharacterBaselineShiftMinIgnoranceThreshold(this.characterBaselineShiftMinIgnoranceThresholdText.getText());
            parameters.setCharacterBaselineShiftMaxIgnoranceThreshold(this.characterBaselineShiftMaxIgnoranceThresholdText.getText());
            parameters.setUseCodeFinder(this.useCodefinderButton.getSelection());
            if (this.useCodefinderButton.getSelection()) {
                parameters.setCodeFinderData(this.pnlCodeFinder.getRules());
            }
        }

        private void updateInlineCodes() {
            this.pnlCodeFinder.setEnabled(this.useCodefinderButton.getSelection());
        }
    }
}

