/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.regex.ui;

import java.util.ArrayList;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.InputDialog;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.filters.InlineCodeFinderDialog;
import net.sf.okapi.common.ui.filters.LDPanel;
import net.sf.okapi.filters.regex.Parameters;
import net.sf.okapi.filters.regex.Rule;
import net.sf.okapi.filters.regex.ui.Res;
import net.sf.okapi.filters.regex.ui.RuleDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class Editor
implements IParametersEditor {
    private Shell shell;
    private boolean result = false;
    private Text edExpression;
    private Text edStartString;
    private Text edEndString;
    private Button chkRemoveBSlashEscape;
    private Button chkUseBSlashEscape;
    private Button chkUseDoubleCharEscape;
    private List lbRules;
    private Button btAdd;
    private Button btEdit;
    private Button btRename;
    private Button btRemove;
    private Button btMoveUp;
    private Button btMoveDown;
    private LDPanel pnlLD;
    private Parameters params;
    private ArrayList<Rule> rules;
    private int ruleIndex = -1;
    private Text edRuleType;
    private Button chkPreserveWS;
    private Button chkUseCodeFinder;
    private Button btEditFinderRules;
    private Button chkCollapseNewline;
    private Button chkIgnoreCase;
    private Button chkDotAll;
    private Button chkMultiline;
    private Text edMimeType;
    private Text edSubFilter;
    private IHelp help;
    private Button chkOneLevelGroups;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters p_Options, boolean readOnly, IContext context) {
        boolean bRes = false;
        this.shell = null;
        this.help = (IHelp)context.getObject("help");
        this.params = (Parameters)p_Options;
        this.rules = new ArrayList();
        for (Rule rule : this.params.getRules()) {
            this.rules.add(new Rule(rule));
        }
        try {
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    private void create(Shell p_Parent, boolean readOnly) {
        this.shell.setText(Res.getString("Editor.caption"));
        if (p_Parent != null) {
            this.shell.setImage(p_Parent.getImage());
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        TabFolder tfTmp = new TabFolder((Composite)this.shell, 0);
        GridData gdTmp = new GridData(1808);
        tfTmp.setLayoutData((Object)gdTmp);
        Composite cmpTmp = new Composite((Composite)tfTmp, 0);
        layTmp = new GridLayout(2, false);
        cmpTmp.setLayout((Layout)layTmp);
        this.lbRules = new List(cmpTmp, 2304);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 1;
        gdTmp.grabExcessHorizontalSpace = true;
        gdTmp.verticalSpan = 3;
        this.lbRules.setLayoutData((Object)gdTmp);
        this.lbRules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateRule();
                Editor.this.updateMoveButtons();
            }
        });
        this.lbRules.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                Editor.this.editRule(false);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Group propGroup = new Group(cmpTmp, 0);
        layTmp = new GridLayout();
        propGroup.setLayout((Layout)layTmp);
        propGroup.setText(Res.getString("Editor.ruleProperties"));
        gdTmp = new GridData(1808);
        gdTmp.verticalSpan = 3;
        propGroup.setLayoutData((Object)gdTmp);
        this.edExpression = new Text((Composite)propGroup, 2624);
        this.edExpression.setEditable(false);
        gdTmp = new GridData(768);
        gdTmp.heightHint = 50;
        this.edExpression.setLayoutData((Object)gdTmp);
        this.edRuleType = new Text((Composite)propGroup, 2048);
        this.edRuleType.setLayoutData((Object)new GridData(768));
        this.edRuleType.setEditable(false);
        this.chkPreserveWS = new Button((Composite)propGroup, 32);
        this.chkPreserveWS.setText(Res.getString("Editor.preserveWS"));
        gdTmp = new GridData();
        this.chkPreserveWS.setLayoutData((Object)gdTmp);
        this.chkUseCodeFinder = new Button((Composite)propGroup, 32);
        this.chkUseCodeFinder.setText(Res.getString("Editor.hasInlines"));
        gdTmp = new GridData();
        this.chkUseCodeFinder.setLayoutData((Object)gdTmp);
        this.chkUseCodeFinder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateEditFinderRulesButton();
            }
        });
        this.btEditFinderRules = new Button((Composite)propGroup, 8);
        this.btEditFinderRules.setText(Res.getString("Editor.editInlines"));
        gdTmp = new GridData();
        gdTmp.horizontalIndent = 16;
        this.btEditFinderRules.setLayoutData((Object)gdTmp);
        this.btEditFinderRules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.editFinderRules();
            }
        });
        this.chkCollapseNewline = new Button((Composite)propGroup, 32);
        this.chkCollapseNewline.setText(Res.getString("Editor.collapseNewline"));
        gdTmp = new GridData();
        this.chkCollapseNewline.setLayoutData((Object)gdTmp);
        Composite cmpButtons = new Composite(cmpTmp, 0);
        layTmp = new GridLayout(2, true);
        layTmp.marginWidth = 0;
        cmpButtons.setLayout((Layout)layTmp);
        gdTmp = new GridData(2);
        gdTmp.verticalSpan = 2;
        cmpButtons.setLayoutData((Object)gdTmp);
        int buttonWidth = 90;
        this.btAdd = new Button(cmpButtons, 8);
        this.btAdd.setText(Res.getString("Editor.add"));
        gdTmp = new GridData(768);
        this.btAdd.setLayoutData((Object)gdTmp);
        UIUtil.ensureWidth((Control)this.btAdd, buttonWidth);
        this.btAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.editRule(true);
            }
        });
        this.btEdit = new Button(cmpButtons, 8);
        this.btEdit.setText(Res.getString("Editor.edit"));
        gdTmp = new GridData(768);
        this.btEdit.setLayoutData((Object)gdTmp);
        this.btEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.editRule(false);
            }
        });
        this.btRename = new Button(cmpButtons, 8);
        this.btRename.setText(Res.getString("Editor.rename"));
        gdTmp = new GridData(768);
        this.btRename.setLayoutData((Object)gdTmp);
        this.btRename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.renameRule();
            }
        });
        this.btMoveUp = new Button(cmpButtons, 8);
        this.btMoveUp.setText(Res.getString("Editor.moveUp"));
        gdTmp = new GridData(768);
        this.btMoveUp.setLayoutData((Object)gdTmp);
        this.btMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.moveUpRule();
            }
        });
        this.btRemove = new Button(cmpButtons, 8);
        this.btRemove.setText(Res.getString("Editor.remove"));
        gdTmp = new GridData(768);
        gdTmp.verticalAlignment = 2;
        this.btRemove.setLayoutData((Object)gdTmp);
        this.btRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.removeRule();
            }
        });
        this.btMoveDown = new Button(cmpButtons, 8);
        this.btMoveDown.setText(Res.getString("Editor.moveDown"));
        gdTmp = new GridData(768);
        gdTmp.verticalAlignment = 2;
        this.btMoveDown.setLayoutData((Object)gdTmp);
        this.btMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.moveDownRule();
            }
        });
        this.chkOneLevelGroups = new Button(cmpTmp, 32);
        this.chkOneLevelGroups.setText(Res.getString("Editor.autoClosegroup"));
        Group optionsGroup = new Group(cmpTmp, 0);
        layTmp = new GridLayout(2, false);
        optionsGroup.setLayout((Layout)layTmp);
        optionsGroup.setText(Res.getString("Editor.regexOptions"));
        gdTmp = new GridData(770);
        optionsGroup.setLayoutData((Object)gdTmp);
        this.chkDotAll = new Button((Composite)optionsGroup, 32);
        this.chkDotAll.setText(Res.getString("Editor.dotMatchesLF"));
        this.chkMultiline = new Button((Composite)optionsGroup, 32);
        this.chkMultiline.setText(Res.getString("Editor.multiline"));
        this.chkIgnoreCase = new Button((Composite)optionsGroup, 32);
        this.chkIgnoreCase.setText(Res.getString("Editor.ignoreCases"));
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText(Res.getString("Editor.rules"));
        tiTmp.setControl((Control)cmpTmp);
        cmpTmp = new Composite((Composite)tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout((Layout)layTmp);
        Group grpTmp = new Group(cmpTmp, 0);
        layTmp = new GridLayout();
        grpTmp.setLayout((Layout)layTmp);
        grpTmp.setText(Res.getString("Editor.locDir"));
        gdTmp = new GridData(768);
        grpTmp.setLayoutData((Object)gdTmp);
        this.pnlLD = new LDPanel((Composite)grpTmp, 0);
        grpTmp = new Group(cmpTmp, 0);
        layTmp = new GridLayout(2, false);
        grpTmp.setLayout((Layout)layTmp);
        grpTmp.setText(Res.getString("Editor.strings"));
        gdTmp = new GridData(768);
        grpTmp.setLayoutData((Object)gdTmp);
        Label label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("Editor.startOfString"));
        this.edStartString = new Text((Composite)grpTmp, 2048);
        gdTmp = new GridData(768);
        this.edStartString.setLayoutData((Object)gdTmp);
        label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("Editor.endOfString"));
        this.edEndString = new Text((Composite)grpTmp, 2048);
        gdTmp = new GridData(768);
        this.edEndString.setLayoutData((Object)gdTmp);
        this.chkRemoveBSlashEscape = new Button((Composite)grpTmp, 32);
        this.chkRemoveBSlashEscape.setText("Escaped characters are unescaped on import (e.g. \\\" -> \").");
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.chkRemoveBSlashEscape.setLayoutData((Object)gdTmp);
        this.chkUseBSlashEscape = new Button((Composite)grpTmp, 32);
        this.chkUseBSlashEscape.setText("Escaped characters use back-slash prefix (e.g. \\\")");
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.chkUseBSlashEscape.setLayoutData((Object)gdTmp);
        this.chkUseDoubleCharEscape = new Button((Composite)grpTmp, 32);
        this.chkUseDoubleCharEscape.setText("Escaped characters are doubled (e.g. \"\")");
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.chkUseDoubleCharEscape.setLayoutData((Object)gdTmp);
        grpTmp = new Group(cmpTmp, 0);
        layTmp = new GridLayout(2, false);
        grpTmp.setLayout((Layout)layTmp);
        grpTmp.setText(Res.getString("Editor.contentType"));
        gdTmp = new GridData(768);
        grpTmp.setLayoutData((Object)gdTmp);
        label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("Editor.mimeType"));
        this.edMimeType = new Text((Composite)grpTmp, 2048);
        gdTmp = new GridData(768);
        this.edMimeType.setLayoutData((Object)gdTmp);
        grpTmp = new Group(cmpTmp, 0);
        layTmp = new GridLayout(2, false);
        grpTmp.setLayout((Layout)layTmp);
        grpTmp.setText(Res.getString("Editor.subFiltering"));
        gdTmp = new GridData(768);
        grpTmp.setLayoutData((Object)gdTmp);
        label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("Editor.subFilter"));
        this.edSubFilter = new Text((Composite)grpTmp, 2048);
        gdTmp = new GridData(768);
        this.edSubFilter.setLayoutData((Object)gdTmp);
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText(Res.getString("Editor.options"));
        tiTmp.setControl((Control)cmpTmp);
        SelectionAdapter okCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("Regex Filter");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    Editor.this.saveData();
                }
                Editor.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, okCancelActions, true);
        gdTmp = new GridData(768);
        pnlActions.setLayoutData(gdTmp);
        pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(pnlActions.btOK);
        }
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 600) {
            startSize.x = 600;
        }
        if (startSize.y < 450) {
            startSize.y = 450;
        }
        this.shell.setSize(startSize);
        Dialogs.centerWindow(this.shell, p_Parent);
        this.setData();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void updateRule() {
        this.saveRuleData(this.ruleIndex);
        int newRuleIndex = this.lbRules.getSelectionIndex();
        boolean enabled = newRuleIndex > -1;
        this.edRuleType.setEnabled(enabled);
        this.chkPreserveWS.setEnabled(enabled);
        this.chkUseCodeFinder.setEnabled(enabled);
        this.chkCollapseNewline.setEnabled(enabled);
        this.ruleIndex = newRuleIndex;
        if (this.ruleIndex < 0) {
            this.edExpression.setText("");
            this.edRuleType.setText("");
            this.chkPreserveWS.setSelection(false);
            this.chkUseCodeFinder.setSelection(false);
            this.btEditFinderRules.setEnabled(false);
            this.chkCollapseNewline.setSelection(false);
            return;
        }
        Rule rule = this.rules.get(this.ruleIndex);
        this.edExpression.setText(rule.getExpression());
        switch (rule.getRuleType()) {
            case 0: {
                this.edRuleType.setText(Res.getString("Editor.extractStringsInside"));
                break;
            }
            case 1: {
                this.edRuleType.setText(Res.getString("Editor.extractContent"));
                break;
            }
            case 2: {
                this.edRuleType.setText(Res.getString("Editor.treatAsComment"));
                break;
            }
            case 3: {
                this.edRuleType.setText(Res.getString("Editor.doNotExtract"));
                break;
            }
            case 4: {
                this.edRuleType.setText(Res.getString("Editor.startGroup"));
                break;
            }
            case 5: {
                this.edRuleType.setText(Res.getString("Editor.endGroup"));
                break;
            }
            default: {
                this.edRuleType.setText("");
            }
        }
        this.chkPreserveWS.setSelection(rule.preserveWS());
        this.chkUseCodeFinder.setSelection(rule.useCodeFinder());
        this.chkCollapseNewline.setSelection(rule.getCollapseNewline());
        this.updateEditFinderRulesButton();
    }

    private void updateEditFinderRulesButton() {
        this.btEditFinderRules.setEnabled(this.chkUseCodeFinder.getSelection());
    }

    private void editFinderRules() {
        try {
            Rule rule = this.rules.get(this.ruleIndex);
            InlineCodeFinderDialog dlg = new InlineCodeFinderDialog(this.shell, Res.getString("Editor.inlinesPatterns"), null);
            dlg.setData(rule.getCodeFinderRules());
            String tmp = dlg.showDialog();
            if (tmp == null) {
                return;
            }
            rule.setCodeFinderRules(tmp);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void saveRuleData(int index) {
        if (index < 0) {
            return;
        }
        Rule rule = this.rules.get(index);
        rule.setPreserveWS(this.chkPreserveWS.getSelection());
        rule.setUseCodeFinder(this.chkUseCodeFinder.getSelection());
        rule.setCollapseNewline(this.chkCollapseNewline.getSelection());
    }

    private void updateMoveButtons() {
        int n = this.lbRules.getSelectionIndex();
        this.btMoveUp.setEnabled(n > 0);
        this.btMoveDown.setEnabled(n != -1 && n < this.lbRules.getItemCount() - 1);
    }

    private void updateRuleButtons() {
        int n = this.lbRules.getSelectionIndex();
        this.btRemove.setEnabled(n != -1);
        this.btEdit.setEnabled(n != -1);
        this.btRename.setEnabled(n != -1);
        this.updateMoveButtons();
    }

    private void renameRule() {
        try {
            int n = this.lbRules.getSelectionIndex();
            if (n == -1) {
                return;
            }
            Rule rule = this.rules.get(n);
            String name = rule.getRuleName();
            InputDialog dlg = new InputDialog(this.shell, Res.getString("Editor.renameRule"), Res.getString("Editor.newRuleName"), name, null, 0, -1, -1);
            name = dlg.showDialog();
            if (name == null) {
                return;
            }
            rule.setRuleName(name);
            this.lbRules.setItem(n, name);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editRule(boolean newRule) {
        try {
            Rule rule;
            if (newRule) {
                String name = Res.getString("Editor.defaultRuleName");
                InputDialog dlg = new InputDialog(this.shell, Res.getString("Editor.newRuleCaption"), Res.getString("Editor.newRuleLabel"), name, null, 0, -1, -1);
                name = dlg.showDialog();
                if (name == null) {
                    return;
                }
                rule = new Rule();
                rule.setRuleName(name);
            } else {
                int n = this.lbRules.getSelectionIndex();
                if (n == -1) {
                    return;
                }
                rule = this.rules.get(n);
            }
            RuleDialog dlg = new RuleDialog(this.shell, this.help, rule, this.getRegexOptions());
            if (!dlg.showDialog()) {
                return;
            }
            rule = dlg.getRule();
            if (newRule) {
                this.rules.add(rule);
                this.lbRules.add(rule.getRuleName());
                this.lbRules.select(this.lbRules.getItemCount() - 1);
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
        finally {
            this.updateRule();
            this.updateRuleButtons();
        }
    }

    private void removeRule() {
        int n = this.lbRules.getSelectionIndex();
        if (n == -1) {
            return;
        }
        this.ruleIndex = -1;
        this.rules.remove(n);
        this.lbRules.remove(n);
        if (n > this.lbRules.getItemCount() - 1) {
            n = this.lbRules.getItemCount() - 1;
        }
        this.lbRules.select(n);
        this.updateRule();
        this.updateRuleButtons();
    }

    private void moveUpRule() {
        int n = this.lbRules.getSelectionIndex();
        if (n < 1) {
            return;
        }
        this.saveRuleData(this.ruleIndex);
        this.ruleIndex = -1;
        Rule tmp = this.rules.get(n);
        this.rules.set(n, this.rules.get(n - 1));
        this.rules.set(n - 1, tmp);
        this.lbRules.setItem(n, this.rules.get(n).getRuleName());
        this.lbRules.setItem(n - 1, this.rules.get(n - 1).getRuleName());
        this.lbRules.select(n - 1);
        this.updateRule();
        this.updateRuleButtons();
    }

    private void moveDownRule() {
        int n = this.lbRules.getSelectionIndex();
        if (n < 0) {
            return;
        }
        this.saveRuleData(this.ruleIndex);
        this.ruleIndex = -1;
        Rule tmp = this.rules.get(n);
        this.rules.set(n, this.rules.get(n + 1));
        this.rules.set(n + 1, tmp);
        this.lbRules.setItem(n, this.rules.get(n).getRuleName());
        this.lbRules.setItem(n + 1, this.rules.get(n + 1).getRuleName());
        this.lbRules.select(n + 1);
        this.updateRule();
        this.updateRuleButtons();
    }

    private void setData() {
        this.pnlLD.setOptions(this.params.getLocalizationDirectives().useLD(), this.params.getLocalizationDirectives().localizeOutside());
        this.edStartString.setText(this.params.getStartString());
        this.edEndString.setText(this.params.getEndString());
        this.chkRemoveBSlashEscape.setSelection(this.params.getRemoveBSlashEscape());
        this.chkUseBSlashEscape.setSelection(this.params.getUseBSlashEscape());
        this.chkUseDoubleCharEscape.setSelection(this.params.getUseDoubleCharEscape());
        this.edMimeType.setText(this.params.getMimeType());
        this.edSubFilter.setText(this.params.getSubFilter());
        for (Rule rule : this.rules) {
            this.lbRules.add(rule.getRuleName());
        }
        this.chkOneLevelGroups.setSelection(this.params.getOneLevelGroups());
        int tmp = this.params.getRegexOptions();
        this.chkDotAll.setSelection((tmp & 0x20) == 32);
        this.chkIgnoreCase.setSelection((tmp & 2) == 2);
        this.chkMultiline.setSelection((tmp & 8) == 8);
        this.pnlLD.updateDisplay();
        if (this.lbRules.getItemCount() > 0) {
            this.lbRules.select(0);
        }
        this.updateRule();
        this.updateRuleButtons();
    }

    private void saveData() {
        this.saveRuleData(this.ruleIndex);
        this.params.getLocalizationDirectives().setOptions(this.pnlLD.getUseLD(), this.pnlLD.getLocalizeOutside());
        this.params.setStartString(this.edStartString.getText());
        this.params.setEndString(this.edEndString.getText());
        this.params.setRemoveBSlashEscape(this.chkRemoveBSlashEscape.getSelection());
        this.params.setUseBSlashEscape(this.chkUseBSlashEscape.getSelection());
        this.params.setUseDoubleCharEscape(this.chkUseDoubleCharEscape.getSelection());
        this.params.setMimeType(this.edMimeType.getText());
        this.params.setSubFilter(this.edSubFilter.getText());
        ArrayList paramRules = this.params.getRules();
        paramRules.clear();
        paramRules.addAll(this.rules);
        this.params.setOneLevelGroups(this.chkOneLevelGroups.getSelection());
        this.params.setRegexOptions(this.getRegexOptions());
        this.result = true;
    }

    private int getRegexOptions() {
        int tmp = 0;
        if (this.chkDotAll.getSelection()) {
            tmp |= 0x20;
        }
        if (this.chkIgnoreCase.getSelection()) {
            tmp |= 2;
        }
        if (this.chkMultiline.getSelection()) {
            tmp |= 8;
        }
        return tmp;
    }
}

