/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.transifex.ui;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.filters.transifex.IProjectEditor;
import net.sf.okapi.filters.transifex.Project;
import net.sf.okapi.filters.transifex.ui.ProjectTableModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ProjectDialog
implements IProjectEditor {
    private Shell shell;
    private Project project;
    private ProjectTableModel tableMod;
    private SelectionAdapter CloseActions;
    private boolean result;
    private Text edHost;
    private Text edProjectId;
    private Text edUser;
    private Text edPassword;
    private Text edSource;
    private Text edTarget;
    private Button chkProtectApproved;

    private void create(Shell parent, boolean inProcess) {
        this.result = false;
        this.shell = new Shell(parent, 65648);
        this.shell.setText("Transifex Project");
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout((Layout)new GridLayout());
        Composite cmpTmp = new Composite((Composite)this.shell, 2048);
        cmpTmp.setLayout((Layout)new GridLayout(4, false));
        cmpTmp.setLayoutData((Object)new GridData(768));
        Label label = new Label(cmpTmp, 0);
        label.setText("Project Id:");
        label.setLayoutData((Object)new GridData(128));
        this.edProjectId = new Text(cmpTmp, 2048);
        this.edProjectId.setLayoutData((Object)new GridData(768));
        label = new Label(cmpTmp, 0);
        label.setText("Host:");
        label.setLayoutData((Object)new GridData(128));
        this.edHost = new Text(cmpTmp, 2048);
        this.edHost.setLayoutData((Object)new GridData(768));
        label = new Label(cmpTmp, 0);
        label.setText("Source:");
        label.setLayoutData((Object)new GridData(128));
        this.edSource = new Text(cmpTmp, 2048);
        this.edSource.setLayoutData((Object)new GridData(768));
        this.edSource.setEditable(false);
        label = new Label(cmpTmp, 0);
        label.setText("User name:");
        label.setLayoutData((Object)new GridData(128));
        this.edUser = new Text(cmpTmp, 2048);
        this.edUser.setLayoutData((Object)new GridData(768));
        label = new Label(cmpTmp, 0);
        label.setText("Target:");
        label.setLayoutData((Object)new GridData(128));
        this.edTarget = new Text(cmpTmp, 2048);
        this.edTarget.setLayoutData((Object)new GridData(768));
        this.edTarget.setEditable(false);
        label = new Label(cmpTmp, 0);
        label.setText("Password:");
        label.setLayoutData((Object)new GridData(128));
        this.edPassword = new Text(cmpTmp, 2048);
        this.edPassword.setLayoutData((Object)new GridData(768));
        this.edPassword.setEchoChar('*');
        this.chkProtectApproved = new Button(cmpTmp, 32);
        this.chkProtectApproved.setText("Protect approved entries (entries not empty and not fuzzy)");
        GridData gdTmp = new GridData();
        gdTmp.horizontalSpan = 4;
        this.chkProtectApproved.setLayoutData((Object)gdTmp);
        Button btRefresh = UIUtil.createGridButton((Composite)this.shell, 8, "Refresh Resources List", 160, 1);
        btRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectDialog.this.refresh();
            }
        });
        cmpTmp = new Composite((Composite)this.shell, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        cmpTmp.setLayout((Layout)layout);
        cmpTmp.setLayoutData((Object)new GridData(1808));
        Table tableDocs = new Table(cmpTmp, 68130);
        gdTmp = new GridData(1808);
        gdTmp.minimumHeight = 300;
        gdTmp.minimumWidth = 550;
        tableDocs.setLayoutData((Object)gdTmp);
        tableDocs.setHeaderVisible(true);
        tableDocs.setLinesVisible(true);
        this.tableMod = new ProjectTableModel();
        this.tableMod.linkTable(tableDocs);
        this.CloseActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    Util.openWikiTopic((String)"Transifex Filter");
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    ProjectDialog.this.saveData();
                    ProjectDialog.this.project.save();
                    ProjectDialog.this.result = true;
                }
                ProjectDialog.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, this.CloseActions, true, inProcess ? "Continue" : "OK");
        pnlActions.setLayoutData(new GridData(768));
        this.shell.setDefaultButton(btRefresh);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 450) {
            startSize.x = 450;
        }
        this.shell.setSize(startSize);
        Rectangle rect = tableDocs.getClientArea();
        int nPart = rect.width / 100;
        tableDocs.getColumn(0).setWidth(55 * nPart);
        tableDocs.getColumn(1).setWidth(rect.width - 55 * nPart);
        Dialogs.centerWindow(this.shell, parent);
    }

    private void setData(Project project) {
        this.project = project;
        this.edHost.setText(project.getHost());
        this.edProjectId.setText(project.getProjectId());
        this.edUser.setText(project.getUser());
        this.edPassword.setText(project.getPassword());
        this.edSource.setText(project.getSourceLocale().toString());
        this.edTarget.setText(project.getTargetLocale().toString());
        this.chkProtectApproved.setSelection(project.getProtectApproved());
    }

    private boolean saveData() {
        String tmp = this.edHost.getText().trim();
        if (tmp.isEmpty()) {
            return false;
        }
        this.project.setHost(tmp);
        tmp = this.edUser.getText().trim();
        if (tmp.isEmpty()) {
            return false;
        }
        this.project.setUser(tmp);
        tmp = this.edPassword.getText().trim();
        if (tmp.isEmpty()) {
            return false;
        }
        this.project.setPassword(tmp);
        tmp = this.edProjectId.getText().trim();
        if (tmp.isEmpty()) {
            return false;
        }
        this.project.setProjectId(tmp);
        tmp = this.edSource.getText().trim();
        if (tmp.isEmpty()) {
            return false;
        }
        this.project.setSourceLocale(LocaleId.fromString((String)tmp));
        tmp = this.edTarget.getText().trim();
        if (tmp.isEmpty()) {
            return false;
        }
        this.project.setTargetLocale(LocaleId.fromString((String)tmp));
        this.project.setProtectApproved(this.chkProtectApproved.getSelection());
        this.tableMod.saveData();
        return true;
    }

    private boolean showDialog(Project project) {
        this.tableMod.setProject(project);
        this.setData(project);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    public boolean edit(Object parent, Project project, boolean inProcess) {
        Shell shell = null;
        if (parent != null && parent instanceof Shell) {
            shell = (Shell)parent;
        }
        this.create(shell, inProcess);
        boolean res = this.showDialog(project);
        return res;
    }

    private void refresh() {
        try {
            if (!this.saveData()) {
                return;
            }
            this.project.refreshResources(false);
            this.tableMod.setProject(this.project);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error during the refresh:\n" + e.getMessage(), null);
        }
    }
}

