/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.transifex.ui;

import java.util.List;
import net.sf.okapi.filters.transifex.Project;
import net.sf.okapi.lib.transifex.ResourceInfo;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class ProjectTableModel {
    private Table table;
    private Project project;

    ProjectTableModel() {
    }

    public void linkTable(Table newTable) {
        this.table = newTable;
        TableColumn col = new TableColumn(this.table, 0);
        col.setText("Resource to Process");
        col = new TableColumn(this.table, 0);
        col.setText("Resource ID");
    }

    public void setProject(Project project) {
        this.project = project;
        this.updateTable(null, 0);
    }

    void updateTable(int[] selection, int index) {
        this.table.removeAll();
        for (ResourceInfo info : this.project.getResources()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, info.getName());
            item.setText(1, info.getId());
            item.setChecked(info.getSelected());
        }
        if (selection == null) {
            if (this.table.getItemCount() > 0) {
                if (index > -1) {
                    if (index > this.table.getItemCount() - 1) {
                        index = this.table.getItemCount() - 1;
                    }
                } else {
                    index = 0;
                }
                this.table.setSelection(index);
            }
        } else {
            this.table.setSelection(selection);
        }
    }

    public void saveData() {
        List list = this.project.getResources();
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            ResourceInfo info = (ResourceInfo)list.get(i);
            info.setSelected(this.table.getItem(i).getChecked());
        }
    }
}

