/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff.ui;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.filters.InlineCodeFinderPanel;
import net.sf.okapi.filters.xliff.Parameters;
import net.sf.okapi.filters.xliff.ui.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class Editor
implements IParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private InlineCodeFinderPanel pnlCodeFinder;
    private IHelp help;
    private Button chkFallBackToId;
    private Button chkIgnoreInputSegmentation;
    private Button chkAlwaysUseSegSource;
    private Button chkUseSdlXliffWriter;
    private Button chkEscapeGt;
    private Button chkAddTargetLanguage;
    private Button chkOverrideTargetLanguage;
    private Button chkAllowEmptyTargets;
    private List listOutputSegmentationType;
    private Button chkAddAltTrans;
    private Button chkIncludeITS;
    private Button chkBalanceCodes;
    private Button chkPreserveSpaceByDefault;
    private Button chkInlineCdata;
    private Button chkSkipNoMrkSegSource;
    private Button chkUseCustomParser;
    private Button chkUseTranslationTargetState;
    private Text edSubfilterId;
    private Text edPcdataSubfilterId;
    private Button chkUseCodeFinder;
    private Text edCustomParserClass;
    private Button chkAlwaysAddTargets;
    private Button chkForceUniqueIds;
    private Button chkUseIwsXliffWriter;
    private Button chkIwsBlockFinished;
    private Text edTransStatusValue;
    private Button chkIwsRemoveTmOrigin;
    private Text edTransTypeValue;
    private Button chkIwsBlockLockStatus;
    private Button chkIwsBlockTmScore;
    private Text edIwsBlockTmScoreValue;
    private Button chkIwsIncludeMultipleExact;
    private Button chkIwsBlockMultipleExact;
    private static EnumMap<Parameters.SegmentationType, String> segTypeMap = new EnumMap(Parameters.SegmentationType.class);

    private static Optional<Parameters.SegmentationType> getSegTypeForLabel(String label) {
        return segTypeMap.entrySet().stream().filter(e -> ((String)e.getValue()).equals(label)).findFirst().map(Map.Entry::getKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        this.help = (IHelp)context.getObject("help");
        boolean bRes = false;
        this.shell = null;
        this.params = (Parameters)params;
        try {
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText(Res.getString("EditorCaption"));
        if (parent != null) {
            this.shell.setImage(parent.getImage());
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        TabFolder tfTmp = new TabFolder((Composite)this.shell, 0);
        GridData gdTmp = new GridData(1808);
        tfTmp.setLayoutData((Object)gdTmp);
        Composite cmpTmp = new Composite((Composite)tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout((Layout)layTmp);
        Group grpTmp = new Group(cmpTmp, 0);
        layTmp = new GridLayout();
        grpTmp.setLayout((Layout)layTmp);
        gdTmp = new GridData(768);
        grpTmp.setLayoutData((Object)gdTmp);
        this.chkFallBackToId = new Button((Composite)grpTmp, 32);
        this.chkFallBackToId.setText(Res.getString("fallBackToId"));
        this.chkIgnoreInputSegmentation = new Button((Composite)grpTmp, 32);
        this.chkIgnoreInputSegmentation.setText(Res.getString("ignoreInputSegmentation"));
        this.chkAlwaysUseSegSource = new Button((Composite)grpTmp, 32);
        this.chkAlwaysUseSegSource.setText(Res.getString("alwaysUseSegSource"));
        this.chkUseSdlXliffWriter = new Button((Composite)grpTmp, 32);
        this.chkUseSdlXliffWriter.setText(Res.getString("useSdlXliffWriter"));
        this.chkEscapeGt = new Button((Composite)grpTmp, 32);
        this.chkEscapeGt.setText(Res.getString("escapeGt"));
        this.chkAddTargetLanguage = new Button((Composite)grpTmp, 32);
        this.chkAddTargetLanguage.setText(Res.getString("addTargetLanguage"));
        this.chkOverrideTargetLanguage = new Button((Composite)grpTmp, 32);
        this.chkOverrideTargetLanguage.setText(Res.getString("overrideTargetLanguage"));
        this.chkAllowEmptyTargets = new Button((Composite)grpTmp, 32);
        this.chkAllowEmptyTargets.setText(Res.getString("allowEmptyTargets"));
        this.chkPreserveSpaceByDefault = new Button((Composite)grpTmp, 32);
        this.chkPreserveSpaceByDefault.setText(Res.getString("preserveSpaceByDefault"));
        this.chkInlineCdata = new Button((Composite)grpTmp, 32);
        this.chkInlineCdata.setText(Res.getString("inlineCdata"));
        this.chkSkipNoMrkSegSource = new Button((Composite)grpTmp, 32);
        this.chkSkipNoMrkSegSource.setText(Res.getString("skipNoMrkSegSource"));
        Label label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("outputSegmentationType"));
        this.listOutputSegmentationType = new List((Composite)grpTmp, 2048);
        GridData gd_listOutputSegmentationType = new GridData(4, 4, true, true, 1, 1);
        gd_listOutputSegmentationType.heightHint = 80;
        this.listOutputSegmentationType.setLayoutData((Object)gd_listOutputSegmentationType);
        this.listOutputSegmentationType.setItems(segTypeMap.values().toArray(new String[0]));
        this.chkIncludeITS = new Button((Composite)grpTmp, 32);
        this.chkIncludeITS.setText(Res.getString("includeITS"));
        this.chkBalanceCodes = new Button((Composite)grpTmp, 32);
        this.chkBalanceCodes.setText(Res.getString("balanceCodes"));
        this.chkAddAltTrans = new Button((Composite)grpTmp, 32);
        this.chkAddAltTrans.setText(Res.getString("addAltTrans"));
        this.chkUseCustomParser = new Button((Composite)grpTmp, 32);
        this.chkUseCustomParser.setText(Res.getString("useCustomParser"));
        label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("customParserClass"));
        this.edCustomParserClass = new Text((Composite)grpTmp, 2048);
        gdTmp = new GridData(768);
        this.edCustomParserClass.setLayoutData((Object)gdTmp);
        this.chkUseCustomParser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.edCustomParserClass.setEnabled(Editor.this.chkUseCustomParser.getSelection());
            }
        });
        this.chkUseTranslationTargetState = new Button((Composite)grpTmp, 32);
        this.chkUseTranslationTargetState.setText(Res.getString("useTranslationTargetState"));
        this.chkAlwaysAddTargets = new Button((Composite)grpTmp, 32);
        this.chkAlwaysAddTargets.setText(Res.getString("alwaysAddTargets"));
        this.chkForceUniqueIds = new Button((Composite)grpTmp, 32);
        this.chkForceUniqueIds.setText(Res.getString("forceUniqueIds"));
        this.chkUseIwsXliffWriter = new Button((Composite)grpTmp, 32);
        this.chkUseIwsXliffWriter.setText(Res.getString("useIwsXliffWriter"));
        this.chkUseIwsXliffWriter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.chkIwsBlockFinished.setEnabled(Editor.this.chkUseIwsXliffWriter.getSelection());
                Editor.this.edTransStatusValue.setEnabled(Editor.this.chkUseIwsXliffWriter.getSelection());
                Editor.this.edTransTypeValue.setEnabled(Editor.this.chkUseIwsXliffWriter.getSelection());
                Editor.this.chkIwsRemoveTmOrigin.setEnabled(Editor.this.chkUseIwsXliffWriter.getSelection());
                Editor.this.chkIwsBlockLockStatus.setEnabled(Editor.this.chkUseIwsXliffWriter.getSelection());
                Editor.this.chkIwsBlockTmScore.setEnabled(Editor.this.chkUseIwsXliffWriter.getSelection());
                Editor.this.edIwsBlockTmScoreValue.setEnabled(Editor.this.chkUseIwsXliffWriter.getSelection());
                Editor.this.chkIwsIncludeMultipleExact.setEnabled(Editor.this.chkUseIwsXliffWriter.getSelection());
                Editor.this.chkIwsBlockMultipleExact.setEnabled(Editor.this.chkUseIwsXliffWriter.getSelection());
            }
        });
        this.chkIwsBlockFinished = new Button((Composite)grpTmp, 32);
        this.chkIwsBlockFinished.setText(Res.getString("iwsBlockFinished"));
        label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("iwsTransStatusValue"));
        this.edTransStatusValue = new Text((Composite)grpTmp, 2048);
        this.edTransStatusValue.setLayoutData((Object)gdTmp);
        label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("iwsTransTypeValue"));
        this.edTransTypeValue = new Text((Composite)grpTmp, 2048);
        this.edTransTypeValue.setLayoutData((Object)gdTmp);
        this.chkIwsRemoveTmOrigin = new Button((Composite)grpTmp, 32);
        this.chkIwsRemoveTmOrigin.setText(Res.getString("iwsRemoveTmOrigin"));
        this.chkIwsBlockLockStatus = new Button((Composite)grpTmp, 32);
        this.chkIwsBlockLockStatus.setText(Res.getString("iwsBlockLockStatus"));
        this.chkIwsBlockTmScore = new Button((Composite)grpTmp, 32);
        this.chkIwsBlockTmScore.setText(Res.getString("iwsBlockTmScore"));
        label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("iwsBlockTmScoreValue"));
        this.chkIwsBlockTmScore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.edIwsBlockTmScoreValue.setEnabled(Editor.this.chkIwsBlockTmScore.getSelection());
                Editor.this.chkIwsIncludeMultipleExact.setEnabled(Editor.this.chkIwsBlockTmScore.getSelection());
            }
        });
        this.edIwsBlockTmScoreValue = new Text((Composite)grpTmp, 2048);
        this.edIwsBlockTmScoreValue.setLayoutData((Object)gdTmp);
        this.chkIwsIncludeMultipleExact = new Button((Composite)grpTmp, 32);
        this.chkIwsIncludeMultipleExact.setText(Res.getString("iwsIncludeMultipleExact"));
        this.chkIwsBlockMultipleExact = new Button((Composite)grpTmp, 32);
        this.chkIwsBlockMultipleExact.setText(Res.getString("iwsBlockMultipleExact"));
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText(Res.getString("tabOptions"));
        tiTmp.setControl((Control)cmpTmp);
        cmpTmp = new Composite((Composite)tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout((Layout)layTmp);
        grpTmp = new Group(cmpTmp, 0);
        grpTmp.setLayout((Layout)layTmp);
        gdTmp = new GridData(768);
        grpTmp.setLayoutData((Object)gdTmp);
        label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("cdataSubfilter"));
        this.edSubfilterId = new Text((Composite)grpTmp, 2048);
        gdTmp = new GridData(768);
        this.edSubfilterId.setLayoutData((Object)gdTmp);
        label = new Label((Composite)grpTmp, 0);
        label.setText(Res.getString("pcdataSubfilter"));
        this.edPcdataSubfilterId = new Text((Composite)grpTmp, 2048);
        gdTmp = new GridData(768);
        this.edPcdataSubfilterId.setLayoutData((Object)gdTmp);
        this.chkUseCodeFinder = new Button((Composite)grpTmp, 32);
        this.chkUseCodeFinder.setText(Res.getString("codeFinder"));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateInlineCodes();
            }
        };
        this.chkUseCodeFinder.addSelectionListener((SelectionListener)listener);
        this.chkUseCodeFinder.addSelectionListener((SelectionListener)listener);
        this.pnlCodeFinder = new InlineCodeFinderPanel((Composite)grpTmp, 0);
        this.pnlCodeFinder.setLayoutData(new GridData(1808));
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText(Res.getString("tabEmbeddedContent"));
        tiTmp.setControl((Control)cmpTmp);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("XLIFF Filter");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!Editor.this.saveData()) {
                        return;
                    }
                    Editor.this.result = true;
                }
                Editor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true);
        gdTmp = new GridData(768);
        this.pnlActions.setLayoutData(gdTmp);
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Dialogs.centerWindow(this.shell, parent);
        this.setData();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.chkFallBackToId.setSelection(this.params.getFallbackToID());
        this.chkIgnoreInputSegmentation.setSelection(this.params.getIgnoreInputSegmentation());
        this.chkAlwaysUseSegSource.setSelection(this.params.isAlwaysUseSegSource());
        this.chkUseSdlXliffWriter.setSelection(this.params.isUseSdlXliffWriter());
        this.chkEscapeGt.setSelection(this.params.getEscapeGT());
        this.chkAddTargetLanguage.setSelection(this.params.getAddTargetLanguage());
        this.chkOverrideTargetLanguage.setSelection(this.params.getOverrideTargetLanguage());
        this.chkAllowEmptyTargets.setSelection(this.params.getAllowEmptyTargets());
        this.listOutputSegmentationType.setSelection(new String[]{segTypeMap.get(this.params.getOutputSegmentationType())});
        this.chkAddAltTrans.setSelection(this.params.getAddAltTrans());
        this.chkIncludeITS.setSelection(this.params.getIncludeIts());
        this.chkPreserveSpaceByDefault.setSelection(this.params.isPreserveSpaceByDefault());
        this.chkInlineCdata.setSelection(this.params.isInlineCdata());
        this.chkSkipNoMrkSegSource.setSelection(this.params.getSkipNoMrkSegSource());
        this.chkUseCustomParser.setSelection(this.params.getUseCustomParser());
        this.edCustomParserClass.setText(this.params.getFactoryClass() == null ? "" : this.params.getFactoryClass());
        this.chkUseTranslationTargetState.setSelection(this.params.getUseTranslationTargetState());
        this.chkAlwaysAddTargets.setSelection(this.params.getAlwaysAddTargets());
        this.chkForceUniqueIds.setSelection(this.params.getForceUniqueIds());
        this.chkUseIwsXliffWriter.setSelection(this.params.isUseIwsXliffWriter());
        this.chkIwsBlockFinished.setSelection(this.params.isIwsBlockFinished());
        this.edTransStatusValue.setText(this.params.getIwsTransStatusValue() == null ? "" : this.params.getIwsTransStatusValue());
        this.edTransTypeValue.setText(this.params.getIwsTransTypeValue() == null ? "" : this.params.getIwsTransTypeValue());
        this.chkIwsRemoveTmOrigin.setSelection(this.params.isIwsRemoveTmOrigin());
        this.chkIwsBlockLockStatus.setSelection(this.params.isIwsBlockLockStatus());
        this.chkIwsBlockTmScore.setSelection(this.params.isIwsBlockTmScore());
        this.edIwsBlockTmScoreValue.setText(this.params.getIwsBlockTmScoreValue() == null ? "" : this.params.getIwsBlockTmScoreValue());
        this.chkIwsBlockMultipleExact.setSelection(this.params.isIwsBlockMultipleExact());
        this.chkIwsIncludeMultipleExact.setSelection(this.params.isIwsIncludeMultipleExact());
        this.edSubfilterId.setText(this.params.getCdataSubfilter() == null ? "" : this.params.getCdataSubfilter());
        this.edPcdataSubfilterId.setText(this.params.getPcdataSubfilter() == null ? "" : this.params.getPcdataSubfilter());
        this.chkUseCodeFinder.setSelection(this.params.getUseCodeFinder());
        this.pnlCodeFinder.setRules(this.params.getCodeFinderData());
        this.updateInlineCodes();
        this.pnlCodeFinder.updateDisplay();
    }

    private boolean saveData() {
        this.params.setUseCodeFinder(this.chkUseCodeFinder.getSelection());
        if (this.chkUseCodeFinder.getSelection()) {
            if (this.pnlCodeFinder.getRules() == null) {
                return false;
            }
            this.params.setCodeFinderData(this.pnlCodeFinder.getRules());
        }
        this.params.setFallbackToID(this.chkFallBackToId.getSelection());
        this.params.setIgnoreInputSegmentation(this.chkIgnoreInputSegmentation.getSelection());
        this.params.setAlwaysUseSegSource(this.chkAlwaysUseSegSource.getSelection());
        this.params.setUseSdlXliffWriter(this.chkUseSdlXliffWriter.getSelection());
        this.params.setEscapeGT(this.chkEscapeGt.getSelection());
        this.params.setAddTargetLanguage(this.chkAddTargetLanguage.getSelection());
        this.params.setOverrideTargetLanguage(this.chkOverrideTargetLanguage.getSelection());
        this.params.setAllowEmptyTargets(this.chkAllowEmptyTargets.getSelection());
        String[] segTypes = this.listOutputSegmentationType.getSelection();
        if (segTypes.length > 0) {
            Editor.getSegTypeForLabel(segTypes[0]).ifPresent(type -> this.params.setOutputSegmentationType(type));
        }
        this.params.setAddAltTrans(this.chkAddAltTrans.getSelection());
        this.params.setIncludeIts(this.chkIncludeITS.getSelection());
        this.params.setPreserveSpaceByDefault(this.chkPreserveSpaceByDefault.getSelection());
        this.params.setInlineCdata(this.chkInlineCdata.getSelection());
        this.params.setSkipNoMrkSegSource(this.chkSkipNoMrkSegSource.getSelection());
        this.params.setUseCustomParser(this.chkUseCustomParser.getSelection());
        this.params.setFactoryClass(this.edCustomParserClass.getText());
        this.params.setCdataSubfilter(this.edSubfilterId.getText());
        this.params.setPcdataSubfilter(this.edPcdataSubfilterId.getText());
        this.params.setUseTranslationTargetState(this.chkUseTranslationTargetState.getSelection());
        this.params.setAlwaysAddTargets(this.chkAlwaysAddTargets.getSelection());
        this.params.setForceUniqueIds(this.chkForceUniqueIds.getSelection());
        this.params.setUseIwsXliffWriter(this.chkUseIwsXliffWriter.getSelection());
        this.params.setIwsBlockFinished(this.chkIwsBlockFinished.getSelection());
        this.params.setIwsTransStatusValue(this.edTransStatusValue.getText());
        this.params.setIwsRemoveTmOrigin(this.chkIwsRemoveTmOrigin.getSelection());
        this.params.setIwsTransTypeValue(this.edTransTypeValue.getText());
        this.params.setIwsBlockLockStatus(this.chkIwsBlockLockStatus.getSelection());
        this.params.setIwsBlockTmScore(this.chkIwsBlockTmScore.getSelection());
        this.params.setIwsBlockTmScoreValue(this.edIwsBlockTmScoreValue.getText());
        this.params.setIwsBlockMultipleExact(this.chkIwsBlockMultipleExact.getSelection());
        this.params.setIwsIncludeMultipleExact(this.chkIwsIncludeMultipleExact.getSelection());
        return true;
    }

    private void updateInlineCodes() {
        this.pnlCodeFinder.setEnabled(this.chkUseCodeFinder.getSelection());
    }

    static {
        segTypeMap.put(Parameters.SegmentationType.ORIGINAL, Res.getString("segType_original"));
        segTypeMap.put(Parameters.SegmentationType.SEGMENTED, Res.getString("segType_always"));
        segTypeMap.put(Parameters.SegmentationType.NOTSEGMENTED, Res.getString("segType_never"));
        segTypeMap.put(Parameters.SegmentationType.ASNEEDED, Res.getString("segType_asNeeded"));
    }
}

