/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.verification;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.TextAndBrowsePanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.ui.verification.StringListPanel;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.PatternItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class ParametersEditor
implements IParametersEditor,
ISWTEmbeddableParametersEditor {
    private static final int TAB_CHARACTERS = 4;
    private static final int TAB_LANGUAGETOOL = 5;
    private static final int TAB_TERMS = 6;
    private static final int TAB_OTHER = 7;
    private static final int INFOCOLWIDTH = 120;
    private static final String FROMSOURCE = "Src";
    private static final String FROMTARGET = "Trg";
    private static final String SINGLEPATTERN_TRUE = "1Pat";
    private static final String SINGLEPATTERN_FALSE = "2Pat";
    private static final int STARTSINGLEPATTERN = 4;
    private static final int STARTSEVERITY = 9;
    private static final String NODESC_LABEL = "<Enter description here>";
    private static final String[] severityNames = new String[]{"LOW", "MEDIUM", "HIGH"};
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private IHelp help;
    private TabFolder tabs;
    private Button chkAutoOpen;
    private Button chkShowFullPath;
    private Button chkUseGenericCodes;
    private Button chkLeadingWS;
    private Button chkTrailingWS;
    private Button chkEmptyTarget;
    private Button chkEmptySource;
    private Button chkTargetSameAsSource;
    private Button chkTargetSameAsSourceForSameLanguage;
    private Button chkTargetSameAsSourceWithCodes;
    private Button chkTargetSameAsSourceWithNumbers;
    private Composite mainComposite;
    private TextAndBrowsePanel pnlOutputPath;
    private Combo cbOutputType;
    private Combo cbCheckXliffSchema;
    private Button chkPatterns;
    private Button chkDoubledWord;
    private Label stDoubledWordExceptions;
    private Text edDoubledWordExceptions;
    private Text edTypesToIgnore;
    private Button chkCorruptedChars;
    private Table table;
    private Button btAdd;
    private Button btEdit;
    private Button btRemove;
    private Button btMoveUp;
    private Button btMoveDown;
    private Button btImport;
    private Button btExport;
    private Text edSource;
    private Text edTarget;
    private Text edDescription;
    private Combo cbSeverity;
    private Button chkFromSource;
    private Button chkSinglePattern;
    private Shell dialog;
    private TableItem editItem;
    private boolean addMode;
    private Button chkCheckWithLT;
    private Text edServerURL;
    private Button chkLTBilingualMode;
    private Button chkStorageSize;
    private Button chkAbsoluteMaxCharLength;
    private Spinner spAbsoluteMaxCharLength;
    private Button chkMaxCharLength;
    private Composite cmpMaxCharLength;
    private Spinner spMaxCharLengthBreak;
    private Spinner spMaxCharLengthAbove;
    private Spinner spMaxCharLengthBelow;
    private Button chkMinCharLength;
    private Composite cmpMinCharLength;
    private Spinner spMinCharLengthBreak;
    private Spinner spMinCharLengthAbove;
    private Spinner spMinCharLengthBelow;
    private Button chkCheckAllowedCharacters;
    private Button chkCheckCharacters;
    private Text edCharset;
    private Label stExtraCharsAllowed;
    private Text edExtraCharsAllowed;
    private Button rdScopeAllEntries;
    private Button rdScopeApprovedOnly;
    private Button rdScopeNotApprovedOnly;
    private Button btStartLT;
    private Button chkCodeDifference;
    private Button chkGuessOpenClose;
    private Button chkStrictCodeOrder;
    private StringListPanel pnlMissingCodesAllowed;
    private StringListPanel pnlExtraCodesAllowed;
    private Button chkCheckTerms;
    private Label stTermPath;
    private TextAndBrowsePanel pnlTermsPath;
    private Button chkStringMode;
    private Button chkBetweenCodes;
    private Button chkCheckBlacklist;
    private Label stBlacklistPath;
    private Button chkAllowBlacklistSub;
    private Button chkBlacklistSrc;
    private TextAndBrowsePanel pnlBlacklistPath;
    private boolean stepMode = true;
    private TextAndBrowsePanel pnlSessionPath;
    private Button chkSaveSession;

    public ParametersEditor() {
    }

    public ParametersEditor(boolean stepMode) {
        this.stepMode = stepMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.shell = null;
            this.help = (IHelp)context.getObject("help");
            this.stepMode = context.getBoolean("stepMode");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    @Override
    public void initializeEmbeddableEditor(Composite parent, IParameters paramsObject, IContext context) {
        this.params = (Parameters)paramsObject;
        this.shell = (Shell)context.getObject("shell");
        this.createComposite(parent);
        this.setData();
    }

    public String validateAndSaveParameters() {
        if (!this.saveData()) {
            return null;
        }
        return this.params.toString();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("Quality Check Configuration");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        this.createComposite((Composite)this.shell);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (ParametersEditor.this.help != null) {
                        ParametersEditor.this.help.showWiki("CheckMate - Quality Check Configuration");
                    }
                    return;
                }
                if (e.widget.getData().equals("o") && !ParametersEditor.this.saveData()) {
                    return;
                }
                ParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Dialogs.centerWindow(this.shell, parent);
        this.setData();
    }

    private void createComposite(Composite parent) {
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayout((Layout)new GridLayout());
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.tabs = new TabFolder(this.mainComposite, 0);
        this.tabs.setLayout((Layout)new GridLayout());
        GridData gdTmp = new GridData(1808);
        gdTmp.heightHint = 500;
        this.tabs.setLayoutData((Object)gdTmp);
        Composite cmpTmp = new Composite((Composite)this.tabs, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        Group grpTU = new Group(cmpTmp, 0);
        grpTU.setText("Text unit verifications");
        grpTU.setLayoutData((Object)new GridData(768));
        grpTU.setLayout((Layout)new GridLayout());
        Button chkTmp = new Button((Composite)grpTU, 32);
        chkTmp.setText("[Always On] Warn if an entry does not have a translation");
        chkTmp.setSelection(true);
        chkTmp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((Button)e.getSource()).setSelection(true);
            }
        });
        this.chkLeadingWS = new Button((Composite)grpTU, 32);
        this.chkLeadingWS.setText("Warn if a target entry has a difference in leading white spaces");
        this.chkTrailingWS = new Button((Composite)grpTU, 32);
        this.chkTrailingWS.setText("Warn if a target entry has a difference in trailing white spaces");
        Group grpSeg = new Group(cmpTmp, 0);
        grpSeg.setText("Segment verifications");
        grpSeg.setLayoutData((Object)new GridData(768));
        grpSeg.setLayout((Layout)new GridLayout());
        chkTmp = new Button((Composite)grpSeg, 32);
        chkTmp.setText("[Always On] Warn if a source segment does not have a corresponding target");
        chkTmp.setSelection(true);
        chkTmp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((Button)e.getSource()).setSelection(true);
            }
        });
        chkTmp = new Button((Composite)grpSeg, 32);
        chkTmp.setText("[Always On] Warn if there is an extra target segment");
        chkTmp.setSelection(true);
        chkTmp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((Button)e.getSource()).setSelection(true);
            }
        });
        this.chkEmptyTarget = new Button((Composite)grpSeg, 32);
        this.chkEmptyTarget.setText("Warn if a target segment is empty when its source is not empty");
        this.chkEmptySource = new Button((Composite)grpSeg, 32);
        this.chkEmptySource.setText("Warn if a target segment is not empty when its source is empty");
        this.chkTargetSameAsSource = new Button((Composite)grpSeg, 32);
        this.chkTargetSameAsSource.setText("Warn if a target segment is the same as its source (for segments with text)");
        this.chkTargetSameAsSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateTargetSameAsSourceForSameLanguage();
                ParametersEditor.this.updateTargetSameAsSourceWithCodes();
                ParametersEditor.this.updateTargetSameAsSourceWithNumbers();
            }
        });
        this.chkTargetSameAsSource.setLayoutData((Object)new GridData());
        int horizIndent = 16;
        this.chkTargetSameAsSourceForSameLanguage = new Button((Composite)grpSeg, 32);
        this.chkTargetSameAsSourceForSameLanguage.setText("Verify for same language family (i.e. en vs. en-GB, or fr-FR vs. fr-CA)");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = 16;
        this.chkTargetSameAsSourceForSameLanguage.setLayoutData((Object)gdTmp);
        this.chkTargetSameAsSourceWithCodes = new Button((Composite)grpSeg, 32);
        this.chkTargetSameAsSourceWithCodes.setText("Include the codes in the comparison");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = 16;
        this.chkTargetSameAsSourceWithCodes.setLayoutData((Object)gdTmp);
        this.chkTargetSameAsSourceWithNumbers = new Button((Composite)grpSeg, 32);
        this.chkTargetSameAsSourceWithNumbers.setText("Include the segments with only numbers in the comparison");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = 16;
        this.chkTargetSameAsSourceWithNumbers.setLayoutData((Object)gdTmp);
        this.chkDoubledWord = new Button((Composite)grpSeg, 32);
        this.chkDoubledWord.setText("Warn on doubled words (e.g. \"is is\" in \"This is is an example\")");
        this.chkDoubledWord.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateDoubledWord();
            }
        });
        this.stDoubledWordExceptions = new Label((Composite)grpSeg, 0);
        this.stDoubledWordExceptions.setText("Exceptions (words separated by ';' e.g. \"vous;nous\"):");
        gdTmp = new GridData(768);
        gdTmp.horizontalIndent = 16;
        this.stDoubledWordExceptions.setLayoutData((Object)gdTmp);
        this.edDoubledWordExceptions = new Text((Composite)grpSeg, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalIndent = 16;
        this.edDoubledWordExceptions.setLayoutData((Object)gdTmp);
        Group grpFile = new Group(cmpTmp, 0);
        grpFile.setText("File verification");
        grpFile.setLayoutData((Object)new GridData(768));
        grpFile.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)grpFile, 0).setText("Validate XLIFF documents against schema:");
        this.cbCheckXliffSchema = new Combo((Composite)grpFile, 12);
        this.cbCheckXliffSchema.add("None");
        this.cbCheckXliffSchema.add("Transitional");
        this.cbCheckXliffSchema.add("Strict");
        TabItem tiTmp = new TabItem(this.tabs, 0);
        tiTmp.setText("General");
        tiTmp.setControl((Control)cmpTmp);
        cmpTmp = new Composite((Composite)this.tabs, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        gdTmp = new GridData(1808);
        cmpTmp.setLayoutData((Object)gdTmp);
        this.chkStorageSize = new Button(cmpTmp, 32);
        this.chkStorageSize.setText("Warn if a source or target text unit does not fit its ITS Storage Size property");
        this.chkAbsoluteMaxCharLength = new Button(cmpTmp, 32);
        this.chkAbsoluteMaxCharLength.setText("Warn if a target is longer than:");
        this.chkAbsoluteMaxCharLength.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateAbsoluteMaxCharLength();
            }
        });
        this.spAbsoluteMaxCharLength = new Spinner(cmpTmp, 2048);
        gdTmp = new GridData();
        gdTmp.widthHint = 70;
        gdTmp.horizontalIndent = 16;
        this.spAbsoluteMaxCharLength.setLayoutData((Object)gdTmp);
        this.spAbsoluteMaxCharLength.setMaximum(99999);
        this.spAbsoluteMaxCharLength.setMinimum(0);
        this.chkMaxCharLength = new Button(cmpTmp, 32);
        this.chkMaxCharLength.setText("Warn if a target is longer than the given percentage of the character length of its source:");
        this.chkMaxCharLength.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateMaxCharLength();
            }
        });
        this.cmpMaxCharLength = new Composite(cmpTmp, 0);
        this.cmpMaxCharLength.setLayout((Layout)new GridLayout(2, false));
        Label stTmp = new Label(this.cmpMaxCharLength, 0);
        stTmp.setText("Character length above which a text is considered \"long\":");
        stTmp.setLayoutData((Object)new GridData(128));
        this.spMaxCharLengthBreak = new Spinner(this.cmpMaxCharLength, 2048);
        gdTmp = new GridData();
        gdTmp.widthHint = 70;
        gdTmp.horizontalIndent = 16;
        this.spMaxCharLengthBreak.setLayoutData((Object)gdTmp);
        this.spMaxCharLengthBreak.setMaximum(999);
        this.spMaxCharLengthBreak.setMinimum(1);
        stTmp = new Label(this.cmpMaxCharLength, 0);
        stTmp.setText("Percentage for \"short\" text:");
        stTmp.setLayoutData((Object)new GridData(128));
        this.spMaxCharLengthBelow = new Spinner(this.cmpMaxCharLength, 2048);
        gdTmp = new GridData();
        gdTmp.widthHint = 70;
        gdTmp.horizontalIndent = 16;
        this.spMaxCharLengthBelow.setLayoutData((Object)gdTmp);
        this.spMaxCharLengthBelow.setMaximum(999);
        this.spMaxCharLengthBelow.setMinimum(1);
        stTmp = new Label(this.cmpMaxCharLength, 0);
        stTmp.setText("Percentage for \"long\" text:");
        stTmp.setLayoutData((Object)new GridData(128));
        this.spMaxCharLengthAbove = new Spinner(this.cmpMaxCharLength, 2048);
        gdTmp = new GridData();
        gdTmp.widthHint = 70;
        gdTmp.horizontalIndent = 16;
        this.spMaxCharLengthAbove.setLayoutData((Object)gdTmp);
        this.spMaxCharLengthAbove.setMaximum(999);
        this.spMaxCharLengthAbove.setMinimum(1);
        this.chkMinCharLength = new Button(cmpTmp, 32);
        this.chkMinCharLength.setText("Warn if a target is shorter than the given percentage of the character length of its source:");
        this.chkMinCharLength.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateMinCharLength();
            }
        });
        this.cmpMinCharLength = new Composite(cmpTmp, 0);
        this.cmpMinCharLength.setLayout((Layout)new GridLayout(2, false));
        stTmp = new Label(this.cmpMinCharLength, 0);
        stTmp.setText("Character length above which a text is considered \"long\":");
        stTmp.setLayoutData((Object)new GridData(128));
        this.spMinCharLengthBreak = new Spinner(this.cmpMinCharLength, 2048);
        gdTmp = new GridData();
        gdTmp.widthHint = 70;
        gdTmp.horizontalIndent = 16;
        this.spMinCharLengthBreak.setLayoutData((Object)gdTmp);
        this.spMinCharLengthBreak.setMaximum(999);
        this.spMinCharLengthBreak.setMinimum(1);
        stTmp = new Label(this.cmpMinCharLength, 0);
        stTmp.setText("Percentage for \"short\" text:");
        stTmp.setLayoutData((Object)new GridData(128));
        this.spMinCharLengthBelow = new Spinner(this.cmpMinCharLength, 2048);
        gdTmp = new GridData();
        gdTmp.widthHint = 70;
        gdTmp.horizontalIndent = 16;
        this.spMinCharLengthBelow.setLayoutData((Object)gdTmp);
        this.spMinCharLengthBelow.setMaximum(999);
        this.spMinCharLengthBelow.setMinimum(1);
        stTmp = new Label(this.cmpMinCharLength, 0);
        stTmp.setText("Percentage for \"long\" text:");
        stTmp.setLayoutData((Object)new GridData(128));
        this.spMinCharLengthAbove = new Spinner(this.cmpMinCharLength, 2048);
        gdTmp = new GridData();
        gdTmp.widthHint = 70;
        gdTmp.horizontalIndent = 16;
        this.spMinCharLengthAbove.setLayoutData((Object)gdTmp);
        this.spMinCharLengthAbove.setMaximum(999);
        this.spMinCharLengthAbove.setMinimum(1);
        tiTmp = new TabItem(this.tabs, 0);
        tiTmp.setText("Length");
        tiTmp.setControl((Control)cmpTmp);
        cmpTmp = new Composite((Composite)this.tabs, 0);
        cmpTmp.setLayout((Layout)new GridLayout(2, true));
        gdTmp = new GridData(1808);
        cmpTmp.setLayoutData((Object)gdTmp);
        this.chkCodeDifference = new Button(cmpTmp, 32);
        this.chkCodeDifference.setText("Warn if there is a code difference between source and target segments");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkCodeDifference.setLayoutData((Object)gdTmp);
        this.chkGuessOpenClose = new Button(cmpTmp, 32);
        this.chkGuessOpenClose.setText("Try to guess opening/closing types for placeholder codes");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkGuessOpenClose.setLayoutData((Object)gdTmp);
        this.chkStrictCodeOrder = new Button(cmpTmp, 32);
        this.chkStrictCodeOrder.setText("Enforce strict order of the codes");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkStrictCodeOrder.setLayoutData((Object)gdTmp);
        Label label = new Label(cmpTmp, 0);
        label.setText("List of the inline code types to ignore:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        label.setLayoutData((Object)gdTmp);
        this.edTypesToIgnore = new Text(cmpTmp, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.edTypesToIgnore.setLayoutData((Object)gdTmp);
        this.pnlMissingCodesAllowed = new StringListPanel(cmpTmp, 0, "Codes allowed to be missing from the target:");
        this.pnlMissingCodesAllowed.setLayoutData(new GridData(1808));
        this.pnlExtraCodesAllowed = new StringListPanel(cmpTmp, 0, "Codes allowed to be extra in the target:");
        this.pnlExtraCodesAllowed.setLayoutData(new GridData(1808));
        tiTmp = new TabItem(this.tabs, 0);
        tiTmp.setText("Inline Codes");
        tiTmp.setControl((Control)cmpTmp);
        cmpTmp = new Composite((Composite)this.tabs, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        cmpTmp.setLayoutData((Object)new GridData(1808));
        this.chkPatterns = new Button(cmpTmp, 32);
        this.chkPatterns.setText("Verify that the following source patterns are translated as expected:");
        this.chkPatterns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updatePatterns();
            }
        });
        this.table = new Table(cmpTmp, 68384);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        gdTmp = new GridData(1808);
        this.table.setLayoutData((Object)gdTmp);
        this.table.addListener(13, event -> {
            if (event.detail != 32) {
                this.updateMoveButtons();
            }
        });
        this.table.addListener(8, event -> {
            if (this.table.getSelectionIndex() != -1) {
                this.editPattern(false);
            }
        });
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int tableWidth = ParametersEditor.this.table.getClientArea().width;
                ParametersEditor.this.table.getColumn(0).setWidth(120);
                int remaining = tableWidth - 120;
                ParametersEditor.this.table.getColumn(1).setWidth(remaining / 3);
                ParametersEditor.this.table.getColumn(2).setWidth(remaining / 3);
                ParametersEditor.this.table.getColumn(3).setWidth(remaining / 3);
            }
        });
        String[] titles = new String[]{"Options", "Source Pattern", "Target Pattern", "Description"};
        for (int i = 0; i < titles.length; ++i) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setText(titles[i]);
            column.pack();
        }
        Composite cmpTmp2 = new Composite(cmpTmp, 0);
        GridLayout layTmp = new GridLayout(7, true);
        layTmp.marginWidth = 0;
        layTmp.marginHeight = 0;
        cmpTmp2.setLayout((Layout)layTmp);
        this.btAdd = UIUtil.createGridButton(cmpTmp2, 8, "Add...", 80, 1);
        this.btAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.editPattern(true);
            }
        });
        this.btEdit = UIUtil.createGridButton(cmpTmp2, 8, "Edit...", 80, 1);
        this.btEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.editPattern(false);
            }
        });
        this.btRemove = UIUtil.createGridButton(cmpTmp2, 8, "Remove", 80, 1);
        this.btRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.removePattern();
            }
        });
        this.btMoveUp = UIUtil.createGridButton(cmpTmp2, 8, "Move Up", 80, 1);
        this.btMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.moveItem(-1);
            }
        });
        this.btMoveDown = UIUtil.createGridButton(cmpTmp2, 8, "Move Down", 80, 1);
        this.btMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.moveItem(1);
            }
        });
        this.btImport = UIUtil.createGridButton(cmpTmp2, 8, "Import...", 80, 1);
        this.btImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.importPatterns();
            }
        });
        this.btExport = UIUtil.createGridButton(cmpTmp2, 8, "Export...", 80, 1);
        this.btExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.exportPatterns();
            }
        });
        tiTmp = new TabItem(this.tabs, 0);
        tiTmp.setText("Patterns");
        tiTmp.setControl((Control)cmpTmp);
        cmpTmp = new Composite((Composite)this.tabs, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        cmpTmp.setLayoutData((Object)new GridData(1808));
        this.chkCheckAllowedCharacters = new Button(cmpTmp, 32);
        this.chkCheckAllowedCharacters.setText("Verify the ITS Allowed Characters property");
        this.chkCorruptedChars = new Button(cmpTmp, 32);
        this.chkCorruptedChars.setText("Warn if some possibly corrupted characters are found in the target entry");
        this.chkCheckCharacters = new Button(cmpTmp, 32);
        this.chkCheckCharacters.setText("Warn if a character is not included in the following character set encoding:");
        this.chkCheckCharacters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateCharacters();
            }
        });
        Composite cmpChars = new Composite(cmpTmp, 0);
        gdTmp = new GridData(768);
        gdTmp.horizontalIndent = 8;
        cmpChars.setLayoutData((Object)gdTmp);
        cmpChars.setLayout((Layout)new GridLayout());
        this.edCharset = new Text(cmpChars, 2048);
        this.edCharset.setLayoutData((Object)new GridData(768));
        this.stExtraCharsAllowed = new Label(cmpChars, 0);
        this.stExtraCharsAllowed.setText("Allow the characters matching the following regular expression pattern:");
        this.edExtraCharsAllowed = new Text(cmpChars, 2048);
        this.edExtraCharsAllowed.setLayoutData((Object)new GridData(768));
        tiTmp = new TabItem(this.tabs, 0);
        tiTmp.setText("Characters");
        tiTmp.setControl((Control)cmpTmp);
        cmpTmp = new Composite((Composite)this.tabs, 0);
        cmpTmp.setLayoutData((Object)new GridData(768));
        cmpTmp.setLayout((Layout)new GridLayout());
        this.chkCheckWithLT = new Button(cmpTmp, 32);
        this.chkCheckWithLT.setText("Perform the verifications provided by the LanguageTool server");
        this.chkCheckWithLT.setLayoutData((Object)new GridData());
        this.chkCheckWithLT.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateLTOptions();
            }
        });
        label = new Label(cmpTmp, 0);
        label.setText("Server URL (e.g. http://localhost:8081/):");
        this.edServerURL = new Text(cmpTmp, 2048);
        gdTmp = new GridData(768);
        this.edServerURL.setLayoutData((Object)gdTmp);
        this.chkLTBilingualMode = new Button(cmpTmp, 32);
        this.chkLTBilingualMode.setText("Use bilingual mode");
        gdTmp = new GridData();
        gdTmp.verticalIndent = 16;
        this.chkLTBilingualMode.setLayoutData((Object)gdTmp);
        Composite cmpLTTrans = new Composite(cmpTmp, 0);
        cmpLTTrans.setLayout((Layout)new GridLayout(2, false));
        cmpLTTrans.setLayoutData((Object)new GridData(768));
        this.btStartLT = new Button(cmpTmp, 8);
        gdTmp = new GridData();
        gdTmp.verticalIndent = 16;
        this.btStartLT.setLayoutData((Object)gdTmp);
        this.btStartLT.setText("Start LanguageTool from the Web");
        this.btStartLT.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.startLT();
            }
        });
        tiTmp = new TabItem(this.tabs, 0);
        tiTmp.setText("LanguageTool");
        tiTmp.setControl((Control)cmpTmp);
        cmpTmp = new Composite((Composite)this.tabs, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout((Layout)layTmp);
        Group grpTerms = new Group(cmpTmp, 0);
        grpTerms.setText("Terminology");
        grpTerms.setLayoutData((Object)new GridData(768));
        grpTerms.setLayout((Layout)new GridLayout());
        label = new Label((Composite)grpTerms, 0);
        label.setText("*** THIS FEATURE IS EXPERIMENTAL AND UNDER CONSTRUCTION ***");
        this.chkCheckTerms = new Button((Composite)grpTerms, 32);
        this.chkCheckTerms.setText("Verify terminology");
        this.chkCheckTerms.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateCheckTerms();
            }
        });
        this.stTermPath = new Label((Composite)grpTerms, 0);
        this.stTermPath.setText("Full path of the glossary file to use:");
        this.pnlTermsPath = new TextAndBrowsePanel((Composite)grpTerms, 0, false);
        this.pnlTermsPath.setBrowseFilters("TBX Documents (*.tbx)\tCSV Files (*.csv)\tTab-Delimited Files (*.txt)\tAll Files (*.*)", "*.tbx\t*.csv\t*.txt\t*.*");
        gdTmp = new GridData(768);
        this.pnlTermsPath.setLayoutData(gdTmp);
        this.chkStringMode = new Button((Composite)grpTerms, 32);
        this.chkStringMode.setText("Verify using strings matching");
        this.chkStringMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateStringMode();
            }
        });
        this.chkBetweenCodes = new Button((Composite)grpTerms, 32);
        this.chkBetweenCodes.setText("Strings must be between inline codes to match");
        Group grpBlacklist = new Group(cmpTmp, 0);
        grpBlacklist.setText("Blacklist");
        grpBlacklist.setLayoutData((Object)new GridData(768));
        grpBlacklist.setLayout((Layout)new GridLayout());
        this.chkCheckBlacklist = new Button((Composite)grpBlacklist, 32);
        this.chkCheckBlacklist.setText("Check for blacklisted terms");
        this.chkCheckBlacklist.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateBlacklistTerms();
            }
        });
        this.chkAllowBlacklistSub = new Button((Composite)grpBlacklist, 32);
        this.chkAllowBlacklistSub.setText("Detect substrings");
        this.chkBlacklistSrc = new Button((Composite)grpBlacklist, 32);
        this.chkBlacklistSrc.setText("Check source");
        this.stBlacklistPath = new Label((Composite)grpBlacklist, 0);
        this.stBlacklistPath.setText("Full path of the blacklist file to use:");
        this.pnlBlacklistPath = new TextAndBrowsePanel((Composite)grpBlacklist, 0, false);
        this.pnlBlacklistPath.setBrowseFilters("Tab-Delimited Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        this.pnlBlacklistPath.setLayoutData(gdTmp);
        tiTmp = new TabItem(this.tabs, 0);
        tiTmp.setText("Terms");
        tiTmp.setControl((Control)cmpTmp);
        cmpTmp = new Composite((Composite)this.tabs, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout((Layout)layTmp);
        Group grpScope = new Group(cmpTmp, 0);
        grpScope.setText("Scope");
        grpScope.setLayoutData((Object)new GridData(768));
        grpScope.setLayout((Layout)new GridLayout());
        this.rdScopeAllEntries = new Button((Composite)grpScope, 16);
        this.rdScopeAllEntries.setText("Process all entries");
        this.rdScopeApprovedOnly = new Button((Composite)grpScope, 16);
        this.rdScopeApprovedOnly.setText("Process only approved entries (e.g. \"approved\" entries in TS files)");
        this.rdScopeNotApprovedOnly = new Button((Composite)grpScope, 16);
        this.rdScopeNotApprovedOnly.setText("Process only entries not approved (e.g. \"fuzzy\" entries in PO files)");
        Group grpTmp = new Group(cmpTmp, 0);
        grpTmp.setText("Report output");
        grpTmp.setLayoutData((Object)new GridData(768));
        grpTmp.setLayout((Layout)new GridLayout(2, false));
        label = new Label((Composite)grpTmp, 0);
        label.setText("Path of the report file:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        label.setLayoutData((Object)gdTmp);
        this.pnlOutputPath = new TextAndBrowsePanel((Composite)grpTmp, 0, false);
        this.pnlOutputPath.setSaveAs(true);
        this.pnlOutputPath.setTitle("Quality Check Report");
        this.pnlOutputPath.setBrowseFilters("HTML Files (*.html;*.htm)\tAll Files (*.*)", "*.html;*.htm\t*.*");
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.pnlOutputPath.setLayoutData(gdTmp);
        label = new Label((Composite)grpTmp, 0);
        label.setText("Format of the report:");
        this.cbOutputType = new Combo((Composite)grpTmp, 12);
        this.cbOutputType.add("HTML file");
        this.cbOutputType.add("Tab-delimited file");
        this.cbOutputType.add("XML file");
        this.cbOutputType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateOutputPathExtension();
            }
        });
        this.chkAutoOpen = new Button((Composite)grpTmp, 32);
        this.chkAutoOpen.setText("Open the report after completion");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkAutoOpen.setLayoutData((Object)gdTmp);
        this.chkShowFullPath = new Button((Composite)grpTmp, 32);
        this.chkShowFullPath.setText("Show full paths on the report (otherwise the report shows relative paths)");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkShowFullPath.setLayoutData((Object)gdTmp);
        grpTmp = new Group(cmpTmp, 0);
        grpTmp.setText("Overall Configuration");
        grpTmp.setLayoutData((Object)new GridData(768));
        grpTmp.setLayout((Layout)new GridLayout(3, false));
        Button btTmp = UIUtil.createGridButton((Composite)grpTmp, 8, "Import...", 80, 1);
        btTmp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.importConfiguration();
            }
        });
        btTmp = UIUtil.createGridButton((Composite)grpTmp, 8, "Export...", 80, 1);
        btTmp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.exportConfiguration();
            }
        });
        btTmp = UIUtil.createGridButton((Composite)grpTmp, 8, "Reset to Defaults...", 160, 1);
        btTmp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.resetToDefaults();
            }
        });
        this.chkUseGenericCodes = new Button(cmpTmp, 32);
        this.chkUseGenericCodes.setText("Use generic codes in display (instead of original codes data");
        if (this.stepMode) {
            this.chkSaveSession = new Button(cmpTmp, 32);
            this.chkSaveSession.setText("Save the session using the following path:");
            this.chkSaveSession.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ParametersEditor.this.pnlSessionPath.setEnabled(ParametersEditor.this.chkSaveSession.getSelection());
                }
            });
            this.pnlSessionPath = new TextAndBrowsePanel(cmpTmp, 0, false);
            this.pnlSessionPath.setSaveAs(true);
            this.pnlSessionPath.setTitle("Quality Check Session");
            this.pnlSessionPath.setBrowseFilters(String.format("Quality Check Sessions (*%s)\tAll Files (*.*)", ".qcs"), String.format("*%s\t*.*", ".qcs"));
            gdTmp = new GridData();
            gdTmp = new GridData(768);
            this.pnlSessionPath.setLayoutData(gdTmp);
        }
        tiTmp = new TabItem(this.tabs, 0);
        tiTmp.setText("Other Settings");
        tiTmp.setControl((Control)cmpTmp);
        this.mainComposite.pack();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void updateOutputPathExtension() {
        Object tmp = this.pnlOutputPath.getText();
        String ext = ".html";
        if (this.cbOutputType.getSelectionIndex() == 1) {
            ext = ".txt";
        }
        if (this.cbOutputType.getSelectionIndex() == 2) {
            ext = ".xml";
        }
        if (((String)tmp).endsWith(ext)) {
            return;
        }
        int n = ((String)tmp).lastIndexOf(46);
        if (n > -1) {
            tmp = ((String)tmp).substring(0, n);
        }
        tmp = (String)tmp + ext;
        this.pnlOutputPath.setText((String)tmp);
    }

    private void exportConfiguration() {
        try {
            if (!this.saveData()) {
                return;
            }
            String path = Dialogs.browseFilenamesForSave(this.shell, "Export Configuration", null, null, String.format("Quality Check Configurations (*%s)\tAll Files (*.*)", ".qccfg"), String.format("*%s\t*.*", ".qccfg"));
            if (path == null) {
                return;
            }
            this.params.save(path);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error while saving configuration.\n" + e.getMessage(), null);
        }
    }

    private void importConfiguration() {
        try {
            String[] paths = Dialogs.browseFilenames(this.shell, "Import Configuration", false, null, String.format("Quality Check Configurations (*%s)\tAll Files (*.*)", ".qccfg"), String.format("*%s\t*.*", ".qccfg"));
            if (paths == null) {
                return;
            }
            this.params.load(Util.toURL((String)paths[0]), false);
            this.setData();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error while saving configuration.\n" + e.getMessage(), null);
        }
    }

    private void resetToDefaults() {
        try {
            MessageBox msgDlg = new MessageBox(this.shell, 452);
            msgDlg.setMessage("This command will reset all the configuration settings to their defaults.\nDo you want to proceed?");
            msgDlg.setText("Reset to Defaults");
            switch (msgDlg.open()) {
                case 128: 
                case 256: {
                    return;
                }
            }
            this.params.fromString("");
            this.setData();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error while resetting configuration.\n" + e.getMessage(), null);
        }
    }

    private void startLT() {
        try {
            UIUtil.start("http://www.languagetool.org/webstart/web/LanguageTool.jnlp");
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error starting languageTool from the Web.\n" + e.getMessage(), null);
        }
    }

    private void updateCharacters() {
        this.edCharset.setEnabled(this.chkCheckCharacters.getSelection());
        this.stExtraCharsAllowed.setEnabled(this.chkCheckCharacters.getSelection());
        this.edExtraCharsAllowed.setEnabled(this.chkCheckCharacters.getSelection());
    }

    private void updateCheckTerms() {
        this.stTermPath.setEnabled(this.chkCheckTerms.getSelection());
        this.pnlTermsPath.setEnabled(this.chkCheckTerms.getSelection());
        this.chkStringMode.setEnabled(this.chkCheckTerms.getSelection());
        this.updateStringMode();
    }

    private void updateStringMode() {
        this.chkBetweenCodes.setEnabled(this.chkStringMode.isEnabled() ? this.chkStringMode.getSelection() : false);
    }

    private void updateBlacklistTerms() {
        this.chkAllowBlacklistSub.setEnabled(this.chkCheckBlacklist.getSelection());
        this.chkBlacklistSrc.setEnabled(this.chkCheckBlacklist.getSelection());
        this.stBlacklistPath.setEnabled(this.chkCheckBlacklist.getSelection());
        this.pnlBlacklistPath.setEnabled(this.chkCheckBlacklist.getSelection());
    }

    private void editPattern(boolean add) {
        this.addMode = add;
        this.dialog = new Shell(this.shell, 65648);
        this.dialog.setText(add ? "Add Pattern Entry" : "Edit Pattern Entry");
        this.dialog.setMinimumSize(600, 200);
        this.dialog.setSize(this.dialog.getMinimumSize());
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setLayoutData((Object)new GridData(1808));
        Label label = new Label((Composite)this.dialog, 64);
        label.setText(String.format("Pattern for the source (use '%s' if expecting the same as the target):", "<same>"));
        this.edSource = new Text((Composite)this.dialog, 2048);
        GridData gdTmp = new GridData(1808);
        this.edSource.setLayoutData((Object)gdTmp);
        label = new Label((Composite)this.dialog, 0);
        label.setText(String.format("Pattern for the target (use '%s' if expecting the same as the source):", "<same>"));
        this.edTarget = new Text((Composite)this.dialog, 2048);
        gdTmp = new GridData(1808);
        this.edTarget.setLayoutData((Object)gdTmp);
        label = new Label((Composite)this.dialog, 0);
        label.setText("Description:");
        this.edDescription = new Text((Composite)this.dialog, 2048);
        gdTmp = new GridData(1808);
        this.edDescription.setLayoutData((Object)gdTmp);
        label = new Label((Composite)this.dialog, 0);
        label.setText("Severity:");
        this.cbSeverity = new Combo((Composite)this.dialog, 12);
        for (String string : severityNames) {
            this.cbSeverity.add(string);
        }
        this.chkFromSource = new Button((Composite)this.dialog, 32);
        this.chkFromSource.setText("Search in the source then compare with the target (if single-pattern is not set)");
        this.chkSinglePattern = new Button((Composite)this.dialog, 32);
        this.chkSinglePattern.setText("Search only in the selected text (source or target)");
        if (add) {
            this.edTarget.setText("<same>");
            this.cbSeverity.select(1);
            this.chkFromSource.setSelection(true);
            this.chkSinglePattern.setSelection(false);
        } else {
            int index = this.table.getSelectionIndex();
            if (index < 0) {
                return;
            }
            this.editItem = this.table.getItem(index);
            this.edSource.setText(this.editItem.getText(1));
            this.edTarget.setText(this.editItem.getText(2));
            this.edDescription.setText(this.editItem.getText(3));
            this.cbSeverity.select(this.getSeverityFromString(this.editItem.getText(0)));
            this.chkFromSource.setSelection(this.isFromSource(this.editItem.getText(0)));
            this.chkSinglePattern.setSelection(this.isSinglePattern(this.editItem.getText(0)));
        }
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.widget.getData().equals("o")) {
                    if (ParametersEditor.this.edSource.getText().trim().length() < 1 && (!ParametersEditor.this.chkSinglePattern.getSelection() || ParametersEditor.this.chkFromSource.getSelection())) {
                        Dialogs.showError(ParametersEditor.this.shell, "You must enter a pattern for the source.", null);
                        ParametersEditor.this.edSource.selectAll();
                        ParametersEditor.this.edSource.setFocus();
                        return;
                    }
                    if (!(ParametersEditor.this.edTarget.getText().trim().length() >= 1 || ParametersEditor.this.chkSinglePattern.getSelection() && ParametersEditor.this.chkFromSource.getSelection())) {
                        Dialogs.showError(ParametersEditor.this.shell, "You must enter a pattern for the target.", null);
                        ParametersEditor.this.edTarget.selectAll();
                        ParametersEditor.this.edTarget.setFocus();
                        return;
                    }
                    if (ParametersEditor.this.edDescription.getText().trim().length() < 1) {
                        Dialogs.showError(ParametersEditor.this.shell, "You must enter a description for the pattern.", null);
                        ParametersEditor.this.edDescription.selectAll();
                        ParametersEditor.this.edDescription.setFocus();
                        return;
                    }
                    try {
                        if (!ParametersEditor.this.edSource.getText().equals("<same>")) {
                            Pattern.compile(ParametersEditor.this.edSource.getText());
                        }
                    }
                    catch (Exception e) {
                        Dialogs.showError(ParametersEditor.this.shell, "Pattern error:\n" + e.getLocalizedMessage(), null);
                        ParametersEditor.this.edSource.selectAll();
                        ParametersEditor.this.edSource.setFocus();
                        return;
                    }
                    try {
                        if (!ParametersEditor.this.edTarget.getText().equals("<same>")) {
                            Pattern.compile(ParametersEditor.this.edTarget.getText());
                        }
                    }
                    catch (Exception e) {
                        Dialogs.showError(ParametersEditor.this.shell, "Pattern error:\n" + e.getLocalizedMessage(), null);
                        ParametersEditor.this.edTarget.selectAll();
                        ParametersEditor.this.edTarget.setFocus();
                        return;
                    }
                    if (ParametersEditor.this.addMode) {
                        ParametersEditor.this.editItem = new TableItem(ParametersEditor.this.table, 0);
                        ParametersEditor.this.editItem.setChecked(true);
                        ParametersEditor.this.table.setSelection(ParametersEditor.this.table.getItemCount() - 1);
                    }
                    ParametersEditor.this.editItem.setText(0, (ParametersEditor.this.chkFromSource.getSelection() ? ParametersEditor.FROMSOURCE : ParametersEditor.FROMTARGET) + "/" + (ParametersEditor.this.chkSinglePattern.getSelection() ? ParametersEditor.SINGLEPATTERN_TRUE : ParametersEditor.SINGLEPATTERN_FALSE) + "/" + ParametersEditor.this.cbSeverity.getText());
                    ParametersEditor.this.editItem.setText(1, ParametersEditor.this.edSource.getText());
                    ParametersEditor.this.editItem.setText(2, ParametersEditor.this.edTarget.getText());
                    ParametersEditor.this.editItem.setText(3, ParametersEditor.this.edDescription.getText());
                    ParametersEditor.this.updatePatternsButtons();
                }
                ParametersEditor.this.dialog.close();
            }
        };
        OKCancelPanel pnlActionsDialog = new OKCancelPanel((Composite)this.dialog, 0, OKCancelActions, false);
        pnlActionsDialog.setLayoutData(new GridData(768));
        this.dialog.setDefaultButton(pnlActionsDialog.btOK);
        this.dialog.pack();
        Dialogs.centerWindow(this.dialog, this.shell);
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
    }

    private void removePattern() {
        int index = this.table.getSelectionIndex();
        if (index < 0) {
            return;
        }
        this.table.remove(index);
        int count = this.table.getItemCount();
        if (index > count - 1) {
            this.table.setSelection(this.table.getItemCount() - 1);
        } else {
            this.table.setSelection(index);
        }
        this.updatePatternsButtons();
    }

    private void moveItem(int offset) {
        int index = this.table.getSelectionIndex();
        int count = this.table.getItemCount();
        if (offset < 0 ? index < 1 : index >= count - 1) {
            return;
        }
        TableItem ti = this.table.getItem(index);
        boolean isChecked = ti.getChecked();
        String[] data = new String[]{ti.getText(0), ti.getText(1), ti.getText(2), ti.getText(3) == null ? NODESC_LABEL : ti.getText(3)};
        ti.dispose();
        ti = new TableItem(this.table, 0, index + offset);
        ti.setChecked(isChecked);
        ti.setText(data);
        this.table.select(index + offset);
        this.updateMoveButtons();
    }

    private void importPatterns() {
        try {
            String[] paths = Dialogs.browseFilenames(this.shell, "Import Patterns", false, null, "Patterns Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
            if (paths == null) {
                return;
            }
            this.setPatternsData(PatternItem.loadFile((String)paths[0]));
            this.updatePatternsButtons();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void exportPatterns() {
        try {
            String path = Dialogs.browseFilenamesForSave(this.shell, "Export Patterns", null, null, "Patterns Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
            if (path == null) {
                return;
            }
            PatternItem.saveFile((String)path, this.savePatternsData());
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void updateLTOptions() {
        boolean enabled = this.chkCheckWithLT.getSelection();
        this.edServerURL.setEnabled(enabled);
        this.chkLTBilingualMode.setEnabled(enabled);
    }

    private void updateDoubledWord() {
        this.stDoubledWordExceptions.setEnabled(this.chkDoubledWord.getSelection());
        this.edDoubledWordExceptions.setEnabled(this.chkDoubledWord.getSelection());
    }

    private void updateTargetSameAsSourceForSameLanguage() {
        this.chkTargetSameAsSourceForSameLanguage.setEnabled(this.chkTargetSameAsSource.getSelection());
    }

    private void updateTargetSameAsSourceWithCodes() {
        this.chkTargetSameAsSourceWithCodes.setEnabled(this.chkTargetSameAsSource.getSelection());
    }

    private void updateTargetSameAsSourceWithNumbers() {
        this.chkTargetSameAsSourceWithNumbers.setEnabled(this.chkTargetSameAsSource.getSelection());
    }

    private void updateAbsoluteMaxCharLength() {
        boolean enabled = this.chkAbsoluteMaxCharLength.getSelection();
        this.spAbsoluteMaxCharLength.setEnabled(enabled);
    }

    private void updateMaxCharLength() {
        boolean enabled = this.chkMaxCharLength.getSelection();
        for (Control ctrl : this.cmpMaxCharLength.getChildren()) {
            ctrl.setEnabled(enabled);
        }
    }

    private void updateMinCharLength() {
        boolean enabled = this.chkMinCharLength.getSelection();
        for (Control ctrl : this.cmpMinCharLength.getChildren()) {
            ctrl.setEnabled(enabled);
        }
    }

    private void updatePatterns() {
        boolean enabled = this.chkPatterns.getSelection();
        this.table.setEnabled(enabled);
        this.btAdd.setEnabled(enabled);
        this.btImport.setEnabled(enabled);
        if (enabled) {
            this.updatePatternsButtons();
        } else {
            this.btEdit.setEnabled(false);
            this.btRemove.setEnabled(false);
            this.btMoveUp.setEnabled(false);
            this.btMoveDown.setEnabled(false);
            this.btExport.setEnabled(false);
        }
    }

    private void updatePatternsButtons() {
        int index = this.table.getSelectionIndex();
        int count = this.table.getItemCount();
        this.btEdit.setEnabled(index != -1);
        this.btRemove.setEnabled(index != -1);
        this.updateMoveButtons();
        this.btExport.setEnabled(count > 0);
    }

    private void updateMoveButtons() {
        int index = this.table.getSelectionIndex();
        int count = this.table.getItemCount();
        this.btMoveUp.setEnabled(index > 0);
        this.btMoveDown.setEnabled(index < count - 1);
    }

    private void setData() {
        this.pnlOutputPath.setText(this.params.getOutputPath());
        this.cbOutputType.select(this.params.getOutputType());
        this.chkAutoOpen.setSelection(this.params.getAutoOpen());
        this.chkShowFullPath.setSelection(this.params.getShowFullPath());
        this.chkUseGenericCodes.setSelection(this.params.getUseGenericCodes());
        this.chkCodeDifference.setSelection(this.params.getCodeDifference());
        this.chkGuessOpenClose.setSelection(this.params.getGuessOpenClose());
        this.chkStrictCodeOrder.setSelection(this.params.getStrictCodeOrder());
        this.chkLeadingWS.setSelection(this.params.getLeadingWS());
        this.chkTrailingWS.setSelection(this.params.getTrailingWS());
        this.chkEmptyTarget.setSelection(this.params.getEmptyTarget());
        this.chkEmptySource.setSelection(this.params.getEmptySource());
        this.chkTargetSameAsSource.setSelection(this.params.getTargetSameAsSource());
        this.chkTargetSameAsSourceForSameLanguage.setSelection(this.params.getTargetSameAsSourceForSameLanguage());
        this.chkTargetSameAsSourceWithCodes.setSelection(this.params.getTargetSameAsSourceWithCodes());
        this.chkTargetSameAsSourceWithNumbers.setSelection(this.params.getTargetSameAsSourceWithNumbers());
        this.chkCheckWithLT.setSelection(this.params.getCheckWithLT());
        this.edServerURL.setText(this.params.getServerURL());
        this.chkLTBilingualMode.setSelection(this.params.getLtBilingualMode());
        if (this.params.getCheckXliffSchema()) {
            switch (this.params.getXliffSchemaType()) {
                case "None": {
                    this.cbCheckXliffSchema.select(0);
                    break;
                }
                case "Strict": {
                    this.cbCheckXliffSchema.select(2);
                    break;
                }
                default: {
                    this.cbCheckXliffSchema.select(1);
                    break;
                }
            }
        } else {
            this.cbCheckXliffSchema.select(0);
        }
        this.chkPatterns.setSelection(this.params.getCheckPatterns());
        this.chkDoubledWord.setSelection(this.params.getDoubledWord());
        this.edDoubledWordExceptions.setText(this.params.getDoubledWordExceptions());
        this.chkCorruptedChars.setSelection(this.params.getCorruptedCharacters());
        this.chkStorageSize.setSelection(this.params.getCheckStorageSize());
        this.chkAbsoluteMaxCharLength.setSelection(this.params.getCheckAbsoluteMaxCharLength());
        this.spAbsoluteMaxCharLength.setSelection(this.params.getAbsoluteMaxCharLength());
        this.chkMaxCharLength.setSelection(this.params.getCheckMaxCharLength());
        this.spMaxCharLengthBreak.setSelection(this.params.getMaxCharLengthBreak());
        this.spMaxCharLengthAbove.setSelection(this.params.getMaxCharLengthAbove());
        this.spMaxCharLengthBelow.setSelection(this.params.getMaxCharLengthBelow());
        this.chkMinCharLength.setSelection(this.params.getCheckMinCharLength());
        this.spMinCharLengthBreak.setSelection(this.params.getMinCharLengthBreak());
        this.spMinCharLengthAbove.setSelection(this.params.getMinCharLengthAbove());
        this.spMinCharLengthBelow.setSelection(this.params.getMinCharLengthBelow());
        this.rdScopeAllEntries.setSelection(this.params.getScope() == 0);
        this.rdScopeApprovedOnly.setSelection(this.params.getScope() == 1);
        this.rdScopeNotApprovedOnly.setSelection(this.params.getScope() == 2);
        this.chkCheckAllowedCharacters.setSelection(this.params.getCheckAllowedCharacters());
        this.chkCheckCharacters.setSelection(this.params.getCheckCharacters());
        this.edCharset.setText(this.params.getCharset());
        this.edExtraCharsAllowed.setText(this.params.getExtraCharsAllowed());
        this.pnlMissingCodesAllowed.fillList(this.params.getMissingCodesAllowed());
        this.pnlExtraCodesAllowed.fillList(this.params.getExtraCodesAllowed());
        this.edTypesToIgnore.setText(this.params.getTypesToIgnore());
        this.chkCheckTerms.setSelection(this.params.getCheckTerms());
        this.pnlTermsPath.setText(this.params.getTermsPath());
        this.chkStringMode.setSelection(this.params.getStringMode());
        this.chkBetweenCodes.setSelection(this.params.getBetweenCodes());
        this.chkCheckBlacklist.setSelection(this.params.getCheckBlacklist());
        this.chkAllowBlacklistSub.setSelection(this.params.getAllowBlacklistSub());
        this.chkBlacklistSrc.setSelection(this.params.getBlacklistSrc());
        this.pnlBlacklistPath.setText(this.params.getBlacklistPath());
        this.setPatternsData(this.params.getPatterns());
        this.updateTargetSameAsSourceForSameLanguage();
        this.updateTargetSameAsSourceWithCodes();
        this.updateTargetSameAsSourceWithNumbers();
        this.updatePatterns();
        this.updateDoubledWord();
        this.updateLTOptions();
        this.updateAbsoluteMaxCharLength();
        this.updateMaxCharLength();
        this.updateMinCharLength();
        this.updateCharacters();
        this.updateCheckTerms();
        this.updateBlacklistTerms();
        if (this.stepMode) {
            this.chkSaveSession.setSelection(this.params.getSaveSession());
            this.pnlSessionPath.setText(this.params.getSessionPath());
            this.pnlSessionPath.setEnabled(this.chkSaveSession.getSelection());
        }
    }

    private void setPatternsData(List<PatternItem> list) {
        this.table.removeAll();
        for (PatternItem item : list) {
            TableItem row = new TableItem(this.table, 0);
            row.setChecked(item.enabled);
            row.setText(0, (item.fromSource ? FROMSOURCE : FROMTARGET) + "/" + (item.singlePattern ? SINGLEPATTERN_TRUE : SINGLEPATTERN_FALSE) + "/" + severityNames[item.severity]);
            row.setText(1, item.source);
            row.setText(2, item.target);
            row.setText(3, item.description == null ? NODESC_LABEL : item.description);
        }
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(0);
        }
    }

    private boolean saveData() {
        String tmp;
        if (this.pnlOutputPath.getText().trim().length() == 0) {
            Dialogs.showError(this.shell, "Please, enter a path for the report.", null);
            this.tabs.setSelection(7);
            this.pnlOutputPath.setFocus();
            return false;
        }
        if (this.chkCheckWithLT.getSelection() && this.edServerURL.getText().trim().length() == 0) {
            Dialogs.showError(this.shell, "Please, enter a server URL.", null);
            this.tabs.setSelection(5);
            this.edServerURL.setFocus();
            return false;
        }
        if (this.chkCheckCharacters.getSelection()) {
            tmp = this.edExtraCharsAllowed.getText();
            if (tmp.isEmpty() && this.edCharset.getText().trim().isEmpty()) {
                Dialogs.showError(this.shell, "You must defined a character set encoding, or a list of allowed characters, or both.", null);
                this.tabs.setSelection(4);
                this.edCharset.setFocus();
                return false;
            }
            if (!tmp.isEmpty()) {
                try {
                    Pattern.compile(tmp);
                }
                catch (Throwable e) {
                    Dialogs.showError(this.shell, "Regular expression error:\n" + e.getMessage(), null);
                    this.tabs.setSelection(4);
                    this.edExtraCharsAllowed.setFocus();
                    return false;
                }
            }
        }
        if (this.chkCheckTerms.getSelection() && (tmp = this.pnlTermsPath.getText().trim()).isEmpty()) {
            Dialogs.showError(this.shell, "You must specify a glossary file.", null);
            this.tabs.setSelection(6);
            this.pnlTermsPath.setFocus();
            return false;
        }
        if (this.chkCheckBlacklist.getSelection() && (tmp = this.pnlBlacklistPath.getText().trim()).isEmpty()) {
            Dialogs.showError(this.shell, "You must specify a blacklist file.", null);
            this.tabs.setSelection(6);
            this.pnlBlacklistPath.setFocus();
            return false;
        }
        if (this.stepMode && this.chkSaveSession.getSelection() && this.pnlSessionPath.getText().trim().length() == 0) {
            Dialogs.showError(this.shell, "Please, enter a path for the session.", null);
            this.pnlSessionPath.setFocus();
            return false;
        }
        this.params.setCheckStorageSize(this.chkStorageSize.getSelection());
        this.params.setCheckAbsoluteMaxCharLength(this.chkAbsoluteMaxCharLength.getSelection());
        if (this.chkAbsoluteMaxCharLength.getSelection()) {
            this.params.setAbsoluteMaxCharLength(this.spAbsoluteMaxCharLength.getSelection());
        }
        this.params.setCheckMaxCharLength(this.chkMaxCharLength.getSelection());
        if (this.chkMaxCharLength.getSelection()) {
            this.params.setMaxCharLengthBreak(this.spMaxCharLengthBreak.getSelection());
            this.params.setMaxCharLengthAbove(this.spMaxCharLengthAbove.getSelection());
            this.params.setMaxCharLengthBelow(this.spMaxCharLengthBelow.getSelection());
        }
        this.params.setCheckMinCharLength(this.chkMinCharLength.getSelection());
        if (this.chkMinCharLength.getSelection()) {
            this.params.setMinCharLengthBreak(this.spMinCharLengthBreak.getSelection());
            this.params.setMinCharLengthAbove(this.spMinCharLengthAbove.getSelection());
            this.params.setMinCharLengthBelow(this.spMinCharLengthBelow.getSelection());
        }
        List list = this.params.getMissingCodesAllowed();
        list.clear();
        list.addAll(this.pnlMissingCodesAllowed.getList());
        list = this.params.getExtraCodesAllowed();
        list.clear();
        list.addAll(this.pnlExtraCodesAllowed.getList());
        Object tmp2 = this.edTypesToIgnore.getText().trim();
        if (!((String)tmp2).isEmpty() && Util.getLastChar((String)tmp2) != ';') {
            tmp2 = ((String)tmp2).replace(" ", "");
            tmp2 = (String)tmp2 + ";";
        }
        this.params.setTypesToIgnore((String)tmp2);
        if (this.rdScopeApprovedOnly.getSelection()) {
            this.params.setScope(1);
        } else if (this.rdScopeNotApprovedOnly.getSelection()) {
            this.params.setScope(2);
        } else {
            this.params.setScope(0);
        }
        this.params.setOutputPath(this.pnlOutputPath.getText());
        this.params.setOutputType(this.cbOutputType.getSelectionIndex());
        this.params.setCodeDifference(this.chkCodeDifference.getSelection());
        this.params.setGuessOpenClose(this.chkGuessOpenClose.getSelection());
        this.params.setStrictCodeOrder(this.chkStrictCodeOrder.getSelection());
        this.params.setAutoOpen(this.chkAutoOpen.getSelection());
        this.params.setShowFullPath(this.chkShowFullPath.getSelection());
        this.params.setUseGenericCodes(this.chkUseGenericCodes.getSelection());
        this.params.setLeadingWS(this.chkLeadingWS.getSelection());
        this.params.setTrailingWS(this.chkTrailingWS.getSelection());
        this.params.setEmptyTarget(this.chkEmptyTarget.getSelection());
        this.params.setEmptySource(this.chkEmptySource.getSelection());
        this.params.setTargetSameAsSource(this.chkTargetSameAsSource.getSelection());
        this.params.setDoubledWord(this.chkDoubledWord.getSelection());
        this.params.setDoubledWordExceptions(this.edDoubledWordExceptions.getText());
        this.params.setCorruptedCharacters(this.chkCorruptedChars.getSelection());
        if (this.chkTargetSameAsSourceForSameLanguage.isEnabled()) {
            this.params.setTargetSameAsSourceForSameLanguage(this.chkTargetSameAsSourceForSameLanguage.getSelection());
        }
        if (this.chkTargetSameAsSourceWithCodes.isEnabled()) {
            this.params.setTargetSameAsSourceWithCodes(this.chkTargetSameAsSourceWithCodes.getSelection());
        }
        if (this.chkTargetSameAsSourceWithNumbers.isEnabled()) {
            this.params.setTargetSameAsSourceWithNumbers(this.chkTargetSameAsSourceWithNumbers.getSelection());
        }
        this.params.setCheckWithLT(this.chkCheckWithLT.getSelection());
        if (this.chkCheckWithLT.getSelection()) {
            this.params.setServerURL(this.edServerURL.getText());
            this.params.setLtBilingualMode(this.chkLTBilingualMode.getSelection());
        }
        this.params.setCheckAllowedCharacters(this.chkCheckAllowedCharacters.getSelection());
        this.params.setCheckCharacters(this.chkCheckCharacters.getSelection());
        if (this.chkCheckCharacters.getSelection()) {
            this.params.setCharset(this.edCharset.getText().trim());
            this.params.setExtraCharsAllowed(this.edExtraCharsAllowed.getText());
        }
        this.params.setCheckTerms(this.chkCheckTerms.getSelection());
        this.params.setTermsPath(this.pnlTermsPath.getText());
        this.params.setStringMode(this.chkStringMode.getSelection());
        this.params.setBetweenCodes(this.chkBetweenCodes.getSelection());
        this.params.setCheckBlacklist(this.chkCheckBlacklist.getSelection());
        this.params.setAllowBlacklistSub(this.chkAllowBlacklistSub.getSelection());
        this.params.setBlacklistSrc(this.chkBlacklistSrc.getSelection());
        this.params.setblacklistPath(this.pnlBlacklistPath.getText());
        if (this.stepMode) {
            this.params.setSaveSession(this.chkSaveSession.getSelection());
            if (this.chkSaveSession.getSelection()) {
                this.params.setSessionPath(this.pnlSessionPath.getText());
            }
        }
        switch (this.cbCheckXliffSchema.getSelectionIndex()) {
            case 0: {
                this.params.setCheckXliffSchema(false);
                this.params.setXliffSchemaType("None");
                break;
            }
            case 2: {
                this.params.setCheckXliffSchema(true);
                this.params.setXliffSchemaType("Strict");
                break;
            }
            default: {
                this.params.setCheckXliffSchema(true);
                this.params.setXliffSchemaType("Transitional");
            }
        }
        this.params.setCheckPatterns(this.chkPatterns.getSelection());
        this.params.setPatterns(this.savePatternsData());
        this.result = true;
        return this.result;
    }

    private List<PatternItem> savePatternsData() {
        ArrayList<PatternItem> list = new ArrayList<PatternItem>();
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            int severity = this.getSeverityFromString(this.table.getItem(i).getText(0));
            PatternItem pattern = new PatternItem(this.table.getItem(i).getText(1), this.table.getItem(i).getText(2), this.table.getItem(i).getChecked(), severity, this.table.getItem(i).getText(3));
            pattern.fromSource = this.isFromSource(this.table.getItem(i).getText(0));
            pattern.singlePattern = this.isSinglePattern(this.table.getItem(i).getText(0));
            list.add(pattern);
        }
        return list;
    }

    private boolean isFromSource(String value) {
        return value.subSequence(0, 3).equals(FROMSOURCE);
    }

    private boolean isSinglePattern(String value) {
        String tmp = value.substring(4);
        return tmp.startsWith(SINGLEPATTERN_TRUE);
    }

    private int getSeverityFromString(String value) {
        String tmp = value.substring(9);
        if (tmp.equals(severityNames[0])) {
            return 0;
        }
        if (tmp.equals(severityNames[1])) {
            return 1;
        }
        return 2;
    }
}

