/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.searchandreplace.ui;

import java.util.regex.Pattern;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.TextAndBrowsePanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.steps.searchandreplace.Parameters;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class ParametersEditor
implements IParametersEditor,
ISWTEmbeddableParametersEditor {
    public static final int ADD_ITEM = 1;
    public static final int EDIT_ITEM = 2;
    private Shell dialog;
    private OKCancelPanel pnlActionsDialog;
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Table table;
    private Text searchText;
    private Text replacementText;
    private Button btnImport;
    private Button btnExport;
    private Button btMoveUp;
    private Button btMoveDown;
    private Button chkSource;
    private Button chkTarget;
    private Button chkRegEx;
    private Button chkDotAll;
    private Button chkIgnoreCase;
    private Button chkReplaceAll;
    private Button chkMultiLine;
    private int updateType;
    private IHelp help;
    private Composite mainComposite;
    TextAndBrowsePanel pnlReplPath;
    private Button chkSaveLog;
    TextAndBrowsePanel pnlLogPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.shell = null;
            this.help = (IHelp)context.getObject("help");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    @Override
    public void initializeEmbeddableEditor(Composite parent, IParameters paramsObject, IContext context) {
        this.params = (Parameters)paramsObject;
        this.shell = (Shell)context.getObject("shell");
        this.createComposite(parent);
        this.setData(this.params);
    }

    public String validateAndSaveParameters() {
        if (!this.saveData(this.params)) {
            return null;
        }
        return this.params.toString();
    }

    private void updateUpDownBtnState() {
        int index = this.table.getSelectionIndex();
        int items = this.table.getItemCount();
        if (items > 1) {
            if (index == -1) {
                this.btMoveDown.setEnabled(false);
                this.btMoveUp.setEnabled(false);
            } else if (index == 0) {
                this.btMoveUp.setEnabled(false);
                this.btMoveDown.setEnabled(true);
            } else if (index + 1 == items) {
                this.btMoveDown.setEnabled(false);
                this.btMoveUp.setEnabled(true);
            } else {
                this.btMoveDown.setEnabled(true);
                this.btMoveUp.setEnabled(true);
            }
        } else {
            this.btMoveDown.setEnabled(false);
            this.btMoveUp.setEnabled(false);
        }
    }

    private void createComposite(Composite parent) {
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.table = new Table(this.mainComposite, 68384);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 2;
        gdTmp.heightHint = 150;
        this.table.setLayoutData((Object)gdTmp);
        this.table.addListener(13, event -> {
            if (event.detail != 32) {
                this.updateUpDownBtnState();
            }
        });
        this.table.addListener(8, event -> {
            if (this.table.getSelectionIndex() != -1) {
                this.updateType = 2;
                this.showAddItemsDialog();
                this.updateUpDownBtnState();
            }
        });
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int tableWidth = ParametersEditor.this.table.getBounds().width;
                int remaining = tableWidth - ParametersEditor.this.table.getColumn(0).getWidth();
                ParametersEditor.this.table.getColumn(1).setWidth(remaining / 2 - 2);
                ParametersEditor.this.table.getColumn(2).setWidth(remaining / 2 - 2);
            }
        });
        String[] titles = new String[]{"Use", "Search For", "Replace By"};
        for (int i = 0; i < titles.length; ++i) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setText(titles[i]);
            column.pack();
        }
        int standardWidth = 80;
        Composite cmpTmp = new Composite(this.mainComposite, 0);
        GridLayout layTmp = new GridLayout(5, true);
        layTmp.marginWidth = 0;
        layTmp.marginHeight = 0;
        cmpTmp.setLayout((Layout)layTmp);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        cmpTmp.setLayoutData((Object)gdTmp);
        Button btAdd = new Button(cmpTmp, 8);
        btAdd.setText("Add...");
        gdTmp = new GridData(768);
        btAdd.setLayoutData((Object)gdTmp);
        UIUtil.ensureWidth((Control)btAdd, standardWidth);
        btAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateType = 1;
                ParametersEditor.this.showAddItemsDialog();
            }
        });
        Button btEdit = new Button(cmpTmp, 8);
        btEdit.setText("Edit...");
        gdTmp = new GridData(768);
        btEdit.setLayoutData((Object)gdTmp);
        btEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParametersEditor.this.table.getSelectionIndex() != -1) {
                    ParametersEditor.this.updateType = 2;
                    ParametersEditor.this.showAddItemsDialog();
                }
            }
        });
        Button btRemove = new Button(cmpTmp, 8);
        btRemove.setText("Remove");
        gdTmp = new GridData(768);
        btRemove.setLayoutData((Object)gdTmp);
        btRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParametersEditor.this.table.getSelectionIndex() != -1) {
                    int index = ParametersEditor.this.table.getSelectionIndex();
                    ParametersEditor.this.table.remove(index);
                    if (index == ParametersEditor.this.table.getItemCount()) {
                        ParametersEditor.this.table.setSelection(index - 1);
                    } else {
                        ParametersEditor.this.table.setSelection(index);
                    }
                    ParametersEditor.this.updateUpDownBtnState();
                }
            }
        });
        this.btMoveUp = new Button(cmpTmp, 8);
        this.btMoveUp.setText("Move Up");
        this.btMoveUp.setEnabled(false);
        gdTmp = new GridData(768);
        this.btMoveUp.setLayoutData((Object)gdTmp);
        this.btMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParametersEditor.this.table.getSelectionIndex() != -1) {
                    int index = ParametersEditor.this.table.getSelectionIndex();
                    boolean isChecked = false;
                    TableItem ti = ParametersEditor.this.table.getItem(index);
                    isChecked = ti.getChecked();
                    String[] values = new String[]{ti.getText(0), ti.getText(1), ti.getText(2)};
                    ti.dispose();
                    ti = new TableItem(ParametersEditor.this.table, 0, index - 1);
                    ti.setChecked(isChecked);
                    String[] strs = values;
                    ti.setText(strs);
                    ParametersEditor.this.table.select(index - 1);
                    ParametersEditor.this.updateUpDownBtnState();
                }
            }
        });
        this.btMoveDown = new Button(cmpTmp, 8);
        this.btMoveDown.setText("Move Down");
        this.btMoveDown.setEnabled(false);
        gdTmp = new GridData(768);
        this.btMoveDown.setLayoutData((Object)gdTmp);
        this.btMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParametersEditor.this.table.getSelectionIndex() != -1) {
                    int index = ParametersEditor.this.table.getSelectionIndex();
                    boolean isChecked = false;
                    TableItem ti = ParametersEditor.this.table.getItem(index);
                    isChecked = ti.getChecked();
                    String[] values = new String[]{ti.getText(0), ti.getText(1), ti.getText(2)};
                    ti.dispose();
                    ti = new TableItem(ParametersEditor.this.table, 0, index + 1);
                    ti.setChecked(isChecked);
                    String[] strs = values;
                    ti.setText(strs);
                    ParametersEditor.this.table.select(index + 1);
                    ParametersEditor.this.updateUpDownBtnState();
                }
            }
        });
        this.btnImport = new Button(cmpTmp, 8);
        this.btnImport.setText("Import...");
        gdTmp = new GridData(768);
        this.btnImport.setLayoutData((Object)gdTmp);
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ParametersEditor.this.shell, 4096);
                fd.setText("Import Search and Replace Options");
                String selected = fd.open();
                if (selected != null) {
                    try {
                        Parameters tmpParams = new Parameters();
                        tmpParams.load(Util.toURL((String)selected), false);
                        ParametersEditor.this.setData(tmpParams);
                    }
                    catch (Throwable err) {
                        Dialogs.showError(ParametersEditor.this.shell, err.getMessage(), null);
                    }
                }
            }
        });
        this.btnExport = new Button(cmpTmp, 8);
        this.btnExport.setText("Export...");
        gdTmp = new GridData(768);
        this.btnExport.setLayoutData((Object)gdTmp);
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Parameters tmpParams;
                FileDialog fd = new FileDialog(ParametersEditor.this.shell, 8192);
                fd.setText("Export Search and Replace Options");
                fd.setOverwrite(true);
                String selected = fd.open();
                if (selected != null && ParametersEditor.this.saveData(tmpParams = new Parameters())) {
                    tmpParams.save(selected);
                }
            }
        });
        this.chkRegEx = new Button(this.mainComposite, 32);
        this.chkRegEx.setText("Use regular expressions");
        this.chkRegEx.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.chkDotAll.setEnabled(ParametersEditor.this.chkRegEx.getSelection());
                ParametersEditor.this.chkMultiLine.setEnabled(ParametersEditor.this.chkRegEx.getSelection());
                ParametersEditor.this.chkIgnoreCase.setEnabled(ParametersEditor.this.chkRegEx.getSelection());
                ParametersEditor.this.chkReplaceAll.setEnabled(ParametersEditor.this.chkRegEx.getSelection());
            }
        });
        new Label(this.mainComposite, 0);
        Group group = new Group(this.mainComposite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Regular expression options");
        this.chkDotAll = new Button((Composite)group, 32);
        this.chkDotAll.setText("Dot also matches line-feed");
        this.chkMultiLine = new Button((Composite)group, 32);
        this.chkMultiLine.setText("Multi-line");
        this.chkIgnoreCase = new Button((Composite)group, 32);
        this.chkIgnoreCase.setText("Ignore case differences");
        this.chkReplaceAll = new Button((Composite)group, 32);
        this.chkReplaceAll.setText("Replace all instances of the pattern");
        this.chkReplaceAll.setToolTipText("If true replace all instances, otherwise replace only the first");
        group = new Group(this.mainComposite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText("When processing text units (i.e. using a filter)");
        this.chkSource = new Button((Composite)group, 32);
        this.chkSource.setText("Search and replace the source content");
        this.chkTarget = new Button((Composite)group, 32);
        this.chkTarget.setText("Search and replace the target content");
        Label label = new Label(this.mainComposite, 0);
        label.setText("Path of file with replacements (Leave empty if not used):");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        label.setLayoutData((Object)gdTmp);
        this.pnlReplPath = new TextAndBrowsePanel(this.mainComposite, 0, false);
        this.pnlReplPath.setSaveAs(false);
        this.pnlReplPath.setBrowseFilters("Tab-Delimited Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.pnlReplPath.setLayoutData(gdTmp);
        this.chkSaveLog = new Button(this.mainComposite, 32);
        this.chkSaveLog.setText("Save in the following file a log of the replacements performed:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkSaveLog.setLayoutData((Object)gdTmp);
        this.chkSaveLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.pnlLogPath.setEnabled(ParametersEditor.this.chkSaveLog.getSelection());
            }
        });
        this.pnlLogPath = new TextAndBrowsePanel(this.mainComposite, 0, false);
        this.pnlLogPath.setSaveAs(true);
        this.pnlLogPath.setBrowseFilters("Log Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.pnlLogPath.setLayoutData(gdTmp);
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("Search and Replace");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        this.createComposite((Composite)this.shell);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (ParametersEditor.this.help != null) {
                        ParametersEditor.this.help.showWiki("Search and Replace Step");
                    }
                    return;
                }
                if (e.widget.getData().equals("o") && !ParametersEditor.this.saveData(ParametersEditor.this.params)) {
                    return;
                }
                ParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.setData(this.params);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        this.shell.setSize(600, 400);
        Dialogs.centerWindow(this.shell, parent);
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private boolean showAddItemsDialog() {
        this.dialog = new Shell(this.mainComposite.getShell(), 65648);
        this.dialog.setText("Search And Replace Item");
        this.dialog.setLayout((Layout)new GridLayout());
        Label label = new Label((Composite)this.dialog, 0);
        label.setText("Search expression:");
        this.searchText = new Text((Composite)this.dialog, 2048);
        this.searchText.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)this.dialog, 0);
        label.setText("Replacement expression:");
        this.replacementText = new Text((Composite)this.dialog, 2048);
        this.replacementText.setLayoutData((Object)new GridData(768));
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (ParametersEditor.this.searchText.getText().trim().length() < 1) {
                        Dialogs.showError(ParametersEditor.this.shell, "You need to provide a search expression", null);
                        return;
                    }
                    if (ParametersEditor.this.chkRegEx.getSelection()) {
                        try {
                            Pattern.compile(ParametersEditor.this.searchText.getText());
                            Pattern.compile(ParametersEditor.this.replacementText.getText());
                        }
                        catch (Exception ex) {
                            Dialogs.showError(ParametersEditor.this.shell, ex.getLocalizedMessage(), null);
                            return;
                        }
                    }
                    if (ParametersEditor.this.updateType == 2) {
                        int index = ParametersEditor.this.table.getSelectionIndex();
                        TableItem ti = ParametersEditor.this.table.getItem(index);
                        String[] s = new String[]{"", ParametersEditor.this.searchText.getText(), ParametersEditor.this.replacementText.getText()};
                        ti.setText(s);
                    } else {
                        TableItem item = new TableItem(ParametersEditor.this.table, 0);
                        String[] strs = new String[]{"", ParametersEditor.this.searchText.getText(), ParametersEditor.this.replacementText.getText()};
                        item.setText(strs);
                        item.setChecked(true);
                        ParametersEditor.this.table.setSelection(ParametersEditor.this.table.getItemCount() - 1);
                        ParametersEditor.this.updateUpDownBtnState();
                    }
                }
                ParametersEditor.this.dialog.close();
            }
        };
        this.pnlActionsDialog = new OKCancelPanel((Composite)this.dialog, 0, OKCancelActions, false);
        this.pnlActionsDialog.setLayoutData(new GridData(768));
        this.dialog.setDefaultButton(this.pnlActionsDialog.btOK);
        if (this.updateType == 2) {
            int index = this.table.getSelectionIndex();
            TableItem ti = this.table.getItem(index);
            this.searchText.setText(ti.getText(1));
            this.replacementText.setText(ti.getText(2));
        }
        this.dialog.pack();
        this.dialog.setMinimumSize(this.dialog.getSize());
        Dialogs.centerWindow(this.dialog, this.shell);
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData(Parameters fromParams) {
        this.pnlReplPath.setText(fromParams.getReplacementsPath());
        this.pnlLogPath.setText(fromParams.getLogPath());
        this.chkSaveLog.setSelection(fromParams.getSaveLog());
        this.chkRegEx.setSelection(fromParams.getRegEx());
        this.chkDotAll.setSelection(fromParams.getDotAll());
        this.chkIgnoreCase.setSelection(fromParams.getIgnoreCase());
        this.chkReplaceAll.setSelection(fromParams.getReplaceAll());
        this.chkMultiLine.setSelection(fromParams.getMultiLine());
        this.chkTarget.setSelection(fromParams.getTarget());
        this.chkSource.setSelection(fromParams.getSource());
        this.chkDotAll.setEnabled(this.chkRegEx.getSelection());
        this.chkMultiLine.setEnabled(this.chkRegEx.getSelection());
        this.chkIgnoreCase.setEnabled(this.chkRegEx.getSelection());
        this.chkReplaceAll.setEnabled(this.chkRegEx.getSelection());
        this.table.removeAll();
        for (String[] s : fromParams.rules) {
            TableItem item = new TableItem(this.table, 0);
            String[] strs = new String[]{"", s[1], s[2]};
            item.setText(strs);
            if (!s[0].equals("true")) continue;
            item.setChecked(true);
        }
        this.table.setSelection(0);
        this.updateUpDownBtnState();
        this.pnlLogPath.setEnabled(this.chkSaveLog.getSelection());
    }

    private boolean saveData(Parameters destParams) {
        if (this.chkRegEx.getSelection() && !this.validRegEx()) {
            return false;
        }
        if (this.table.getItemCount() == 0 && this.pnlReplPath.getText().isEmpty()) {
            Dialogs.showError(this.shell, "You need to provide a search expression in the table or to select a replacements file.", null);
            return false;
        }
        destParams.reset();
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            TableItem ti = this.table.getItem(i);
            String[] s = new String[]{Boolean.toString(ti.getChecked()), ti.getText(1), ti.getText(2)};
            destParams.addRule(s);
        }
        destParams.setReplacementsPath(this.pnlReplPath.getText());
        destParams.setRegEx(this.chkRegEx.getSelection());
        destParams.setDotAll(this.chkDotAll.getSelection());
        destParams.setIgnoreCase(this.chkIgnoreCase.getSelection());
        destParams.setReplaceAll(this.chkReplaceAll.getSelection());
        destParams.setMultiLine(this.chkMultiLine.getSelection());
        destParams.setTarget(this.chkTarget.getSelection());
        destParams.setSource(this.chkSource.getSelection());
        destParams.setLogPath(this.pnlLogPath.getText());
        destParams.setSaveLog(this.chkSaveLog.getSelection());
        this.result = true;
        return this.result;
    }

    private boolean validRegEx() {
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            TableItem ti = this.table.getItem(i);
            try {
                Pattern.compile(ti.getText(1));
                Pattern.compile(ti.getText(2));
                continue;
            }
            catch (Exception ex) {
                Dialogs.showError(this.shell, ex.getLocalizedMessage(), null);
                return false;
            }
        }
        return true;
    }
}

