/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.formats.ad.ADSentenceStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.StringUtil;

public class ADChunkSampleStream
implements ObjectStream<ChunkSample> {
    protected final ObjectStream<ADSentenceStream.Sentence> adSentenceStream;
    private int start = -1;
    private int end = -1;
    private int index = 0;
    public static final String OTHER = "O";

    public ADChunkSampleStream(ObjectStream<String> lineStream) {
        this.adSentenceStream = new ADSentenceStream(lineStream);
    }

    public ADChunkSampleStream(InputStreamFactory in, String charsetName) throws IOException {
        try {
            this.adSentenceStream = new ADSentenceStream(new PlainTextByLineStream(in, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    public ADChunkSampleStream(InputStream in, String charsetName) {
        try {
            this.adSentenceStream = new ADSentenceStream(new PlainTextByLineStream(in, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ChunkSample read() throws IOException {
        ADSentenceStream.Sentence paragraph;
        while ((paragraph = this.adSentenceStream.read()) != null) {
            if (this.end > -1 && this.index >= this.end) {
                return null;
            }
            if (this.start > -1 && this.index < this.start) {
                ++this.index;
                continue;
            }
            ADSentenceStream.SentenceParser.Node root = paragraph.getRoot();
            ArrayList<String> sentence = new ArrayList<String>();
            ArrayList<String> tags = new ArrayList<String>();
            ArrayList<String> target = new ArrayList<String>();
            this.processRoot(root, sentence, tags, target);
            if (sentence.size() <= 0) continue;
            ++this.index;
            return new ChunkSample(sentence, tags, target);
        }
        return null;
    }

    protected void processRoot(ADSentenceStream.SentenceParser.Node root, List<String> sentence, List<String> tags, List<String> target) {
        if (root != null) {
            ADSentenceStream.SentenceParser.TreeElement[] elements = root.getElements();
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i].isLeaf()) {
                    this.processLeaf((ADSentenceStream.SentenceParser.Leaf)elements[i], false, OTHER, sentence, tags, target);
                    continue;
                }
                this.processNode((ADSentenceStream.SentenceParser.Node)elements[i], sentence, tags, target, null);
            }
        }
    }

    private void processNode(ADSentenceStream.SentenceParser.Node node, List<String> sentence, List<String> tags, List<String> target, String inheritedTag) {
        String phraseTag = this.getChunkTag(node);
        boolean inherited = false;
        if (phraseTag.equals(OTHER) && inheritedTag != null) {
            phraseTag = inheritedTag;
            inherited = true;
        }
        ADSentenceStream.SentenceParser.TreeElement[] elements = node.getElements();
        block0: for (int i = 0; i < elements.length; ++i) {
            if (elements[i].isLeaf()) {
                boolean isIntermediate = false;
                String tag = phraseTag;
                ADSentenceStream.SentenceParser.Leaf leaf = (ADSentenceStream.SentenceParser.Leaf)elements[i];
                String localChunk = this.getChunkTag(leaf);
                if (localChunk != null && !tag.equals(localChunk)) {
                    tag = localChunk;
                }
                if (this.isIntermediate(tags, target, tag) && (inherited || i > 0)) {
                    isIntermediate = true;
                }
                if (!(this.isIncludePunctuations() || leaf.getFunctionalTag() != null || i + 1 < elements.length && elements[i + 1].isLeaf() && i > 0 && elements[i - 1].isLeaf())) {
                    isIntermediate = false;
                    tag = OTHER;
                }
                this.processLeaf(leaf, isIntermediate, tag, sentence, tags, target);
                continue;
            }
            int before = target.size();
            this.processNode((ADSentenceStream.SentenceParser.Node)elements[i], sentence, tags, target, phraseTag);
            for (int j = target.size() - 1; j >= before; --j) {
                if (target.get(j).endsWith("-" + phraseTag)) continue;
                phraseTag = OTHER;
                continue block0;
            }
        }
    }

    protected void processLeaf(ADSentenceStream.SentenceParser.Leaf leaf, boolean isIntermediate, String phraseTag, List<String> sentence, List<String> tags, List<String> target) {
        if (leaf.getFunctionalTag() != null && phraseTag.equals(OTHER)) {
            phraseTag = this.getPhraseTagFromPosTag(leaf.getFunctionalTag());
        }
        String chunkTag = !phraseTag.equals(OTHER) ? (isIntermediate ? "I-" + phraseTag : "B-" + phraseTag) : phraseTag;
        sentence.add(leaf.getLexeme());
        if (leaf.getSyntacticTag() == null) {
            tags.add(leaf.getLexeme());
        } else {
            tags.add(ADChunkSampleStream.convertFuncTag(leaf.getFunctionalTag(), false));
        }
        target.add(chunkTag);
    }

    protected String getPhraseTagFromPosTag(String functionalTag) {
        if (functionalTag.equals("v-fin")) {
            return "VP";
        }
        if (functionalTag.equals("n")) {
            return "NP";
        }
        return OTHER;
    }

    public static String convertFuncTag(String t, boolean useCGTags) {
        if (useCGTags && ("art".equals(t) || "pron-det".equals(t) || "pron-indef".equals(t))) {
            t = "det";
        }
        return t;
    }

    protected String getChunkTag(ADSentenceStream.SentenceParser.Leaf leaf) {
        String tag = leaf.getSyntacticTag();
        if ("P".equals(tag)) {
            return "VP";
        }
        return null;
    }

    protected String getChunkTag(ADSentenceStream.SentenceParser.Node node) {
        String tag = node.getSyntacticTag();
        String phraseTag = tag.substring(tag.lastIndexOf(":") + 1);
        while (phraseTag.endsWith("-")) {
            phraseTag = phraseTag.substring(0, phraseTag.length() - 1);
        }
        phraseTag = phraseTag.equals("np") || phraseTag.equals("vp") || phraseTag.equals("pp") || phraseTag.equals("ap") || phraseTag.equals("advp") || phraseTag.equals("adjp") ? StringUtil.toUpperCase(phraseTag) : OTHER;
        return phraseTag;
    }

    public void setStart(int aStart) {
        this.start = aStart;
    }

    public void setEnd(int aEnd) {
        this.end = aEnd;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.adSentenceStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.adSentenceStream.close();
    }

    protected boolean isIncludePunctuations() {
        return false;
    }

    protected boolean isIntermediate(List<String> tags, List<String> target, String phraseTag) {
        return target.size() > 0 && target.get(target.size() - 1).endsWith("-" + phraseTag);
    }
}

