//
//  NSPasteboard_BLTRExtensions.h
//  Quicksilver
//
//  Created by Alcor on Sun Nov 09 2003.
//  Copyright (c) 2003 Blacktree, Inc.. All rights reserved.
//

extern NSString *QSPasteboardTransientType;
extern NSString *QSPasteboardAutoGeneratedType;
extern NSString *QSPasteboardConcealedType;

#define QSPasteboardTransientTypes @[QSPasteboardTransientType, @"QSPrivatePboardType", \
                                    @"de.petermaurer.TransientPasteboardType", @"com.typeit4me.clipping", @"Pasteboard generator type", @"com.agilebits.onepassword"]

#define QSPasteboardAutoGeneratedTypes @[QSPasteboardAutoGeneratedType]

#define QSPasteboardConcealedTypes @[QSPasteboardConcealedType, @"com.agilebits.onepassword"]

void QSForcePaste();

@interface NSPasteboard (Clippings)
+ (NSPasteboard *)pasteboardByFilteringClipping:(NSString *)pacg;
// We cannot use instance methods because we might get passed a proxy through NSConnection
+ (BOOL)isPasteboardTransient:(NSPasteboard *)pasteboard;
+ (BOOL)isPasteboardAutoGenerated:(NSPasteboard *)pasteboard;
+ (BOOL)isPasteboardConcealed:(NSPasteboard *)pasteboard;
@end

#define QSPrivatePboardType QSPasteboardTransientType // Deprecated, use QSPasteboardTransientType or -[NSPasteboard isTransient]

#define standardPasteboardTypes [NSArray arrayWithObjects:@"Apple URL pasteboard type", NSColorPboardType, NSFileContentsPboardType, NSFilenamesPboardType, NSFontPboardType, NSHTMLPboardType, NSPDFPboardType, NSPostScriptPboardType, NSRulerPboardType, NSRTFPboardType, NSRTFDPboardType, NSStringPboardType, NSTabularTextPboardType, NSTIFFPboardType, NSURLPboardType, NSVCardPboardType, NSFilesPromisePboardType, nil]

#define clippingTypes [NSSet setWithObjects:@"textClipping", @"pictClipping", @"'clpp'", @"'clpt'", @"webloc", @"inetloc", @"'ilht'", @"'ilaf'", nil]
#define PLISTTYPES [NSArray arrayWithObjects:NSFilenamesPboardType, @"ABPeopleUIDsPboardType", @"WebURLsWithTitlesPboardType", @"AddressesPboardType", nil]
#define TEXTTYPES [NSSet setWithObjects:@"QSObjectID", NSStringPboardType, @"NeXT plain ascii pasteboard type", NSTabularTextPboardType, NSHTMLPboardType, nil]
#define SYLETYPES [NSSet setWithObjects:NSStringPboardType, @"NeXT Rich Text Format v1.0 pasteboard type", @"NeXT Rich Text Format v1.0 pasteboard type", nil]
#define URLTYPES [NSSet setWithObjects:NSURLPboardType, nil]
#define IMAGETYPES [NSSet setWithArray:[NSImage imagePasteboardTypes]]
#define OTHERTYPES [NSSet setWithObjects:NSColorPboardType, nil]
#define CONTACTTYPES [NSSet setWithObjects:NSVCardPboardType, nil]
