/*

SDRplay Limited
SDRPLAY END USER LICENCE AGREEMENT

The SDRplay software ("Product") you are about to install, run and/or use is licensed by SDRplay Limited, a company registered in England (No. 05046393), whose registered office is  6 Thornes Office Park  Monkton Road WAKEFIELD WF2 7AN ("SDRplay"), and is subject to the following licence terms ("Licence"). "You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.

By proceeding to install, run and/or use the Product, you confirm that you accept and agree to be bound by the terms of this Licence. If you do not agree to any of the terms of this Licence, SDRplay is unwilling to provide access to the Product to you and you should not proceed further and may not use the Product.

1.            Licence To Use The Product.

1.1          Grant of Licence.

Subject to the terms and conditions of this License, SDRplay hereby grants to you a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable license to reproduce, publicly display, publicly perform, create Derivative works, incorporate in other products sublicense, and distribute the Product in Object form.
 
1.2          Restrictions.  You may not: modify, disassemble, decompile or reverse engineer the Product, except to the extent specifically authorised under applicable law notwithstanding contractual prohibition.

1.3.         Redistribution. You may reproduce and distribute copies of the Product in any medium, without modifications, in Object form, provided that you meet the following conditions:

1.    You must give any other recipients of the Product or Derivative Works a copy of this License; and

2.    You must cause any modified files to carry prominent notices stating that You changed the files; and

3.    Any Derivative Works that You distribute must include a readable statement that the Copyright in the Product is owned by and licensed by SDRplay.  You may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the statement, provided that such additional attribution notices cannot be construed as modifying the License.
 
You may add Your own copyright statement to Your modifications and may provide additional or different license terms and conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole, provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this License.
 
1.3          Open Source Software.  The Product may contain code, commonly referred to as open source software, which is distributed under any of the many known variations of open source licence terms, including terms which allow the free distribution and modification of the relevant software's source code and/or which require all distributors to make such source code freely available upon request, including any contributions or modifications made by such distributor (collectively, "Open Source Software"). To the extent that the Product contains any Open Source Software, that element only is licensed to you pursuant to the relevant licence terms of the applicable third party licensor ("Open Source Licence Terms") and not pursuant to this Licence, and you accept and agree to be bound by such terms. A copy of the Open Source Licence Terms will be made available upon request.

2.            Confidentiality Obligations.  You acknowledge that the Product contains confidential, proprietary and trade secret information belonging to SDRplay and you agree to hold such information, and any other confidential or proprietary information of SDRplay (collectively, "Confidential Information") in strict confidence and agree not to disclose any Confidential Information to any third party. You will have no obligation to maintain the confidentiality of any information which: (a) is or becomes publicly available without breach of this Licence; (b) is rightfully received by you from a third party without an obligation of confidentiality and without breach of this Licence; (c) is required to be disclosed by law or regulation or by court order; or (d) has been approved for release by written permission of SDRplay.

3.            Ownership.  You acknowledge and agree that SDRplay or its third party licensors own all rights, title and interest in and to the Product and all modifications, enhancements and derivative works SDRplay may develop to or from the Product and any and all intellectual property rights in all of the foregoing. You agree not to use any of SDRplay's trademarks or other business names included in the Product for any purpose. You acknowledge that, except as expressly set out in this Licence, nothing in this Licence will give you rights in respect of any intellectual property rights owned by SDRplay or its licensors. All intellectual property rights and other rights of SDRplay and its licensors which are not expressly granted to you by this Licence are reserved.

4.            Limited Warranty.  SDRplay warrants that the Product will, under normal operating conditions, operate substantially in accordance with SDRplay' published specification for the Product. SDRplay does not represent or warrant that: (a) the use of the Product will be secure, timely, uninterrupted or error-free or compatible in combination with any other hardware, software, system or data; (b) the Product will meet your expectations; (c) errors or defects in the Product will be corrected; or that (d) the Product is free of viruses or other harmful components. SDRplay makes no representation and gives no warranty in respect of any Open Source Software component of the Product.

Except as expressly set out in this Licence, no implied conditions, warranties or other terms, including any implied terms relating to satisfactory quality or fitness for any purpose, will apply to the Product and, to the maximum extent permitted by applicable law, are excluded by SDRplay.

5.            SDRplay' Liability.  Nothing in this Licence will limit or exclude SDRplay' liability to you: (a) for death or personal injury caused by SDRplay' negligence; (b) for fraud; (c) for breach of any obligations implied by section 12 of the Sale of Goods Act 1979 or section 2 of the Supply of Goods and Services Act 1982; or (d) for any other liability that may not, under applicable law, be limited or excluded. Subject to this, in no event will SDRplay be liable to you for any indirect or consequential losses, or for any loss of profit, revenue, contracts, data, goodwill or other similar losses, and any liability SDRplay does have for losses you suffer arising under or in connection with this Licence and/or the Product is strictly limited to losses that were reasonably foreseeable.

6.            General.    You may not transfer or assign any or all of your rights and/or obligations under this Licence. All notices given by you to SDRplay must be given in writing to SDRplay' registered office address. If SDRplay fails to enforce any of our rights, that does not result in a waiver of that right. If any provision of these terms and conditions is found to be unenforceable, all other provisions shall remain unaffected. The terms of this Licence may not be varied except with SDRplay's express written consent. The terms of this Licence represent the entire agreement between you and SDRplay in relation to the subject matter of this Licence. The terms of this Licence shall be governed by English law and you agree that any claim you may have against SDRplay arising under or in connection with this Licence and/or the Product may only be dealt with by the English courts, provided that, if you are a consumer: (a) and you live in a part of the United Kingdom other than England, the applicable law of that part of the United Kingdom will govern and any claim may be brought by you before the courts there; or (b) you live in another member state of the European Union, any claim may be brought by you before the courts there.

*/

//
// Copyright (c) 2013 Mirics Ltd, All Rights Reserved
//

#ifndef MIR_SDR_H
#define MIR_SDR_H

#ifndef _MIR_SDR_QUALIFIER
#if !defined(STATIC_LIB) && (defined(_M_X64) || defined(_M_IX86)) 
#define _MIR_SDR_QUALIFIER __declspec(dllimport)
#elif defined(STATIC_LIB) || defined(__GNUC__) 
#define _MIR_SDR_QUALIFIER
#endif
#endif  // _MIR_SDR_QUALIFIER

// Application code should check that it is compiled against the same API version
// mir_sdr_ApiVersion() returns the API version 
#define MIR_SDR_API_VERSION   (float)(2.13)

#if defined(ANDROID) || defined(__ANDROID__)
// Android requires a mechanism to request info from Java application
typedef enum
{
  mir_sdr_GetFd              = 0,
  mir_sdr_FreeFd             = 1,
  mir_sdr_DevNotFound        = 2,
  mir_sdr_DevRemoved         = 3,
  mir_sdr_GetVendorId        = 4,
  mir_sdr_GetProductId       = 5,
  mir_sdr_GetRevId           = 6,
  mir_sdr_GetDeviceId        = 7
} mir_sdr_JavaReqT;

typedef int (*mir_sdr_SendJavaReq_t)(mir_sdr_JavaReqT cmd, char *path, char *serNum);
#endif

typedef enum
{
  mir_sdr_Success            = 0,
  mir_sdr_Fail               = 1,
  mir_sdr_InvalidParam       = 2,
  mir_sdr_OutOfRange         = 3,
  mir_sdr_GainUpdateError    = 4,
  mir_sdr_RfUpdateError      = 5,
  mir_sdr_FsUpdateError      = 6,
  mir_sdr_HwError            = 7,
  mir_sdr_AliasingError      = 8,
  mir_sdr_AlreadyInitialised = 9,
  mir_sdr_NotInitialised     = 10,
  mir_sdr_NotEnabled         = 11,
  mir_sdr_HwVerError         = 12,
  mir_sdr_OutOfMemError      = 13,
  mir_sdr_HwRemoved          = 14
} mir_sdr_ErrT;

typedef enum
{
  mir_sdr_BW_Undefined = 0,
  mir_sdr_BW_0_200     = 200,
  mir_sdr_BW_0_300     = 300,
  mir_sdr_BW_0_600     = 600,
  mir_sdr_BW_1_536     = 1536,
  mir_sdr_BW_5_000     = 5000,
  mir_sdr_BW_6_000     = 6000,
  mir_sdr_BW_7_000     = 7000,
  mir_sdr_BW_8_000     = 8000
} mir_sdr_Bw_MHzT;

typedef enum
{
  mir_sdr_IF_Undefined = -1,
  mir_sdr_IF_Zero      = 0,
  mir_sdr_IF_0_450     = 450,
  mir_sdr_IF_1_620     = 1620,
  mir_sdr_IF_2_048     = 2048
} mir_sdr_If_kHzT;

typedef enum
{
  mir_sdr_ISOCH = 0,
  mir_sdr_BULK  = 1
} mir_sdr_TransferModeT;

typedef enum
{
  mir_sdr_CHANGE_NONE    = 0x00,
  mir_sdr_CHANGE_GR      = 0x01,
  mir_sdr_CHANGE_FS_FREQ = 0x02,
  mir_sdr_CHANGE_RF_FREQ = 0x04,
  mir_sdr_CHANGE_BW_TYPE = 0x08,
  mir_sdr_CHANGE_IF_TYPE = 0x10,
  mir_sdr_CHANGE_LO_MODE = 0x20,
  mir_sdr_CHANGE_AM_PORT = 0x40
} mir_sdr_ReasonForReinitT;

typedef enum
{
  mir_sdr_LO_Undefined = 0,
  mir_sdr_LO_Auto      = 1,
  mir_sdr_LO_120MHz    = 2,
  mir_sdr_LO_144MHz    = 3,
  mir_sdr_LO_168MHz    = 4
} mir_sdr_LoModeT;

typedef enum
{
  mir_sdr_BAND_AM_LO   = 0,
  mir_sdr_BAND_AM_MID  = 1,
  mir_sdr_BAND_AM_HI   = 2,
  mir_sdr_BAND_VHF     = 3,
  mir_sdr_BAND_3       = 4,
  mir_sdr_BAND_X       = 5,
  mir_sdr_BAND_4_5     = 6,
  mir_sdr_BAND_L       = 7
} mir_sdr_BandT;

typedef enum
{
  mir_sdr_USE_SET_GR                = 0,
  mir_sdr_USE_SET_GR_ALT_MODE       = 1,
  mir_sdr_USE_RSP_SET_GR            = 2
} mir_sdr_SetGrModeT;

typedef enum
{
  mir_sdr_RSPII_BAND_UNKNOWN = 0,
  mir_sdr_RSPII_BAND_AM_LO   = 1,
  mir_sdr_RSPII_BAND_AM_MID  = 2,
  mir_sdr_RSPII_BAND_AM_HI   = 3,
  mir_sdr_RSPII_BAND_VHF     = 4,
  mir_sdr_RSPII_BAND_3       = 5,
  mir_sdr_RSPII_BAND_X_LO    = 6,
  mir_sdr_RSPII_BAND_X_MID   = 7,
  mir_sdr_RSPII_BAND_X_HI    = 8,
  mir_sdr_RSPII_BAND_4_5     = 9,
  mir_sdr_RSPII_BAND_L       = 10
} mir_sdr_RSPII_BandT;

typedef enum
{
  mir_sdr_RSPII_ANTENNA_A = 5,
  mir_sdr_RSPII_ANTENNA_B = 6
} mir_sdr_RSPII_AntennaSelectT;

typedef enum
{
  mir_sdr_AGC_DISABLE  = 0,
  mir_sdr_AGC_100HZ    = 1,
  mir_sdr_AGC_50HZ     = 2,
  mir_sdr_AGC_5HZ      = 3
} mir_sdr_AgcControlT;

typedef enum
{
  mir_sdr_GAIN_MESSAGE_START_ID  = 0x80000000,
  mir_sdr_ADC_OVERLOAD_DETECTED  = mir_sdr_GAIN_MESSAGE_START_ID + 1,
  mir_sdr_ADC_OVERLOAD_CORRECTED = mir_sdr_GAIN_MESSAGE_START_ID + 2
} mir_sdr_GainMessageIdT;

typedef enum
{
  mir_sdr_EXTENDED_MIN_GR = 0,
  mir_sdr_NORMAL_MIN_GR   = 20
} mir_sdr_MinGainReductionT;

typedef struct 
{
   char *SerNo;
   char *DevNm;
   unsigned char hwVer;
   unsigned char devAvail;
} mir_sdr_DeviceT;

typedef struct
{
   float curr;
   float max;
   float min;
} mir_sdr_GainValuesT;

typedef enum
{
   mir_sdr_rspDuo_Tuner_1 = 1,
   mir_sdr_rspDuo_Tuner_2 = 2,
} mir_sdr_rspDuo_TunerSelT;

// mir_sdr_StreamInit() callback function prototypes
typedef void (*mir_sdr_StreamCallback_t)(short *xi, short *xq, unsigned int firstSampleNum, int grChanged, int rfChanged, int fsChanged, unsigned int numSamples, unsigned int reset, unsigned int hwRemoved, void *cbContext); 
typedef void (*mir_sdr_GainChangeCallback_t)(unsigned int gRdB, unsigned int lnaGRdB, void *cbContext); 

typedef mir_sdr_ErrT (*mir_sdr_Init_t)(int gRdB, double fsMHz, double rfMHz, mir_sdr_Bw_MHzT bwType, mir_sdr_If_kHzT ifType, int *samplesPerPacket);
typedef mir_sdr_ErrT (*mir_sdr_Uninit_t)(void);
typedef mir_sdr_ErrT (*mir_sdr_ReadPacket_t)(short *xi, short *xq, unsigned int *firstSampleNum, int *grChanged, int *rfChanged, int *fsChanged);
typedef mir_sdr_ErrT (*mir_sdr_SetRf_t)(double drfHz, int abs, int syncUpdate);
typedef mir_sdr_ErrT (*mir_sdr_SetFs_t)(double dfsHz, int abs, int syncUpdate, int reCal);
typedef mir_sdr_ErrT (*mir_sdr_SetGr_t)(int gRdB, int abs, int syncUpdate);
typedef mir_sdr_ErrT (*mir_sdr_SetGrParams_t)(int minimumGr, int lnaGrThreshold);
typedef mir_sdr_ErrT (*mir_sdr_SetDcMode_t)(int dcCal, int speedUp);
typedef mir_sdr_ErrT (*mir_sdr_SetDcTrackTime_t)(int trackTime);
typedef mir_sdr_ErrT (*mir_sdr_SetSyncUpdateSampleNum_t)(unsigned int sampleNum);
typedef mir_sdr_ErrT (*mir_sdr_SetSyncUpdatePeriod_t)(unsigned int period);
typedef mir_sdr_ErrT (*mir_sdr_ApiVersion_t)(float *version);   
typedef mir_sdr_ErrT (*mir_sdr_ResetUpdateFlags_t)(int resetGainUpdate, int resetRfUpdate, int resetFsUpdate);   
#if defined(ANDROID) || defined(__ANDROID__)
typedef mir_sdr_ErrT (*mir_sdr_SetJavaReqCallback_t)(mir_sdr_SendJavaReq_t sendJavaReq);   
#endif
typedef mir_sdr_ErrT (*mir_sdr_SetTransferMode_t)(mir_sdr_TransferModeT mode);
typedef mir_sdr_ErrT (*mir_sdr_DownConvert_t)(short *in, short *xi, short *xq, unsigned int samplesPerPacket, mir_sdr_If_kHzT ifType, unsigned int M, unsigned int preReset);
typedef mir_sdr_ErrT (*mir_sdr_SetParam_t)(unsigned int id, unsigned int value);   
typedef mir_sdr_ErrT (*mir_sdr_SetPpm_t)(double ppm);   
typedef mir_sdr_ErrT (*mir_sdr_SetLoMode_t)(mir_sdr_LoModeT loMode);                   
typedef mir_sdr_ErrT (*mir_sdr_SetGrAltMode_t)(int *gRidx, int LNAstate, int *gRdBsystem, int abs, int syncUpdate);
typedef mir_sdr_ErrT (*mir_sdr_DCoffsetIQimbalanceControl_t)(unsigned int DCenable, unsigned int IQenable);   
typedef mir_sdr_ErrT (*mir_sdr_DecimateControl_t)(unsigned int enable, unsigned int decimationFactor, unsigned int wideBandSignal); 
typedef mir_sdr_ErrT (*mir_sdr_AgcControl_t)(mir_sdr_AgcControlT enable, int setPoint_dBfs, int knee_dBfs, unsigned int decay_ms, unsigned int hang_ms, int syncUpdate, int LNAstate); 
typedef mir_sdr_ErrT (*mir_sdr_StreamInit_t)(int *gRdB, double fsMHz, double rfMHz, mir_sdr_Bw_MHzT bwType, mir_sdr_If_kHzT ifType, int LNAstate, int *gRdBsystem, mir_sdr_SetGrModeT setGrMode, int *samplesPerPacket, mir_sdr_StreamCallback_t StreamCbFn, mir_sdr_GainChangeCallback_t GainChangeCbFn, void *cbContext); 
typedef mir_sdr_ErrT (*mir_sdr_StreamUninit_t)(void); 
typedef mir_sdr_ErrT (*mir_sdr_Reinit_t)(int *gRdB, double fsMHz, double rfMHz, mir_sdr_Bw_MHzT bwType, mir_sdr_If_kHzT ifType, mir_sdr_LoModeT loMode, int LNAstate, int *gRdBsystem, mir_sdr_SetGrModeT setGrMode, int *samplesPerPacket, mir_sdr_ReasonForReinitT reasonForReinit);
typedef mir_sdr_ErrT (*mir_sdr_GetGrByFreq_t)(double rfMHz, mir_sdr_BandT *band, int *gRdB, int LNAstate, int *gRdBsystem, mir_sdr_SetGrModeT setGrMode); 
typedef mir_sdr_ErrT (*mir_sdr_DebugEnable_t)(unsigned int enable);    
typedef mir_sdr_ErrT (*mir_sdr_GetCurrentGain_t)(mir_sdr_GainValuesT *gainVals);    
typedef mir_sdr_ErrT (*mir_sdr_GainChangeCallbackMessageReceived_t)(void); 

typedef mir_sdr_ErrT (*mir_sdr_GetDevices_t)(mir_sdr_DeviceT *devices, unsigned int *numDevs, unsigned int maxDevs);    
typedef mir_sdr_ErrT (*mir_sdr_SetDeviceIdx_t)(unsigned int idx);    
typedef mir_sdr_ErrT (*mir_sdr_ReleaseDeviceIdx_t)(void);    
typedef mir_sdr_ErrT (*mir_sdr_GetHwVersion_t)(unsigned char *ver);    
typedef mir_sdr_ErrT (*mir_sdr_RSPII_AntennaControl_t)(mir_sdr_RSPII_AntennaSelectT select); 
typedef mir_sdr_ErrT (*mir_sdr_RSPII_ExternalReferenceControl_t)(unsigned int output_enable); 
typedef mir_sdr_ErrT (*mir_sdr_RSPII_BiasTControl_t)(unsigned int enable); 
typedef mir_sdr_ErrT (*mir_sdr_RSPII_RfNotchEnable_t)(unsigned int enable); 

typedef mir_sdr_ErrT (*mir_sdr_RSP_SetGr_t)(int gRdB, int LNAstate, int abs, int syncUpdate);
typedef mir_sdr_ErrT (*mir_sdr_RSP_SetGrLimits_t)(mir_sdr_MinGainReductionT minGr);

typedef mir_sdr_ErrT (*mir_sdr_AmPortSelect_t)(int port);                          

typedef mir_sdr_ErrT (*mir_sdr_rsp1a_BiasT_t)(int enable);
typedef mir_sdr_ErrT (*mir_sdr_rsp1a_DabNotch_t)(int enable);
typedef mir_sdr_ErrT (*mir_sdr_rsp1a_BroadcastNotch_t)(int enable);

typedef mir_sdr_ErrT (*mir_sdr_rspDuo_TunerSel_t)(mir_sdr_rspDuo_TunerSelT sel);
typedef mir_sdr_ErrT (*mir_sdr_rspDuo_ExtRef_t)(int enable);
typedef mir_sdr_ErrT (*mir_sdr_rspDuo_BiasT_t)(int enable);
typedef mir_sdr_ErrT (*mir_sdr_rspDuo_Tuner1AmNotch_t)(int enable);
typedef mir_sdr_ErrT (*mir_sdr_rspDuo_BroadcastNotch_t)(int enable);
typedef mir_sdr_ErrT (*mir_sdr_rspDuo_DabNotch_t)(int enable);

// API function definitions
#ifdef __cplusplus
extern "C"
{
#endif

   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_Init(int gRdB, double fsMHz, double rfMHz, mir_sdr_Bw_MHzT bwType, mir_sdr_If_kHzT ifType, int *samplesPerPacket);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_Uninit(void);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_ReadPacket(short *xi, short *xq, unsigned int *firstSampleNum, int *grChanged, int *rfChanged, int *fsChanged);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetRf(double drfHz, int abs, int syncUpdate);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetFs(double dfsHz, int abs, int syncUpdate, int reCal);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetGr(int gRdB, int abs, int syncUpdate);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetGrParams(int minimumGr, int lnaGrThreshold);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetDcMode(int dcCal, int speedUp);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetDcTrackTime(int trackTime);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetSyncUpdateSampleNum(unsigned int sampleNum);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetSyncUpdatePeriod(unsigned int period);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_ApiVersion(float *version);    // Called by application to retrieve version of API used to create Dll
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_ResetUpdateFlags(int resetGainUpdate, int resetRfUpdate, int resetFsUpdate);    
#if defined(ANDROID) || defined(__ANDROID__)
   // This function provides a machanism for the Java application to set
   // the callback function used to send request to it
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetJavaReqCallback(mir_sdr_SendJavaReq_t sendJavaReq);   
#endif
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetTransferMode(mir_sdr_TransferModeT mode);   
   /*
    * This following function will only operate correctly for the parameters detailed in the table below:
    *
    *      IF freq | Signal BW | Input Sample Rate | Output Sample Rate | Required Decimation Factor 
    *     -------------------------------------------------------------------------------------------
    *       450kHz |   200kHz  |     2000kHz       |       500kHz       |          M=4
    *       450kHz |   300kHz  |     2000kHz       |       500kHz       |          M=4
    *       450kHz |   600kHz  |     2000kHz       |      1000kHz       |          M=2
    *      2048kHz |  1536kHz  |     8192kHz       |      2048kHz       |          M=4
    *
    * If preReset == 1, then the filter state will be reset to 0 before starting the filtering operation.
    */
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_DownConvert(short *in, short *xi, short *xq, unsigned int samplesPerPacket, mir_sdr_If_kHzT ifType, unsigned int M, unsigned int preReset);   
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetParam(unsigned int id, unsigned int value);   // This MAY be called before mir_sdr_Init()

   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetPpm(double ppm);                              // This MAY be called before mir_sdr_Init()
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetLoMode(mir_sdr_LoModeT loMode);               // This MUST be called before mir_sdr_Init()/mir_sdr_StreamInit() - otherwise use mir_sdr_Reinit()         
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetGrAltMode(int *gRidx, int LNAstate, int *gRdBsystem, int abs, int syncUpdate);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_DCoffsetIQimbalanceControl(unsigned int DCenable, unsigned int IQenable);   
   /*
    * Valid decimation factors for the following function are 2, 4, 8, 16 or 32 only
    * Setting wideBandSignal=1 will use a slower filter but minimise the in-band roll-off
    */
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_DecimateControl(unsigned int enable, unsigned int decimationFactor, unsigned int wideBandSignal); 
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_AgcControl(mir_sdr_AgcControlT enable, int setPoint_dBfs, int knee_dBfs, unsigned int decay_ms, unsigned int hang_ms, int syncUpdate, int LNAstate); 
   /*
    * mir_sdr_StreamInit() replaces mir_sdr_Init() and sets up a thread (or chain of threads) inside the API which will perform the processing chain (shown below),
    * and then use the callback function to return the data to the calling application/plug-in.
	 * Processing chain (in order):
    * mir_sdr_ReadPacket()
    * DCoffsetCorrection()     - LIF mode - enabled by default
    * DownConvert()            - automatically enabled if the parameters shown for mir_sdr_DownConvert() are selected
    * Decimate()               - disabled by default
    * DCoffsetCorrection()     - ZIF mode - enabled by default
    * IQimbalanceCorrection()  - enabled by default
    * Agc()                    - disabled by default
	 */
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_StreamInit(int *gRdB, double fsMHz, double rfMHz, mir_sdr_Bw_MHzT bwType, mir_sdr_If_kHzT ifType, int LNAstate, int *gRdBsystem, mir_sdr_SetGrModeT setGrMode, int *samplesPerPacket, mir_sdr_StreamCallback_t StreamCbFn, mir_sdr_GainChangeCallback_t GainChangeCbFn, void *cbContext); 
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_StreamUninit(void); 
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_Reinit(int *gRdB, double fsMHz, double rfMHz, mir_sdr_Bw_MHzT bwType, mir_sdr_If_kHzT ifType, mir_sdr_LoModeT loMode, int LNAstate, int *gRdBsystem, mir_sdr_SetGrModeT setGrMode, int *samplesPerPacket, mir_sdr_ReasonForReinitT reasonForReinit);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_GetGrByFreq(double rfMHz, mir_sdr_BandT *band, int *gRdB, int LNAstate, int *gRdBsystem, mir_sdr_SetGrModeT setGrMode);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_DebugEnable(unsigned int enable);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_GetCurrentGain(mir_sdr_GainValuesT *gainVals);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_GainChangeCallbackMessageReceived(void); 

   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_GetDevices(mir_sdr_DeviceT *devices, unsigned int *numDevs, unsigned int maxDevs);    
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_SetDeviceIdx(unsigned int idx);   
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_ReleaseDeviceIdx(void);   
   /*
    * Uninit: ver = 0
    * RSPI :  ver = 1
    * RSPII:  ver = 2
    */
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_GetHwVersion(unsigned char *ver);   
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_RSPII_AntennaControl(mir_sdr_RSPII_AntennaSelectT select); 
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_RSPII_ExternalReferenceControl(unsigned int output_enable); 
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_RSPII_BiasTControl(unsigned int enable); 
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_RSPII_RfNotchEnable(unsigned int enable); 

   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_RSP_SetGr(int gRdB, int LNAstate, int abs, int syncUpdate);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_RSP_SetGrLimits(mir_sdr_MinGainReductionT minGr);

   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_AmPortSelect(int port);   // If called after mir_sdr_Init() a call to mir_sdr_Reinit(..., reasonForReinit = mir_sdr_CHANGE_AM_PORT)
                                                                     // is also required to change the port

   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_rsp1a_BiasT(int enable);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_rsp1a_DabNotch(int enable);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_rsp1a_BroadcastNotch(int enable);

   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_rspDuo_TunerSel(mir_sdr_rspDuo_TunerSelT sel);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_rspDuo_ExtRef(int enable);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_rspDuo_BiasT(int enable);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_rspDuo_Tuner1AmNotch(int enable);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_rspDuo_BroadcastNotch(int enable);
   _MIR_SDR_QUALIFIER mir_sdr_ErrT mir_sdr_rspDuo_DabNotch(int enable);

#ifdef __cplusplus
}
#endif

#endif //MIR_SDR_H
