/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IHistogram;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IManagedObject;
import hep.aida.IMeasurement;
import hep.aida.IProfile;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITuple;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public abstract class AidaTestCase
extends TestCase {
    static final double relPrec = 1.0E-10;
    private Random rnd;
    private long rndSeed = System.currentTimeMillis();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$hep$aida$ITuple;
    static /* synthetic */ Class class$java$lang$Object;

    AidaTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.rnd = new Random(this.rndSeed);
    }

    protected void saveRandomSeed() {
        File outFile = new File(this.getName() + "_" + System.currentTimeMillis() + ".seed");
        try {
            FileWriter out = new FileWriter(outFile);
            out.write(String.valueOf(this.rndSeed));
            out.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    protected void setRandomSeed(long seed) {
        this.rndSeed = seed;
    }

    protected Random getRandomNumberGenerator() {
        return this.rnd;
    }

    static void assertEquals(IManagedObject obj1, IManagedObject obj2) {
        Assert.assertEquals((String)obj1.name(), (String)obj2.name());
    }

    static void assertEquals(IBaseHistogram h1, IBaseHistogram h2) {
        if (h1 instanceof IManagedObject && h2 instanceof IManagedObject) {
            AidaTestCase.assertEquals((IManagedObject)h1, (IManagedObject)h2);
        }
        Assert.assertEquals((int)h1.dimension(), (int)h2.dimension());
        Assert.assertEquals((String)h1.title(), (String)h2.title());
        Assert.assertEquals((int)h1.entries(), (int)h2.entries());
        AidaTestCase.assertEquals(h1.annotation(), h2.annotation());
    }

    static void assertEquals(IHistogram h1, IHistogram h2) {
        AidaTestCase.assertEquals((IBaseHistogram)h1, (IBaseHistogram)h2);
        Assert.assertEquals((int)h1.allEntries(), (int)h2.allEntries());
        Assert.assertEquals((int)h1.extraEntries(), (int)h2.extraEntries());
        AidaTestCase.assertEqualsDouble(h1.sumBinHeights(), h2.sumBinHeights(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.sumExtraBinHeights(), h2.sumExtraBinHeights(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.sumAllBinHeights(), h2.sumAllBinHeights(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.minBinHeight(), h2.minBinHeight(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.maxBinHeight(), h2.maxBinHeight(), 1.0E-10);
    }

    static void assertEquals(IHistogram1D h1, IHistogram1D h2) {
        AidaTestCase.assertEquals((IHistogram)h1, (IHistogram)h2);
        AidaTestCase.assertEquals(h1.axis(), h2.axis());
        int bins = h1.axis().bins();
        int i = -2;
        while (i < bins) {
            AidaTestCase.assertEqualsDouble(h1.binMean(i), h2.binMean(i), 1.0E-10);
            AidaTestCase.assertEqualsDouble(h1.binHeight(i), h2.binHeight(i), 1.0E-10);
            AidaTestCase.assertEqualsDouble(h1.binError(i), h2.binError(i), 1.0E-10);
            Assert.assertEquals((int)h1.binEntries(i), (int)h2.binEntries(i));
            ++i;
        }
        AidaTestCase.assertEqualsDouble(h1.mean(), h2.mean(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.rms(), h2.rms(), 1.0E-10);
    }

    static void assertEquals(IHistogram2D h1, IHistogram2D h2) {
        AidaTestCase.assertEquals((IHistogram)h1, (IHistogram)h2);
        AidaTestCase.assertEquals(h1.xAxis(), h2.xAxis());
        AidaTestCase.assertEquals(h1.yAxis(), h2.yAxis());
        int xbins = h1.xAxis().bins();
        int ybins = h1.yAxis().bins();
        int i = -2;
        while (i < xbins) {
            Assert.assertEquals((int)h1.binEntriesX(i), (int)h2.binEntriesX(i));
            AidaTestCase.assertEqualsDouble(h1.binHeightX(i), h2.binHeightX(i), 1.0E-10);
            int j = -2;
            while (j < ybins) {
                if (i == 0) {
                    Assert.assertTrue((h1.binEntriesY(j) == h2.binEntriesY(j) ? 1 : 0) != 0);
                    AidaTestCase.assertEqualsDouble(h1.binHeightY(j), h2.binHeightY(j), 1.0E-10);
                }
                AidaTestCase.assertEqualsDouble(h1.binMeanX(i, j), h2.binMeanX(i, j), 1.0E-10);
                AidaTestCase.assertEqualsDouble(h1.binMeanY(i, j), h2.binMeanY(i, j), 1.0E-10);
                AidaTestCase.assertEqualsDouble(h1.binHeight(i, j), h2.binHeight(i, j), 1.0E-10);
                AidaTestCase.assertEqualsDouble(h1.binError(i, j), h2.binError(i, j), 1.0E-10);
                Assert.assertTrue((h1.binEntries(i, j) == h2.binEntries(i, j) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        AidaTestCase.assertEqualsDouble(h1.meanX(), h2.meanX(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.rmsX(), h2.rmsX(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.meanY(), h2.meanY(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.rmsY(), h2.rmsY(), 1.0E-10);
    }

    static void assertEquals(IHistogram3D h1, IHistogram3D h2) {
        AidaTestCase.assertEquals((IHistogram)h1, (IHistogram)h2);
        AidaTestCase.assertEquals(h1.xAxis(), h2.xAxis());
        AidaTestCase.assertEquals(h1.yAxis(), h2.yAxis());
        AidaTestCase.assertEquals(h1.zAxis(), h2.zAxis());
        AidaTestCase.assertEqualsDouble(h1.meanX(), h2.meanX(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.rmsX(), h2.rmsX(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.meanY(), h2.meanY(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.rmsY(), h2.rmsY(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.meanZ(), h2.meanZ(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(h1.rmsZ(), h2.rmsZ(), 1.0E-10);
        int xbins = h1.xAxis().bins();
        int ybins = h1.yAxis().bins();
        int zbins = h1.zAxis().bins();
        int i = -2;
        while (i < xbins) {
            Assert.assertTrue((h1.binEntriesX(i) == h2.binEntriesX(i) ? 1 : 0) != 0);
            AidaTestCase.assertEqualsDouble(h1.binHeightX(i), h2.binHeightX(i), 1.0E-10);
            int j = -2;
            while (j < ybins) {
                if (i == 0) {
                    Assert.assertTrue((h1.binEntriesY(j) == h2.binEntriesY(j) ? 1 : 0) != 0);
                    AidaTestCase.assertEqualsDouble(h1.binHeightY(j), h2.binHeightY(j), 1.0E-10);
                }
                int k = -2;
                while (k < zbins) {
                    if (i == 0 && j == 0) {
                        Assert.assertTrue((h1.binEntriesZ(k) == h2.binEntriesZ(k) ? 1 : 0) != 0);
                        AidaTestCase.assertEqualsDouble(h1.binHeightZ(k), h2.binHeightZ(k), 1.0E-10);
                    }
                    AidaTestCase.assertEqualsDouble(h1.binMeanX(i, j, k), h2.binMeanX(i, j, k), 1.0E-10);
                    AidaTestCase.assertEqualsDouble(h1.binMeanY(i, j, k), h2.binMeanY(i, j, k), 1.0E-10);
                    AidaTestCase.assertEqualsDouble(h1.binMeanZ(i, j, k), h2.binMeanZ(i, j, k), 1.0E-10);
                    AidaTestCase.assertEqualsDouble(h1.binHeight(i, j, k), h2.binHeight(i, j, k), 1.0E-10);
                    AidaTestCase.assertEqualsDouble(h1.binError(i, j, k), h2.binError(i, j, k), 1.0E-10);
                    AidaTestCase.assertEqualsDouble(h1.binEntries(i, j, k), h2.binEntries(i, j, k), 1.0E-10);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    static void assertEquals(IAxis a1, IAxis a2) {
        Assert.assertEquals((int)a1.bins(), (int)a2.bins());
        Assert.assertTrue((a1.lowerEdge() == a2.lowerEdge() ? 1 : 0) != 0);
        Assert.assertTrue((a1.upperEdge() == a2.upperEdge() ? 1 : 0) != 0);
        int bins = a1.bins();
        int i = 0;
        while (i < bins) {
            AidaTestCase.assertEqualsDouble(a1.binLowerEdge(i), a2.binLowerEdge(i), 1.0E-10);
            AidaTestCase.assertEqualsDouble(a1.binUpperEdge(i), a2.binUpperEdge(i), 1.0E-10);
            AidaTestCase.assertEqualsDouble(a1.binWidth(i), a2.binWidth(i), 1.0E-10);
            ++i;
        }
    }

    static void assertEquals(IAnnotation a1, IAnnotation a2) {
        if (a1 != null && a2 != null) {
            int size = a1.size();
            Assert.assertEquals((int)size, (int)a2.size());
            int i = 0;
            while (i < size) {
                String key = a1.key(i);
                Assert.assertEquals((String)key, (String)a2.key(i));
                Assert.assertEquals((String)a1.value(i), (String)a2.value(i));
                Assert.assertEquals((String)a1.value(key), (String)a2.value(key));
                ++i;
            }
        } else {
            Assert.assertTrue((boolean)false);
        }
    }

    static void assertEquals(ITuple t1, ITuple t2) {
        if (t1 instanceof IManagedObject && t2 instanceof IManagedObject) {
            AidaTestCase.assertEquals((IManagedObject)t1, (IManagedObject)t2);
        }
        Assert.assertEquals((String)t1.title(), (String)t2.title());
        Assert.assertEquals((int)t1.rows(), (int)t2.rows());
        Assert.assertEquals((int)t1.columns(), (int)t2.columns());
        int columns = t1.columns();
        int i = 0;
        while (i < columns) {
            Assert.assertEquals((String)t1.columnName(i), (String)t2.columnName(i));
            Assert.assertEquals((String)t1.columnType(i).getName(), (String)t2.columnType(i).getName());
            AidaTestCase.assertEqualsDouble(t1.columnMin(i), t2.columnMin(i), 1.0E-10);
            AidaTestCase.assertEqualsDouble(t1.columnMax(i), t2.columnMax(i), 1.0E-10);
            AidaTestCase.assertEqualsDouble(t1.columnMean(i), t2.columnMean(i), 1.0E-10);
            AidaTestCase.assertEqualsDouble(t1.columnRms(i), t2.columnRms(i), 1.0E-10);
            ++i;
        }
        t1.start();
        t2.start();
        int countRows = 0;
        while (t1.next() && t2.next()) {
            ++countRows;
            int i2 = 0;
            while (i2 < columns) {
                Class colType = t1.columnType(i2);
                if (colType == Integer.TYPE) {
                    Assert.assertTrue((t1.getInt(i2) == t2.getInt(i2) ? 1 : 0) != 0);
                } else if (colType == Short.TYPE) {
                    Assert.assertTrue((t1.getShort(i2) == t2.getShort(i2) ? 1 : 0) != 0);
                } else if (colType == Long.TYPE) {
                    Assert.assertTrue((t1.getLong(i2) == t2.getLong(i2) ? 1 : 0) != 0);
                } else if (colType == Float.TYPE) {
                    Assert.assertTrue((t1.getFloat(i2) == t2.getFloat(i2) ? 1 : 0) != 0);
                } else if (colType == Double.TYPE) {
                    Assert.assertTrue((t1.getDouble(i2) == t2.getDouble(i2) ? 1 : 0) != 0);
                } else if (colType == Boolean.TYPE) {
                    Assert.assertTrue((t1.getBoolean(i2) == t2.getBoolean(i2) ? 1 : 0) != 0);
                } else if (colType == Byte.TYPE) {
                    Assert.assertTrue((t1.getByte(i2) == t2.getByte(i2) ? 1 : 0) != 0);
                } else if (colType == Character.TYPE) {
                    Assert.assertTrue((t1.getChar(i2) == t2.getChar(i2) ? 1 : 0) != 0);
                } else if (colType == (class$java$lang$String == null ? AidaTestCase.class$("java.lang.String") : class$java$lang$String)) {
                    Assert.assertEquals((String)t1.getString(i2), (String)t2.getString(i2));
                } else if (colType == (class$hep$aida$ITuple == null ? AidaTestCase.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) {
                    AidaTestCase.assertEquals((ITuple)t1.getObject(i2), (ITuple)t2.getObject(i2));
                } else if (colType == (class$java$lang$Object == null ? AidaTestCase.class$("java.lang.Object") : class$java$lang$Object)) {
                    Assert.assertEquals((Object)t1.getObject(i2), (Object)t2.getObject(i2));
                }
                ++i2;
            }
        }
        Assert.assertEquals((int)countRows, (int)t1.rows());
    }

    static void assertEquals(ICloud c1, ICloud c2) {
        AidaTestCase.assertEquals((IBaseHistogram)c1, (IBaseHistogram)c2);
        AidaTestCase.assertEqualsDouble(c1.sumOfWeights(), c2.sumOfWeights(), 1.0E-10);
        Assert.assertEquals((boolean)c1.isConverted(), (boolean)c2.isConverted());
    }

    static void assertEquals(ICloud1D c1, ICloud1D c2) {
        AidaTestCase.assertEquals((ICloud)c1, (ICloud)c2);
        Assert.assertTrue((c1.lowerEdge() == c2.lowerEdge() ? 1 : 0) != 0);
        Assert.assertTrue((c1.upperEdge() == c2.upperEdge() ? 1 : 0) != 0);
        AidaTestCase.assertEqualsDouble(c1.mean(), c2.mean(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(c1.rms(), c2.rms(), 1.0E-10);
        IHistogram1D h1 = null;
        IHistogram1D h2 = null;
        try {
            h1 = c1.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            h2 = c2.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (h1 != null && h2 != null) {
            AidaTestCase.assertEquals(h1, h2);
        } else if (h1 == null && h2 == null) {
            int entries = c1.entries();
            int i = 0;
            while (i < entries) {
                Assert.assertTrue((c1.value(i) == c2.value(i) ? 1 : 0) != 0);
                Assert.assertTrue((c1.weight(i) == c2.weight(i) ? 1 : 0) != 0);
                ++i;
            }
        } else {
            Assert.assertTrue((boolean)false);
        }
    }

    static void assertEquals(ICloud2D c1, ICloud2D c2) {
        AidaTestCase.assertEquals((ICloud)c1, (ICloud)c2);
        Assert.assertTrue((c1.lowerEdgeX() == c2.lowerEdgeX() ? 1 : 0) != 0);
        Assert.assertTrue((c1.upperEdgeX() == c2.upperEdgeX() ? 1 : 0) != 0);
        Assert.assertTrue((c1.lowerEdgeY() == c2.lowerEdgeY() ? 1 : 0) != 0);
        Assert.assertTrue((c1.upperEdgeY() == c2.upperEdgeY() ? 1 : 0) != 0);
        AidaTestCase.assertEqualsDouble(c1.meanX(), c2.meanX(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(c1.rmsX(), c2.rmsX(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(c1.meanY(), c2.meanY(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(c1.rmsY(), c2.rmsY(), 1.0E-10);
        IHistogram2D h1 = null;
        IHistogram2D h2 = null;
        try {
            h1 = c1.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            h2 = c2.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (h1 != null && h2 != null) {
            AidaTestCase.assertEquals(h1, h2);
        } else if (h1 == null && h2 == null) {
            int entries = c1.entries();
            int i = 0;
            while (i < entries) {
                Assert.assertTrue((c1.valueX(i) == c2.valueX(i) ? 1 : 0) != 0);
                Assert.assertTrue((c1.valueY(i) == c2.valueY(i) ? 1 : 0) != 0);
                Assert.assertTrue((c1.weight(i) == c2.weight(i) ? 1 : 0) != 0);
                ++i;
            }
        } else {
            Assert.assertTrue((boolean)false);
        }
    }

    static void assertEquals(ICloud3D c1, ICloud3D c2) {
        AidaTestCase.assertEquals((ICloud)c1, (ICloud)c2);
        Assert.assertTrue((c1.lowerEdgeX() == c2.lowerEdgeX() ? 1 : 0) != 0);
        Assert.assertTrue((c1.upperEdgeX() == c2.upperEdgeX() ? 1 : 0) != 0);
        Assert.assertTrue((c1.lowerEdgeY() == c2.lowerEdgeY() ? 1 : 0) != 0);
        Assert.assertTrue((c1.upperEdgeY() == c2.upperEdgeY() ? 1 : 0) != 0);
        Assert.assertTrue((c1.lowerEdgeZ() == c2.lowerEdgeZ() ? 1 : 0) != 0);
        Assert.assertTrue((c1.upperEdgeZ() == c2.upperEdgeZ() ? 1 : 0) != 0);
        AidaTestCase.assertEqualsDouble(c1.meanX(), c2.meanX(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(c1.rmsX(), c2.rmsX(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(c1.meanY(), c2.meanY(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(c1.rmsY(), c2.rmsY(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(c1.meanZ(), c2.meanZ(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(c1.rmsZ(), c2.rmsZ(), 1.0E-10);
        IHistogram3D h1 = null;
        IHistogram3D h2 = null;
        try {
            h1 = c1.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        try {
            h2 = c2.histogram();
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        if (h1 != null && h2 != null) {
            AidaTestCase.assertEquals(h1, h2);
        } else if (h1 == null && h2 == null) {
            int entries = c1.entries();
            int i = 0;
            while (i < entries) {
                Assert.assertTrue((c1.valueX(i) == c2.valueX(i) ? 1 : 0) != 0);
                Assert.assertTrue((c1.valueY(i) == c2.valueY(i) ? 1 : 0) != 0);
                Assert.assertTrue((c1.valueZ(i) == c2.valueZ(i) ? 1 : 0) != 0);
                Assert.assertTrue((c1.weight(i) == c2.weight(i) ? 1 : 0) != 0);
                ++i;
            }
        } else {
            Assert.assertTrue((boolean)false);
        }
    }

    static void assertEquals(IProfile p1, IProfile p2) {
        AidaTestCase.assertEquals((IBaseHistogram)p1, (IBaseHistogram)p2);
        Assert.assertEquals((int)p1.allEntries(), (int)p2.allEntries());
        Assert.assertEquals((int)p1.extraEntries(), (int)p2.extraEntries());
        AidaTestCase.assertEqualsDouble(p1.sumBinHeights(), p2.sumBinHeights(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(p1.sumExtraBinHeights(), p2.sumExtraBinHeights(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(p1.sumAllBinHeights(), p2.sumAllBinHeights(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(p1.minBinHeight(), p2.minBinHeight(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(p1.maxBinHeight(), p2.maxBinHeight(), 1.0E-10);
    }

    static void assertEquals(IProfile1D p1, IProfile1D p2) {
        AidaTestCase.assertEquals((IProfile)p1, (IProfile)p2);
        AidaTestCase.assertEquals(p1.axis(), p2.axis());
        int bins = p1.axis().bins();
        int i = -2;
        while (i < bins) {
            AidaTestCase.assertEqualsDouble(p1.binMean(i), p2.binMean(i), 1.0E-10);
            AidaTestCase.assertEqualsDouble(p1.binHeight(i), p2.binHeight(i), 1.0E-10);
            AidaTestCase.assertEqualsDouble(p1.binError(i), p2.binError(i), 1.0E-10);
            AidaTestCase.assertEqualsDouble(p1.binRms(i), p2.binRms(i), 1.0E-10);
            Assert.assertEquals((int)p1.binEntries(i), (int)p2.binEntries(i));
            ++i;
        }
        AidaTestCase.assertEqualsDouble(p1.mean(), p2.mean(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(p1.rms(), p2.rms(), 1.0E-10);
    }

    static void assertEquals(IProfile2D p1, IProfile2D p2) {
        AidaTestCase.assertEquals((IProfile)p1, (IProfile)p2);
        AidaTestCase.assertEquals(p1.xAxis(), p2.xAxis());
        AidaTestCase.assertEquals(p1.yAxis(), p2.yAxis());
        int xbins = p1.xAxis().bins();
        int ybins = p1.yAxis().bins();
        int i = -2;
        while (i < xbins) {
            Assert.assertEquals((int)p1.binEntriesX(i), (int)p2.binEntriesX(i));
            AidaTestCase.assertEqualsDouble(p1.binHeightX(i), p2.binHeightX(i), 1.0E-10);
            int j = -2;
            while (j < ybins) {
                if (i == 0) {
                    Assert.assertTrue((p1.binEntriesY(j) == p2.binEntriesY(j) ? 1 : 0) != 0);
                    AidaTestCase.assertEqualsDouble(p1.binHeightY(j), p2.binHeightY(j), 1.0E-10);
                }
                AidaTestCase.assertEqualsDouble(p1.binMeanX(i, j), p2.binMeanX(i, j), 1.0E-10);
                AidaTestCase.assertEqualsDouble(p1.binMeanY(i, j), p2.binMeanY(i, j), 1.0E-10);
                AidaTestCase.assertEqualsDouble(p1.binHeight(i, j), p2.binHeight(i, j), 1.0E-10);
                AidaTestCase.assertEqualsDouble(p1.binError(i, j), p2.binError(i, j), 1.0E-10);
                AidaTestCase.assertEqualsDouble(p1.binRms(i, j), p2.binRms(i, j), 1.0E-10);
                Assert.assertTrue((p1.binEntries(i, j) == p2.binEntries(i, j) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        AidaTestCase.assertEqualsDouble(p1.meanX(), p2.meanX(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(p1.rmsX(), p2.rmsX(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(p1.meanY(), p2.meanY(), 1.0E-10);
        AidaTestCase.assertEqualsDouble(p1.rmsY(), p2.rmsY(), 1.0E-10);
    }

    static void assertEquals(IDataPointSet d1, IDataPointSet d2) {
        if (d1 instanceof IManagedObject && d2 instanceof IManagedObject) {
            AidaTestCase.assertEquals((IManagedObject)d1, (IManagedObject)d2);
        }
        AidaTestCase.assertEquals(d1.annotation(), d2.annotation());
        Assert.assertEquals((String)d1.title(), (String)d2.title());
        Assert.assertEquals((int)d1.dimension(), (int)d2.dimension());
        Assert.assertEquals((int)d1.size(), (int)d2.size());
        int i = 0;
        while (i < d1.size()) {
            AidaTestCase.assertEquals(d1.point(i), d2.point(i));
            int j = 0;
            while (j < d1.dimension()) {
                AidaTestCase.assertEqualsDouble(d1.lowerExtent(j), d2.lowerExtent(j), 0.0);
                AidaTestCase.assertEqualsDouble(d1.upperExtent(j), d2.upperExtent(j), 0.0);
                ++j;
            }
            ++i;
        }
    }

    static void assertEquals(IDataPoint p1, IDataPoint p2) {
        Assert.assertEquals((int)p1.dimension(), (int)p2.dimension());
        int i = 0;
        while (i < p1.dimension()) {
            AidaTestCase.assertEquals(p1.coordinate(i), p2.coordinate(i));
            ++i;
        }
    }

    static void assertEquals(IMeasurement m1, IMeasurement m2) {
        AidaTestCase.assertEqualsDouble(m1.value(), m2.value(), 0.0);
        AidaTestCase.assertEqualsDouble(m1.errorPlus(), m2.errorPlus(), 0.0);
        AidaTestCase.assertEqualsDouble(m1.errorMinus(), m2.errorMinus(), 0.0);
    }

    static void assertEqualsDouble(double v1, double v2, double relDelta) {
        if (v1 == v2) {
            return;
        }
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            return;
        }
        Assert.assertTrue((!(Double.isNaN(v1) && !Double.isNaN(v2) || !Double.isNaN(v1) && Double.isNaN(v2)) ? 1 : 0) != 0);
        double delta = 0.0;
        delta = v1 != 0.0 ? Math.abs(v1 * relDelta) : relDelta;
        Assert.assertEquals((String)("\nassertEqualsDouble: Allowed Delta <" + delta + "> Actual Delta <" + (v1 - v2) + "> \nassertEqualsDouble: "), (double)v1, (double)v2, (double)delta);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

