// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IFILTER_H
#define AIDA_IFILTER_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include <string>

namespace AIDA {

class ITuple;

/**
 * User's level interface of an IFilter.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

class IFilter {

public: 
    /// Destructor.
    virtual ~IFilter() { /* nop */; }

  /**
   * Initialize the IFilter and associate it to an ITuple.
   * @param tuple The ITuple to which the IFilter is sssociated.
   * @return false If the IFilter and 
   *              the ITuple are not compatible.
   *
   */ 
    virtual bool initialize(ITuple & tuple) = 0;

  /**
   * Check if the IFilter accepts or not the data in the 
   * current row of the ITuple it is associated to.
   * @return <code>true</code> if the current data is accepted.
   *
   */ 
    virtual bool accept() const = 0;

   /**
    * Get the expression that defined the IFilter.
    * @return The expression.
    *
    */
    virtual std::string expression() const = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IFILTER_H */
