// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * An IAxis represents a binned histogram axis. A 1D Histogram would have
 * one Axis representing the X axis, while a 2D Histogram would have two
 * axes representing the X and Y Axis.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

public interface IAxis {

  /**
   * Check if the IAxis has fixed binning, i.e. if all the bins have the same width.
   * @return <code>true</code> if the binning is fixed, <code>false</code> otherwise.
   *
   */
    public boolean isFixedBinning();

  /**
   * Get the lower edge of the IAxis.
   * @return The IAxis's lower edge.
   *
   */
    public double lowerEdge();

  /**
   * Get the upper edge of the IAxis.
   * @return The IAxis's upper edge.
   *
   */
    public double upperEdge();

  /** 
   * The number of bins (excluding underflow and overflow) on the IAxis.
   * @return The IAxis's number of bins.
   *
   */
    public int bins();

  /**
   * Get the lower edge of the specified bin.
   * @param index The bin number: 0 to bins()-1 for the in-range bins or OVERFLOW or UNDERFLOW.
   * @return      The lower edge of the corresponding bin; for the underflow bin this is <tt>Double.NEGATIVE_INFINITY</tt>.
   *
   */
    public double binLowerEdge(int index);

  /**
   * Get the upper edge of the specified bin.
   * @param index The bin number: 0 to bins()-1 for the in-range bins or OVERFLOW or UNDERFLOW.
   * @return      The upper edge of the corresponding bin; for the overflow bin this is <tt>Double.POSITIVE_INFINITY</tt>.
   *
   */ 
    public double binUpperEdge(int index);

  /**
   * Get the width of the specified bin.
   * @param index The bin number: 0 to bins()-1) for the in-range bins or OVERFLOW or UNDERFLOW.
   * @return      The width of the corresponding bin.
   *
   */ 
    public double binWidth(int index);

  /**
   * Convert a coordinate on the axis to a bin number.
   * If the coordinate is less than the lowerEdge UNDERFLOW is returned; if the coordinate is greater or
   * equal to the upperEdge OVERFLOW is returned.
   * @param coord The coordinate to be converted.
   * @return      The corresponding bin number.
   *
   */
    public int coordToIndex(double coord);

  /**
   * Constants specifying the underflow and the overflow bin.
   * They can be passed to any method accepting a bin number.
   *
   */
    public final static int UNDERFLOW_BIN = -2, OVERFLOW_BIN = -1;
} // class or interface

