// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * User level interface for factory classes of Histograms (binned, unbinned, and profile)
 * The created objects are assumed to be managed by the tree which is associated to the factory.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
public interface IHistogramFactory {

    /**
     * Destroy an IBaseHistogram ogject.
     * @param hist The IBaseHistogram to be destroyed.
     * @throws     IllegalArgumentException If the histogram cannot be destroyed.
     *
     */
    public void destroy(IBaseHistogram hist) throws IllegalArgumentException;

    /**
     * Create a ICloud1D, an unbinned 1-dimensional histogram.
     * @param path    The path of the created ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param title   The title of the ICloud1D.
     *                will convert to an IHistogram1D. The default nMax = -1 means no autoconversion.
     *                to an IHistogram1D.
     * @return        The newly created ICloud1D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud1D createCloud1D(String path, String title) throws IllegalArgumentException;
    /**
     * Create a ICloud1D, an unbinned 1-dimensional histogram.
     * @param path    The path of the created ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param title   The title of the ICloud1D.
     * @param nMax    The maximum number of entries after which the ICloud1D
     *                will convert to an IHistogram1D. The default nMax = -1 means no autoconversion.
     *                to an IHistogram1D.
     * @return        The newly created ICloud1D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud1D createCloud1D(String path, String title, int nMax) throws IllegalArgumentException;
    /**
     * Create a ICloud1D, an unbinned 1-dimensional histogram.
     * @param path    The path of the created ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param title   The title of the ICloud1D.
     * @param nMax    The maximum number of entries after which the ICloud1D
     *                will convert to an IHistogram1D. The default nMax = -1 means no autoconversion.
     * @param options The options for the ICloud1D. "autoconvert=true" to enable autoconversion
     *                to an IHistogram1D.
     * @return        The newly created ICloud1D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud1D createCloud1D(String path, String title, int nMax, String options) throws IllegalArgumentException;

    /**
     * Create a ICloud1D, an unbinned 1-dimensional histogram.
     * @param pathAndTitle The path of the created ICloud. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @return             The newly created ICloud1D.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud1D createCloud1D(String pathAndTitle) throws IllegalArgumentException;

    /**
     * Create a copy of an ICloud1D.
     * @param path    The path of the resulting ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param cloud   The ICloud1D to be copied.
     * @return        The copy of the ICloud1D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud1D createCopy(String path, ICloud1D cloud) throws IllegalArgumentException;

    /**
     * Create a ICloud2D, an unbinned 2-dimensional histogram.
     * @param path    The path of the created ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param title   The title of the ICloud2D.
     *                will convert to an IHistogram2D. The default nMax = -1 means no autoconversion. 
     *                to an IHistogram2D.
     * @return        The newly created ICloud2D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud2D createCloud2D(String path, String title) throws IllegalArgumentException;
    /**
     * Create a ICloud2D, an unbinned 2-dimensional histogram.
     * @param path    The path of the created ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param title   The title of the ICloud2D.
     * @param nMax    The maximum number of entries after which the ICloud2D
     *                will convert to an IHistogram2D. The default nMax = -1 means no autoconversion. 
     *                to an IHistogram2D.
     * @return        The newly created ICloud2D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud2D createCloud2D(String path, String title, int nMax) throws IllegalArgumentException;
    /**
     * Create a ICloud2D, an unbinned 2-dimensional histogram.
     * @param path    The path of the created ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param title   The title of the ICloud2D.
     * @param nMax    The maximum number of entries after which the ICloud2D
     *                will convert to an IHistogram2D. The default nMax = -1 means no autoconversion. 
     * @param options The options for the ICloud2D. "autoconvert=true" to enable autoconversion
     *                to an IHistogram2D.
     * @return        The newly created ICloud2D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud2D createCloud2D(String path, String title, int nMax, String options) throws IllegalArgumentException;

    /**
     * Create a ICloud2D, an unbinned 2-dimensional histogram.
     * @param pathAndTitle The path of the created created ICloud. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @return             The newly created ICloud2D.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud2D createCloud2D(String pathAndTitle) throws IllegalArgumentException;

    /**
     * Create a copy of an ICloud2D.
     * @param path    The path of the resulting ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param cloud   The ICloud2D to be copied.
     * @return        The copy of the ICloud2D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud2D createCopy(String path, ICloud2D cloud) throws IllegalArgumentException;

    /**
     * Create a ICloud3D, an unbinned 3-dimensional histogram.
     * @param path    The path of the created ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param title   The title of the ICloud3D.
     *                will convert to an IHistogram3D. The default nMax = -1 means no autoconversion 
     *                to an IHistogram3D.
     * @return        The newly created ICloud3D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud3D createCloud3D(String path, String title) throws IllegalArgumentException;
    /**
     * Create a ICloud3D, an unbinned 3-dimensional histogram.
     * @param path    The path of the created ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param title   The title of the ICloud3D.
     * @param nMax    The maximum number of entries after which the ICloud3D
     *                will convert to an IHistogram3D. The default nMax = -1 means no autoconversion 
     *                to an IHistogram3D.
     * @return        The newly created ICloud3D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud3D createCloud3D(String path, String title, int nMax) throws IllegalArgumentException;
    /**
     * Create a ICloud3D, an unbinned 3-dimensional histogram.
     * @param path    The path of the created ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param title   The title of the ICloud3D.
     * @param nMax    The maximum number of entries after which the ICloud3D
     *                will convert to an IHistogram3D. The default nMax = -1 means no autoconversion 
     * @param options The options for the ICloud3D. "autoconvert=true" to enable autoconversion
     *                to an IHistogram3D.
     * @return        The newly created ICloud3D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud3D createCloud3D(String path, String title, int nMax, String options) throws IllegalArgumentException;

    /**
     * Create a ICloud3D, an unbinned 3-dimensional histogram.
     * @param pathAndTitle The path of the created created ICloud. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @return             The newly created ICloud3D.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud3D createCloud3D(String pathAndTitle) throws IllegalArgumentException;

    /**
     * Create a copy of an ICloud3D.
     * @param path    The path of the resulting ICloud. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param cloud   The ICloud3D to be copied.
     * @return        The copy of the ICloud3D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public ICloud3D createCopy(String path, ICloud3D cloud) throws IllegalArgumentException;

    /**
     * Create a IHistogram1D.
     * @param path      The path of the created IHistogram. The path can either be a relative or full path.
     *                  ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                  All the directories in the path must exist. The characther `/` cannot be used
     *                  in names; it is only used to delimit directories within paths.
     * @param title     The title of the IHistogram1D.
     * @param nBins     The number of bins of the x axis.
     * @param lowerEdge The lower edge of the x axis.
     * @param upperEdge The upper edge of the x axis.
     *                  "type=efficiency" for an efficiency IHistogram1D.
     * @return          The newly created IHistogram1D.
     * @throws          IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D createHistogram1D(String path, String title, int nBins, double lowerEdge, double upperEdge) throws IllegalArgumentException;
    /**
     * Create a IHistogram1D.
     * @param path      The path of the created IHistogram. The path can either be a relative or full path.
     *                  ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                  All the directories in the path must exist. The characther `/` cannot be used
     *                  in names; it is only used to delimit directories within paths.
     * @param title     The title of the IHistogram1D.
     * @param nBins     The number of bins of the x axis.
     * @param lowerEdge The lower edge of the x axis.
     * @param upperEdge The upper edge of the x axis.
     * @param options   The options for the IHistogram1D. The default is "".
     *                  "type=efficiency" for an efficiency IHistogram1D.
     * @return          The newly created IHistogram1D.
     * @throws          IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D createHistogram1D(String path, String title, int nBins, double lowerEdge, double upperEdge, String options) throws IllegalArgumentException;

    /**
     * Create a IHistogram1D.
     * @param pathAndTitle The path of the created created IHistogram. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param nBins        The number of bins of the x axis.
     * @param lowerEdge    The lower edge of the x axis.
     * @param upperEdge    The upper edge of the x axis.
     * @return             The newly created IHistogram1D.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D createHistogram1D(String pathAndTitle, int nBins, double lowerEdge, double upperEdge) throws IllegalArgumentException;

    /**
     * Create a IHistogram1D.
     * @param path      The path of the created IHistogram. The path can either be a relative or full path.
     *                  ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                  All the directories in the path must exist. The characther `/` cannot be used
     *                  in names; it is only used to delimit directories within paths.
     * @param title     The title of the IHistogram1D.
     * @param binEdges  The array of the bin edges for the x axis.
     *                  "type=efficiency" for an efficiency IHistogram1D.
     * @return          The newly created IHistogram1D.
     * @throws          IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D createHistogram1D(String path, String title, double[] binEdges) throws IllegalArgumentException;
    /**
     * Create a IHistogram1D.
     * @param path      The path of the created IHistogram. The path can either be a relative or full path.
     *                  ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                  All the directories in the path must exist. The characther `/` cannot be used
     *                  in names; it is only used to delimit directories within paths.
     * @param title     The title of the IHistogram1D.
     * @param binEdges  The array of the bin edges for the x axis.
     * @param options   The options for the IHistogram1D. The default is "".
     *                  "type=efficiency" for an efficiency IHistogram1D.
     * @return          The newly created IHistogram1D.
     * @throws          IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D createHistogram1D(String path, String title, double[] binEdges, String options) throws IllegalArgumentException;

    /**
     * Create a copy of an IHistogram1D.
     * @param path The path of the resulting IHistogram. The path can either be a relative or full path.
     *             ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *             All the directories in the path must exist. The characther `/` cannot be used
     *             in names; it is only used to delimit directories within paths.
     * @param hist The IHistogram1D to be copied.
     * @return     The copy of the IHistogram1D.
     * @throws     IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D createCopy(String path, IHistogram1D hist) throws IllegalArgumentException;

    /**
     * Create a IHistogram2D.
     * @param path       The path of the created IHistogram. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IHistogram2D.
     * @param nBinsX     The number of bins of the x axis.
     * @param lowerEdgeX The lower edge of the x axis.
     * @param upperEdgeX The upper edge of the x axis.
     * @param nBinsY     The number of bins of the y axis.
     * @param lowerEdgeY The lower edge of the y axis.
     * @param upperEdgeY The upper edge of the y axis.
     *                   "type=efficiency" for an efficiency IHistogram2D.
     * @return           The newly created IHistogram2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D createHistogram2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY);
    /**
     * Create a IHistogram2D.
     * @param path       The path of the created IHistogram. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IHistogram2D.
     * @param nBinsX     The number of bins of the x axis.
     * @param lowerEdgeX The lower edge of the x axis.
     * @param upperEdgeX The upper edge of the x axis.
     * @param nBinsY     The number of bins of the y axis.
     * @param lowerEdgeY The lower edge of the y axis.
     * @param upperEdgeY The upper edge of the y axis.
     * @param options    The options for the IHistogram2D. The default is "".
     *                   "type=efficiency" for an efficiency IHistogram2D.
     * @return           The newly created IHistogram2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D createHistogram2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, String options);

    /**
     * Create a IHistogram2D.
     * @param pathAndTitle The path of the created created IHistogram. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param nBinsX       The number of bins of the x axis.
     * @param lowerEdgeX   The lower edge of the x axis.
     * @param upperEdgeX   The upper edge of the x axis.
     * @param nBinsY       The number of bins of the y axis.
     * @param lowerEdgeY   The lower edge of the y axis.
     * @param upperEdgeY   The upper edge of the y axis.
     * @return             The newly created IHistogram2D.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D createHistogram2D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) throws IllegalArgumentException;

    /**
     * Create a IHistogram2D.
     * @param path       The path of the created IHistogram. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IHistogram2D.
     * @param binEdgesX  The array of the bin edges for the x axis.
     * @param binEdgesY  The array of the bin edges for the y axis.
     *                   "type=efficiency" for an efficiency IHistogram2D.
     * @return           The newly created IHistogram2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D createHistogram2D(String path, String title, double[] binEdgesX, double[] binEdgesY) throws IllegalArgumentException;
    /**
     * Create a IHistogram2D.
     * @param path       The path of the created IHistogram. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IHistogram2D.
     * @param binEdgesX  The array of the bin edges for the x axis.
     * @param binEdgesY  The array of the bin edges for the y axis.
     * @param options    The options for the IHistogram2D. The default is "".
     *                   "type=efficiency" for an efficiency IHistogram2D.
     * @return           The newly created IHistogram2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D createHistogram2D(String path, String title, double[] binEdgesX, double[] binEdgesY, String options) throws IllegalArgumentException;

    /**
     * Create a copy of an IHistogram2D.
     * @param path The path of the resulting IHistogram. The path can either be a relative or full path.
     *             ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *             All the directories in the path must exist. The characther `/` cannot be used
     *             in names; it is only used to delimit directories within paths.
     * @param hist The IHistogram2D to be copied.
     * @return     The copy of the IHistogram2D.
     * @throws     IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D createCopy(String copy, IHistogram2D hist) throws IllegalArgumentException;

    /**
     * Create a IHistogram3D.
     * @param path       The path of the created IHistogram. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IHistogram3D.
     * @param nBinsX     The number of bins of the x axis.
     * @param lowerEdgeX The lower edge of the x axis.
     * @param upperEdgeX The upper edge of the x axis.
     * @param nBinsY     The number of bins of the y axis.
     * @param lowerEdgeY The lower edge of the y axis.
     * @param upperEdgeY The upper edge of the y axis.
     * @param nBinsZ     The number of bins of the z axis.
     * @param lowerEdgeZ The lower edge of the z axis.
     * @param upperEdgeZ The upper edge of the z axis.
     *                   "type=efficiency" for an efficiency IHistogram3D.
     * @return           The newly created IHistogram3D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram3D createHistogram3D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ) throws IllegalArgumentException;
    /**
     * Create a IHistogram3D.
     * @param path       The path of the created IHistogram. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IHistogram3D.
     * @param nBinsX     The number of bins of the x axis.
     * @param lowerEdgeX The lower edge of the x axis.
     * @param upperEdgeX The upper edge of the x axis.
     * @param nBinsY     The number of bins of the y axis.
     * @param lowerEdgeY The lower edge of the y axis.
     * @param upperEdgeY The upper edge of the y axis.
     * @param nBinsZ     The number of bins of the z axis.
     * @param lowerEdgeZ The lower edge of the z axis.
     * @param upperEdgeZ The upper edge of the z axis.
     * @param options    The options for the IHistogram3D. The default is "".
     *                   "type=efficiency" for an efficiency IHistogram3D.
     * @return           The newly created IHistogram3D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram3D createHistogram3D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ, String options) throws IllegalArgumentException;

    /**
     * Create a IHistogram3D.
     * @param pathAndTitle The path of the created created IHistogram. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param nBinsX       The number of bins of the x axis.
     * @param lowerEdgeX   The lower edge of the x axis.
     * @param upperEdgeX   The upper edge of the x axis.
     * @param nBinsY       The number of bins of the y axis.
     * @param lowerEdgeY   The lower edge of the y axis.
     * @param upperEdgeY   The upper edge of the y axis.
     * @param nBinsZ       The number of bins of the z axis.
     * @param lowerEdgeZ   The lower edge of the z axis.
     * @param upperEdgeZ   The upper edge of the z axis.
     * @return             The newly created IHistogram3D.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram3D createHistogram3D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ) throws IllegalArgumentException;

    /**
     * Create a IHistogram3D.
     * @param path       The path of the created IHistogram. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IHistogram3D.
     * @param binEdgesX  The array of the bin edges for the x axis.
     * @param binEdgesY  The array of the bin edges for the y axis.
     * @param binEdgesZ  The array of the bin edges for the z axis.
     *                   "type=efficiency" for an efficiency IHistogram3D.
     * @return           The newly created IHistogram3D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram3D createHistogram3D(String path, String title, double[] binEdgesX, double[] binEdgesY, double[] binEdgesZ) throws IllegalArgumentException;
    /**
     * Create a IHistogram3D.
     * @param path       The path of the created IHistogram. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IHistogram3D.
     * @param binEdgesX  The array of the bin edges for the x axis.
     * @param binEdgesY  The array of the bin edges for the y axis.
     * @param binEdgesZ  The array of the bin edges for the z axis.
     * @param options    The options for the IHistogram3D. The default is "".
     *                   "type=efficiency" for an efficiency IHistogram3D.
     * @return           The newly created IHistogram3D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram3D createHistogram3D(String path, String title, double[] binEdgesX, double[] binEdgesY, double[] binEdgesZ, String options) throws IllegalArgumentException;

    /**
     * Create a copy of an IHistogram3D.
     * @param path The path of the resulting IHistogram. The path can either be a relative or full path.
     *             ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *             All the directories in the path must exist. The characther `/` cannot be used
     *             in names; it is only used to delimit directories within paths.
     * @param hist The IHistogram3D to be copied.
     * @return     The copy of the IHistogram3D.
     * @throws     IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram3D createCopy(String path, IHistogram3D hist) throws IllegalArgumentException;

    /**
     * Create a IProfile1D.
     * @param path      The path of the created IProfile. The path can either be a relative or full path.
     *                  ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                  All the directories in the path must exist. The characther `/` cannot be used
     *                  in names; it is only used to delimit directories within paths.
     * @param title     The title of the IProfile1D.
     * @param nBins     The number of bins of the x axis.
     * @param lowerEdge The lower edge of the x axis.
     * @param upperEdge The upper edge of the x axis.
     * @return          The newly created IProfile1D.
     * @throws          IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge) throws IllegalArgumentException;
    /**
     * Create a IProfile1D.
     * @param path      The path of the created IProfile. The path can either be a relative or full path.
     *                  ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                  All the directories in the path must exist. The characther `/` cannot be used
     *                  in names; it is only used to delimit directories within paths.
     * @param title     The title of the IProfile1D.
     * @param nBins     The number of bins of the x axis.
     * @param lowerEdge The lower edge of the x axis.
     * @param upperEdge The upper edge of the x axis.
     * @param options   The options for the IProfile1D. The default is "".
     * @return          The newly created IProfile1D.
     * @throws          IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge, String options) throws IllegalArgumentException;

    /**
     * Create a IProfile1D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile1D.
     * @param nBins      The number of bins of the x axis.
     * @param lowerEdge  The lower edge of the x axis.
     * @param upperEdge  The upper edge of the x axis.
     * @param lowerValue The lower value displayed along the y axis.
     * @param upperValue The upper value displayed along the y axis.
     * @return           The newly created IProfile1D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge, double lowerValue, double upperValue) throws IllegalArgumentException;
    /**
     * Create a IProfile1D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile1D.
     * @param nBins      The number of bins of the x axis.
     * @param lowerEdge  The lower edge of the x axis.
     * @param upperEdge  The upper edge of the x axis.
     * @param lowerValue The lower value displayed along the y axis.
     * @param upperValue The upper value displayed along the y axis.
     * @param options    The options for the IProfile1D. The default is "".
     * @return           The newly created IProfile1D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge, double lowerValue, double upperValue, String options) throws IllegalArgumentException;

    /**
     * Create a IProfile1D.
     * @param path      The path of the created IProfile. The path can either be a relative or full path.
     *                  ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                  All the directories in the path must exist. The characther `/` cannot be used
     *                  in names; it is only used to delimit directories within paths.
     * @param title     The title of the IProfile1D.
     * @param binEdges  The array of the bin edges for the x axis.
     * @return          The newly created IProfile1D.
     * @throws          IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile1D createProfile1D(String path, String title, double[] binEdges) throws IllegalArgumentException;
    /**
     * Create a IProfile1D.
     * @param path      The path of the created IProfile. The path can either be a relative or full path.
     *                  ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                  All the directories in the path must exist. The characther `/` cannot be used
     *                  in names; it is only used to delimit directories within paths.
     * @param title     The title of the IProfile1D.
     * @param binEdges  The array of the bin edges for the x axis.
     * @param options   The options for the IProfile1D. The default is "".
     * @return          The newly created IProfile1D.
     * @throws          IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile1D createProfile1D(String path, String title, double[] binEdges, String options) throws IllegalArgumentException;

    /**
     * Create a IProfile1D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile1D.
     * @param binEdges   The array of the bin edges for the x axis.
     * @param lowerValue The lower value displayed along the y axis.
     * @param upperValue The upper value displayed along the y axis.
     * @return           The newly created IProfile1D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile1D createProfile1D(String path, String title, double[] binEdges, double lowerValue, double upperValue) throws IllegalArgumentException;
    /**
     * Create a IProfile1D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile1D.
     * @param binEdges   The array of the bin edges for the x axis.
     * @param lowerValue The lower value displayed along the y axis.
     * @param upperValue The upper value displayed along the y axis.
     * @param options    The options for the IProfile1D. The default is "".
     * @return           The newly created IProfile1D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile1D createProfile1D(String path, String title, double[] binEdges, double lowerValue, double upperValue, String options) throws IllegalArgumentException;

    /**
     * Create a IProfile1D.
     * @param pathAndTitle The path of the created created IProfile. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param nBins        The number of bins of the x axis.
     * @param lowerEdge    The lower edge of the x axis.
     * @param upperEdge    The upper edge of the x axis.
     * @return             The newly created IProfile1D.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile1D createProfile1D(String pathAndTitle, int nBins, double lowerEdge, double upperEdge) throws IllegalArgumentException;

    /**
     * Create a IProfile1D.
     * @param pathAndTitle The path of the created created IProfile. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param nBins        The number of bins of the x axis.
     * @param lowerEdge    The lower edge of the x axis.
     * @param upperEdge    The upper edge of the x axis.
     * @param lowerValue   The lower value displayed along the y axis.
     * @param upperValue   The upper value displayed along the y axis.
     * @return             The newly created IProfile1D.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile1D createProfile1D(String pathAndTitle, int nBins, double lowerEdge, double upperEdge, double lowerValue, double upperValue) throws IllegalArgumentException;

    /**
     * Create a copy of an IProfile1D.
     * @param path    The path of the resulting IProfile. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param profile The IProfile1D to be copied.
     * @return        The copy of the IProfile1D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile1D createCopy(String path, IProfile1D profile) throws IllegalArgumentException;

    /**
     * Create a IProfile2D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile2D.
     * @param nBinsX     The number of bins of the x axis.
     * @param lowerEdgeX The lower edge of the x axis.
     * @param upperEdgeX The upper edge of the x axis.
     * @param nBinsY     The number of bins of the y axis.
     * @param lowerEdgeY The lower edge of the y axis.
     * @param upperEdgeY The upper edge of the y axis.
     * @return           The newly created IProfile2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) throws IllegalArgumentException;
    /**
     * Create a IProfile2D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile2D.
     * @param nBinsX     The number of bins of the x axis.
     * @param lowerEdgeX The lower edge of the x axis.
     * @param upperEdgeX The upper edge of the x axis.
     * @param nBinsY     The number of bins of the y axis.
     * @param lowerEdgeY The lower edge of the y axis.
     * @param upperEdgeY The upper edge of the y axis.
     * @param options    The options for the IProfile2D. The default is "".
     * @return           The newly created IProfile2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, String options) throws IllegalArgumentException;

    /**
     * Create a IProfile2D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile2D.
     * @param nBinsX     The number of bins of the x axis.
     * @param lowerEdgeX The lower edge of the x axis.
     * @param upperEdgeX The upper edge of the x axis.
     * @param nBinsY     The number of bins of the y axis.
     * @param lowerEdgeY The lower edge of the y axis.
     * @param upperEdgeY The upper edge of the y axis.
     * @param lowerValue The lower value displayed along the z axis.
     * @param upperValue The upper value displayed along the z axis.
     * @return           The newly created IProfile2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, double lowerValue, double upperValue) throws IllegalArgumentException;
    /**
     * Create a IProfile2D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile2D.
     * @param nBinsX     The number of bins of the x axis.
     * @param lowerEdgeX The lower edge of the x axis.
     * @param upperEdgeX The upper edge of the x axis.
     * @param nBinsY     The number of bins of the y axis.
     * @param lowerEdgeY The lower edge of the y axis.
     * @param upperEdgeY The upper edge of the y axis.
     * @param lowerValue The lower value displayed along the z axis.
     * @param upperValue The upper value displayed along the z axis.
     * @param options    The options for the IProfile2D. The default is "".
     * @return           The newly created IProfile2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, double lowerValue, double upperValue, String options) throws IllegalArgumentException;

    /**
     * Create a IProfile2D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile2D.
     * @param binEdgesX  The array of the bin edges for the x axis.
     * @param binEdgesY  The array of the bin edges for the y axis.
     * @return           The newly created IProfile2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY) throws IllegalArgumentException;
    /**
     * Create a IProfile2D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile2D.
     * @param binEdgesX  The array of the bin edges for the x axis.
     * @param binEdgesY  The array of the bin edges for the y axis.
     * @param options    The options for the IProfile2D. The default is "".
     * @return           The newly created IProfile2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY, String options) throws IllegalArgumentException;

    /**
     * Create a IProfile2D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile2D.
     * @param binEdgesX  The array of the bin edges for the x axis.
     * @param binEdgesY  The array of the bin edges for the y axis.
     * @param lowerValue The lower value displayed along the y axis.
     * @param upperValue The upper value displayed along the y axis.
     * @return           The newly created IProfile2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY, double lowerValue, double upperValue) throws IllegalArgumentException;
    /**
     * Create a IProfile2D.
     * @param path       The path of the created IProfile. The path can either be a relative or full path.
     *                   ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                   All the directories in the path must exist. The characther `/` cannot be used
     *                   in names; it is only used to delimit directories within paths.
     * @param title      The title of the IProfile2D.
     * @param binEdgesX  The array of the bin edges for the x axis.
     * @param binEdgesY  The array of the bin edges for the y axis.
     * @param lowerValue The lower value displayed along the y axis.
     * @param upperValue The upper value displayed along the y axis.
     * @param options    The options for the IProfile2D. The default is "".
     * @return           The newly created IProfile2D.
     * @throws           IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY, double lowerValue, double upperValue, String options) throws IllegalArgumentException;

    /**
     * Create a IProfile2D.
     * @param pathAndTitle The path of the created created IProfile. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param nBinsX       The number of bins of the x axis.
     * @param lowerEdgeX   The lower edge of the x axis.
     * @param upperEdgeX   The upper edge of the x axis.
     * @param nBinsY       The number of bins of the y axis.
     * @param lowerEdgeY   The lower edge of the y axis.
     * @param upperEdgeY   The upper edge of the y axis.
     * @return             The newly created IProfile2D.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile2D createProfile2D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) throws IllegalArgumentException;

    /**
     * Create a IProfile2D.
     * @param pathAndTitle The path of the created created IProfile. The path can either be a relative or full path.
     *                     The last part of the path is used as the title.
     *                     ("/folder1/folder2/dataTitle" and "../folder/dataTitle" are valid paths).
     *                     All the directories in the path must exist. The characther `/` cannot be used
     *                     in names; it is only used to delimit directories within paths.
     * @param nBinsX       The number of bins of the x axis.
     * @param lowerEdgeX   The lower edge of the x axis.
     * @param upperEdgeX   The upper edge of the x axis.
     * @param nBinsY       The number of bins of the y axis.
     * @param lowerEdgeY   The lower edge of the y axis.
     * @param upperEdgeY   The upper edge of the y axis.
     * @param lowerValue   The lower value displayed along the z axis.
     * @param upperValue   The upper value displayed along the z axis.
     * @return             The newly created IProfile2D.
     * @throws             IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile2D createProfile2D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, double lowerValue, double upperValue) throws IllegalArgumentException;

    /**
     * Create a copy of an IProfile2D.
     * @param path    The path of the resulting IProfile. The path can either be a relative or full path.
     *                ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *                All the directories in the path must exist. The characther `/` cannot be used
     *                in names; it is only used to delimit directories within paths.
     * @param profile The IProfile2D to be copied.
     * @return        The copy of the IProfile2D.
     * @throws        IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IProfile2D createCopy(String path, IProfile2D profile) throws IllegalArgumentException;

    /**
     * Create an IHistogram1D by adding two IHistogram1D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the addition.
     * @param hist2 The second member of the addition.
     * @return      The sum of the two IHistogram1D.
     * @throws      IllegalArgumentException if the two IHistogram1D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D add(String path, IHistogram1D hist1, IHistogram1D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram1D by subtracting two IHistogram1D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the subtraction.
     * @param hist2 The second member of the subtraction.
     * @return      The difference of the two IHistogram1D.
     * @throws      IllegalArgumentException if the two IHistogram1D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D subtract(String path, IHistogram1D hist1, IHistogram1D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram1D by multiplying two IHistogram1D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the multiplication.
     * @param hist2 The second member of the multiplication.
     * @return      The product of the two IHistogram1D.
     * @throws      IllegalArgumentException if the two IHistogram1D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D multiply(String path, IHistogram1D hist1, IHistogram1D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram1D by dividing two IHistogram1D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the division.
     * @param hist2 The second member of the division.
     * @return      The ration of the two IHistogram1D.
     * @throws      IllegalArgumentException if the two IHistogram1D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D divide(String path, IHistogram1D hist1, IHistogram1D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram2D by adding two IHistogram2D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the addition.
     * @param hist2 The second member of the addition.
     * @return      The sum of the two IHistogram2D.
     * @throws      IllegalArgumentException if the two IHistogram2D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D add(String path, IHistogram2D hist1, IHistogram2D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram2D by subtracting two IHistogram2D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the subtraction.
     * @param hist2 The second member of the subtraction.
     * @return      The difference of the two IHistogram2D.
     * @throws      IllegalArgumentException if the two IHistogram2D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D subtract(String path, IHistogram2D hist1, IHistogram2D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram2D by multiplying two IHistogram2D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the multiplication.
     * @param hist2 The second member of the multiplication.
     * @return      The product of the two IHistogram2D.
     * @throws      IllegalArgumentException if the two IHistogram2D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D multiply(String path, IHistogram2D hist1, IHistogram2D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram2D by dividing two IHistogram2D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the division.
     * @param hist2 The second member of the division.
     * @return      The ration of the two IHistogram2D.
     * @throws      IllegalArgumentException if the two IHistogram2D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D divide(String path, IHistogram2D hist1, IHistogram2D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram3D by adding two IHistogram3D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the addition.
     * @param hist2 The second member of the addition.
     * @return      The sum of the two IHistogram3D.
     * @throws      IllegalArgumentException if the two IHistogram3D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram3D add(String path, IHistogram3D hist1, IHistogram3D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram3D by subtracting two IHistogram3D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the subtraction.
     * @param hist2 The second member of the subtraction.
     * @return      The difference of the two IHistogram3D.
     * @throws      IllegalArgumentException if the two IHistogram3D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram3D subtract(String path, IHistogram3D hist1, IHistogram3D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram3D by multiplying two IHistogram3D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the multiplication.
     * @param hist2 The second member of the multiplication.
     * @return      The product of the two IHistogram3D.
     * @throws      IllegalArgumentException if the two IHistogram3D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram3D multiply(String path, IHistogram3D hist1, IHistogram3D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram3D by dividing two IHistogram3D.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist1 The first member of the division.
     * @param hist2 The second member of the division.
     * @return      The ration of the two IHistogram3D.
     * @throws      IllegalArgumentException if the two IHistogram3D have incompatible binning, or
     *              if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram3D divide(String path, IHistogram3D hist1, IHistogram3D hist2) throws IllegalArgumentException;

    /**
     * Create an IHistogram1D by projecting an IHistogram2D along its x axis.
     * This is equivalent to <tt>sliceX(UNDERFLOW_BIN,OVERFLOW_BIN)</tt>.
     * @param path The path of the resulting IHistogram. The path can either be a relative or full path.
     *             ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *             All the directories in the path must exist. The characther `/` cannot be used
     *             in names; it is only used to delimit directories within paths.
     * @param hist The IHistogram2D to be projected.
     * @return     The resulting projection.
     * @throws     IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D projectionX(String path, IHistogram2D hist) throws IllegalArgumentException;

    /**
     * Create an IHistogram1D by projecting an IHistogram2D along its y axis.
     * This is equivalent to <tt>sliceY(UNDERFLOW_BIN,OVERFLOW_BIN)</tt>.
     * @param path The path of the resulting IHistogram. The path can either be a relative or full path.
     *             ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *             All the directories in the path must exist. The characther `/` cannot be used
     *             in names; it is only used to delimit directories within paths.
     * @param hist The IHistogram2D to be projected.
     * @return     The resulting projection.
     * @throws     IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D projectionY(String path, IHistogram2D hist) throws IllegalArgumentException;

    /**
     * Create an IHistogram1D by slicing an IHistogram2D parallel to the y axis at a given bin.
     * This is equivalent to <tt>sliceX(indexY,indexY)</tt>.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist  The IHistogram2D to be sliced.
     * @param index The index of the bin along the y axis where the IHistogram2D has to be sliced.
     * @return      The resulting slice.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D sliceX(String path, IHistogram2D hist, int index) throws IllegalArgumentException;

    /**
     * Create an IHistogram1D by slicing an IHistogram2D parallel to the x axis at a given bin.
     * This is equivalent to <tt>sliceY(indexX,indexX)</tt>.
     * @param path  The path of the resulting IHistogram. The path can either be a relative or full path.
     *              ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *              All the directories in the path must exist. The characther `/` cannot be used
     *              in names; it is only used to delimit directories within paths.
     * @param hist  The IHistogram2D to be sliced.
     * @param index The index of the bin along the x axis where the IHistogram2D has to be sliced.
     * @return      The resulting slice.
     * @throws      IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D sliceY(String path, IHistogram2D hist, int index) throws IllegalArgumentException;

    /**
     * Create an IHistogram1D by slicing an IHistogram2D parallel to the y axis between two bins (inclusive).
     * @param path   The path of the resulting IHistogram. The path can either be a relative or full path.
     *               ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *               All the directories in the path must exist. The characther `/` cannot be used
     *               in names; it is only used to delimit directories within paths.
     * @param hist   The IHistogram2D to be sliced.
     * @param index1 The index of the bin along the y axis that marks the lower edge of the slice.
     * @param index2 The index of the bin along the y axis that marks the upper edge of the slice.
     * @return       The resulting slice.
     * @throws       IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D sliceX(String path, IHistogram2D hist, int index1, int index2) throws IllegalArgumentException;

    /**
     * Create an IHistogram1D by slicing an IHistogram2D parallel to the x axis between two bins (inclusive).
     * @param path   The path of the resulting IHistogram. The path can either be a relative or full path.
     *               ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *               All the directories in the path must exist. The characther `/` cannot be used
     *               in names; it is only used to delimit directories within paths.
     * @param hist   The IHistogram2D to be sliced.
     * @param index1 The index of the bin along the x axis that marks the lower edge of the slice.
     * @param index2 The index of the bin along the x axis that marks the upper edge of the slice.
     * @return       The resulting slice.
     * @throws       IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram1D sliceY(String path, IHistogram2D hist, int index1, int index2) throws IllegalArgumentException;

    /**
     * Create an IHistogram2D by projecting an IHistogram3D on the x-y plane.
     * This is equivalent to <tt>sliceXY(UNDERFLOW_BIN,OVERFLOW_BIN)</tt>.
     * @param path The path of the resulting IHistogram. The path can either be a relative or full path.
     *             ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *             All the directories in the path must exist. The characther `/` cannot be used
     *             in names; it is only used to delimit directories within paths.
     * @param hist The IHistogram3D to be projected.
     * @return     The resulting projection.
     * @throws     IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D projectionXY(String path, IHistogram3D hist) throws IllegalArgumentException;

    /**
     * Create an IHistogram2D by projecting an IHistogram3D on the x-z plane.
     * This is equivalent to <tt>sliceXZ(UNDERFLOW_BIN,OVERFLOW_BIN)</tt>.
     * @param path The path of the resulting IHistogram. The path can either be a relative or full path.
     *             ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *             All the directories in the path must exist. The characther `/` cannot be used
     *             in names; it is only used to delimit directories within paths.
     * @param hist The IHistogram3D to be projected.
     * @return     The resulting projection.
     * @throws     IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D projectionXZ(String path, IHistogram3D hist) throws IllegalArgumentException;

    /**
     * Create an IHistogram2D by projecting an IHistogram3D on the y-z plane.
     * This is equivalent to <tt>sliceYZ(UNDERFLOW_BIN,OVERFLOW_BIN)</tt>.
     * @param path The path of the resulting IHistogram. The path can either be a relative or full path.
     *             ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *             All the directories in the path must exist. The characther `/` cannot be used
     *             in names; it is only used to delimit directories within paths.
     * @param hist The IHistogram3D to be projected.
     * @return     The resulting projection.
     * @throws     IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D projectionYZ(String path, IHistogram3D hist) throws IllegalArgumentException;

    /**
     * Create an IHistogram2D by slicing an IHistogram3D perpendicular to the Z axis,
     * between "index1" and "index2" (inclusive).
     * The X axis of the IHistogram2D corresponds to the X axis of this IHistogram3D.
     * The Y axis of the IHistogram2D corresponds to the Y axis of this IHistogram3D.
     * @param path   The path of the resulting IHistogram. The path can either be a relative or full path.
     *               ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *               All the directories in the path must exist. The characther `/` cannot be used
     *               in names; it is only used to delimit directories within paths.
     * @param hist   The IHistogram3D to sliced.
     * @param index1 The index of the bin along the z axis that marks the lower edge of the slice.
     * @param index2 The index of the bin along the z axis that marks the upper edge of the slice.
     * @return       The resulting slice.
     * @throws       IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D sliceXY(String path, IHistogram3D hist, int index1, int index2) throws IllegalArgumentException;

    /**
     * Create an IHistogram2D by slicing an IHistogram3D perpendicular to the Y axis,
     * between "index1" and "index2" (inclusive).
     * The X axis of the IHistogram2D corresponds to the X axis of this IHistogram3D.
     * The Z axis of the IHistogram2D corresponds to the Z axis of this IHistogram3D.
     * @param path   The path of the resulting IHistogram. The path can either be a relative or full path.
     *               ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *               All the directories in the path must exist. The characther `/` cannot be used
     *               in names; it is only used to delimit directories within paths.
     * @param hist   The IHistogram3D to sliced.
     * @param index1 The index of the bin along the y axis that marks the lower edge of the slice.
     * @param index2 The index of the bin along the y axis that marks the upper edge of the slice.
     * @return       The resulting slice.
     * @throws       IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D sliceXZ(String path, IHistogram3D hist, int index1, int index2) throws IllegalArgumentException;

    /**
     * Create an IHistogram2D by slicing an IHistogram3D perpendicular to the X axis,
     * between "index1" and "index2" (inclusive).
     * The Y axis of the IHistogram2D corresponds to the Y axis of this IHistogram3D.
     * The Z axis of the IHistogram2D corresponds to the Z axis of this IHistogram3D.
     * @param path   The path of the resulting IHistogram. The path can either be a relative or full path.
     *               ("/folder1/folder2/dataName" and "../folder/dataName" are valid paths).
     *               All the directories in the path must exist. The characther `/` cannot be used
     *               in names; it is only used to delimit directories within paths.
     * @param hist   The IHistogram3D to sliced.
     * @param index1 The index of the bin along the x axis that marks the lower edge of the slice.
     * @param index2 The index of the bin along the x axis that marks the upper edge of the slice.
     * @return       The resulting slice.
     * @throws       IllegalArgumentException if a directory in the path does not exist, or the path is illegal.
     *
     */
    public IHistogram2D sliceYZ(String path, IHistogram3D hist, int index1, int index2) throws IllegalArgumentException;
} // class or interface

