// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * User level interface to a Profile histogram
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
public interface IProfile extends IBaseHistogram {

    /**
     * Get the number or all the entries, both in range and 
     * underflow/overflow bins of the IProfile.
     * @return The sum of all the entries.
     *
     */
    public int allEntries();

    /**
     * Get the number of entries in the underflow and overflow bins.
     * @return The numer of entries in the out-of-range bins.
     *
     */
    public int extraEntries();

    /**
     * Get the sum of in range bin heights in the IProfile.
     * @return The sum of all the in-range bins heights.
     *
     */
    public double sumBinHeights();

    /**
     * Get the sum of all the bins heights (including underflow and overflow bin).
     * @return The sum of all the bins heights.
     *
     */
    public double sumAllBinHeights();

    /**
     * Get the sum of the underflow and overflow bin height.
     * @return The sum of the out-of-range bins heights.
     *
     */
    public double sumExtraBinHeights();

    /**
     * Get the minimum height of the in-range bins.
     * @return The minimum height among the in-range bins.
     *
     */
    public double minBinHeight();

    /**
     * Get the maximum height of the in-range bins.
     * @return The maximum height among the in-range bins.
     *
     */
    public double maxBinHeight();
} // class or interface

