// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * User level interface to a 1-dimensional profile histogram
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
public interface IProfile1D extends IProfile {

    /**
     * Fill the IProfile1D.
     *
     */
    public void fill(double x, double y) throws IllegalArgumentException;
    /**
     * Fill the IProfile1D.
     *
     */
    public void fill(double x, double y, double weight) throws IllegalArgumentException;

    /**
     * The weighted mean of the corresponding bin.
     * @param index the bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     * @return      The mean of the corresponding bin along the x axis.
     * @throws      IllegalArgumentException If the index is not a valid bin number.
     *
     */
    public double binMean(int index) throws IllegalArgumentException;

    /**
     * Number of entries in the corresponding bin (ie the number of times fill was called for this bin).
     * @param index the bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     */
    public int binEntries(int index);

    /**
     * Total height of the corresponding bin (ie the sum of the weights in this bin).
     * @param index the bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     */
    public double binHeight(int index);

    /**
     * The error on this bin.
     * @param index the bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     */
    public double binError(int index);

    /**
     * The spread (RMS) of a bin.
     * @param index the bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     *
     */
    public double binRms(int index);

    /**
     * Returns the mean of the whole profile as calculated on filling-time.
     */
    public double mean();

    /**
     * Returns the rms of the whole profile as calculated on filling-time.
     */
    public double rms();

    /**
     * Returns the X axis.
     */
    public IAxis axis();

    /**
     * Convenience method, equivalent to <tt>axis().coordToIndex(coord)</tt>.
     * @see IAxis#coordToIndex(double)
     */
    public int coordToIndex(double coord);

    /**
     * Modifies this IProfile1D by adding the contents of profile to it.
     *
     * @param profile The IProfile1D to be added to this IProfile1D
     * @throws IllegalArgumentException if profile binnings are incompatible
     */
    public void add(IProfile1D profile) throws IllegalArgumentException;
} // class or interface

