/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.test.AidaTestCase;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;

public class TestCloud
extends AidaTestCase {
    private String cloud1DName = "1D Cloud Name Test";
    private String cloud1Dtitle = "1D Cloud title Test";
    private String cloud1DOpts = "Some, options=false , for=true, cloud1D=maybe ; autoConvert = false";
    private String cloud2DName = "2D Cloud Name Test";
    private String cloud2Dtitle = "2D Cloud title Test";
    private String cloud2DOpts = " Some= asdf, options = false , for= true, cloud2D = maybe, autoConvert";
    private String cloud3DName = "3D Cloud Name Test";
    private String cloud3Dtitle = "3D Cloud title Test";
    private String cloud3DOpts = " Some = sdf, options = False , for = TRUE, cloud3D = maybe, autoconvert = true";
    private int maxEntries = 10000000;
    private int xBins = 20;
    private int yBins = 15;
    private int zBins = 10;

    public TestCloud(String testName) {
        super(testName);
    }

    public void testCloudCreation() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ICloud1D cl1D = hf.createCloud1D(this.cloud1DName, this.cloud1Dtitle, this.maxEntries, this.cloud1DOpts);
        Assert.assertEquals((String)this.cloud1DName, (String)((IManagedObject)cl1D).name());
        Assert.assertEquals((String)this.cloud1Dtitle, (String)cl1D.title());
        Assert.assertEquals((int)1, (int)cl1D.dimension());
        ICloud2D cl2D = hf.createCloud2D(this.cloud2DName, this.cloud2Dtitle, this.maxEntries, this.cloud2DOpts);
        Assert.assertEquals((String)this.cloud2DName, (String)((IManagedObject)cl2D).name());
        Assert.assertEquals((String)this.cloud2Dtitle, (String)cl2D.title());
        Assert.assertEquals((int)2, (int)cl2D.dimension());
        ICloud3D cl3D = hf.createCloud3D(this.cloud3DName, this.cloud3Dtitle, this.maxEntries, this.cloud3DOpts);
        Assert.assertEquals((String)this.cloud3DName, (String)((IManagedObject)cl3D).name());
        Assert.assertEquals((String)this.cloud3Dtitle, (String)cl3D.title());
        Assert.assertEquals((int)3, (int)cl3D.dimension());
    }

    public void testCloudFill() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ICloud1D cl1D = hf.createCloud1D(this.cloud1DName, this.cloud1Dtitle, -1, this.cloud1DOpts);
        ICloud2D cl2D = hf.createCloud2D(this.cloud2DName, this.cloud2Dtitle, -1, this.cloud2DOpts);
        ICloud3D cl3D = hf.createCloud3D(this.cloud3DName, this.cloud3Dtitle, -1, this.cloud3DOpts);
        IHistogram1D h1D = hf.createHistogram1D("AIDA 1D Histogram", this.xBins, -5.0, 5.0);
        IHistogram2D h2D = hf.createHistogram2D("AIDA 2D Histogram", this.xBins, -5.0, 5.0, this.yBins, -5.0, 5.0);
        IHistogram3D h3D = hf.createHistogram3D("AIDA 3D Histogram", this.xBins, -5.0, 5.0, this.yBins, -5.0, 5.0, this.zBins, -5.0, 5.0);
        double clUpperEdgeX = Double.MIN_VALUE;
        double clLowerEdgeX = Double.MAX_VALUE;
        double clUpperEdgeY = Double.MIN_VALUE;
        double clLowerEdgeY = Double.MAX_VALUE;
        double clUpperEdgeZ = Double.MIN_VALUE;
        double clLowerEdgeZ = Double.MAX_VALUE;
        double xValueTotal = 0.0;
        double yValueTotal = 0.0;
        double zValueTotal = 0.0;
        double weightTotal = 0.0;
        int entries = 20473;
        Random r = this.getRandomNumberGenerator();
        int i = 0;
        while (i < entries) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            xValueTotal += xval;
            yValueTotal += yval;
            zValueTotal += zval;
            if (w > r.nextDouble()) {
                cl1D.fill(xval, w);
                h1D.fill(xval, w);
                cl2D.fill(xval, yval, w);
                h2D.fill(xval, yval, w);
                cl3D.fill(xval, yval, zval, w);
                h3D.fill(xval, yval, zval, w);
                weightTotal += w;
            } else {
                cl1D.fill(xval);
                h1D.fill(xval);
                cl2D.fill(xval, yval);
                h2D.fill(xval, yval);
                cl3D.fill(xval, yval, zval);
                h3D.fill(xval, yval, zval);
                weightTotal += 1.0;
            }
            if (xval > clUpperEdgeX) {
                clUpperEdgeX = xval;
            }
            if (xval < clLowerEdgeX) {
                clLowerEdgeX = xval;
            }
            if (yval > clUpperEdgeY) {
                clUpperEdgeY = yval;
            }
            if (yval < clLowerEdgeY) {
                clLowerEdgeY = yval;
            }
            if (zval > clUpperEdgeZ) {
                clUpperEdgeZ = zval;
            }
            if (zval < clLowerEdgeZ) {
                clLowerEdgeZ = zval;
            }
            ++i;
        }
        int cl1DEntries = cl1D.entries();
        Assert.assertEquals((int)entries, (int)cl1DEntries);
        int cl2DEntries = cl2D.entries();
        Assert.assertEquals((int)entries, (int)cl2DEntries);
        int cl3DEntries = cl3D.entries();
        Assert.assertEquals((int)entries, (int)cl3DEntries);
        Assert.assertEquals((double)cl1D.lowerEdge(), (double)clLowerEdgeX, (double)0.0);
        Assert.assertEquals((double)cl1D.upperEdge(), (double)clUpperEdgeX, (double)0.0);
        Assert.assertEquals((double)cl2D.lowerEdgeX(), (double)clLowerEdgeX, (double)0.0);
        Assert.assertEquals((double)cl2D.upperEdgeX(), (double)clUpperEdgeX, (double)0.0);
        Assert.assertEquals((double)cl2D.lowerEdgeY(), (double)clLowerEdgeY, (double)0.0);
        Assert.assertEquals((double)cl2D.upperEdgeY(), (double)clUpperEdgeY, (double)0.0);
        Assert.assertEquals((double)cl3D.lowerEdgeX(), (double)clLowerEdgeX, (double)0.0);
        Assert.assertEquals((double)cl3D.upperEdgeX(), (double)clUpperEdgeX, (double)0.0);
        Assert.assertEquals((double)cl3D.lowerEdgeY(), (double)clLowerEdgeY, (double)0.0);
        Assert.assertEquals((double)cl3D.upperEdgeY(), (double)clUpperEdgeY, (double)0.0);
        Assert.assertEquals((double)cl3D.lowerEdgeZ(), (double)clLowerEdgeZ, (double)0.0);
        Assert.assertEquals((double)cl3D.upperEdgeZ(), (double)clUpperEdgeZ, (double)0.0);
        double xValueTotalCloud1D = 0.0;
        double weightTotalCloud1D = 0.0;
        double xValueTotalCloud2D = 0.0;
        double yValueTotalCloud2D = 0.0;
        double weightTotalCloud2D = 0.0;
        double xValueTotalCloud3D = 0.0;
        double yValueTotalCloud3D = 0.0;
        double zValueTotalCloud3D = 0.0;
        double weightTotalCloud3D = 0.0;
        int i2 = 0;
        while (i2 < entries) {
            xValueTotalCloud1D += cl1D.value(i2);
            weightTotalCloud1D += cl1D.weight(i2);
            xValueTotalCloud2D += cl2D.valueX(i2);
            yValueTotalCloud2D += cl2D.valueY(i2);
            weightTotalCloud2D += cl2D.weight(i2);
            xValueTotalCloud3D += cl3D.valueX(i2);
            yValueTotalCloud3D += cl3D.valueY(i2);
            zValueTotalCloud3D += cl3D.valueZ(i2);
            weightTotalCloud3D += cl3D.weight(i2);
            ++i2;
        }
        Assert.assertTrue((xValueTotal != 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((yValueTotal != 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((zValueTotal != 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((weightTotal != 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((xValueTotal != Double.NaN ? 1 : 0) != 0);
        Assert.assertTrue((yValueTotal != Double.NaN ? 1 : 0) != 0);
        Assert.assertTrue((zValueTotal != Double.NaN ? 1 : 0) != 0);
        Assert.assertTrue((weightTotal != Double.NaN ? 1 : 0) != 0);
        Assert.assertTrue((xValueTotal == xValueTotalCloud1D ? 1 : 0) != 0);
        Assert.assertTrue((weightTotal == weightTotalCloud1D ? 1 : 0) != 0);
        Assert.assertTrue((xValueTotal == xValueTotalCloud2D ? 1 : 0) != 0);
        Assert.assertTrue((yValueTotal == yValueTotalCloud2D ? 1 : 0) != 0);
        Assert.assertTrue((weightTotal == weightTotalCloud2D ? 1 : 0) != 0);
        Assert.assertTrue((xValueTotal == xValueTotalCloud3D ? 1 : 0) != 0);
        Assert.assertTrue((yValueTotal == yValueTotalCloud3D ? 1 : 0) != 0);
        Assert.assertTrue((zValueTotal == zValueTotalCloud3D ? 1 : 0) != 0);
        Assert.assertTrue((weightTotal == weightTotalCloud3D ? 1 : 0) != 0);
        Assert.assertTrue((!cl1D.isConverted() ? 1 : 0) != 0);
        Assert.assertTrue((!cl2D.isConverted() ? 1 : 0) != 0);
        Assert.assertTrue((!cl3D.isConverted() ? 1 : 0) != 0);
        cl1D.reset();
        cl2D.reset();
        cl3D.reset();
        Assert.assertEquals((int)cl1D.entries(), (int)0);
        Assert.assertEquals((int)cl2D.entries(), (int)0);
        Assert.assertEquals((int)cl3D.entries(), (int)0);
    }

    public void testCloudConversion() {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        int maxE = 250;
        ICloud1D cl1D = hf.createCloud1D(this.cloud1DName, this.cloud1Dtitle, maxE, this.cloud1DOpts);
        ICloud2D cl2D = hf.createCloud2D(this.cloud2DName, this.cloud2Dtitle, maxE, this.cloud2DOpts);
        ICloud3D cl3D = hf.createCloud3D(this.cloud3DName, this.cloud3Dtitle, maxE, this.cloud3DOpts);
        IHistogram1D h1D = hf.createHistogram1D("AIDA 1D Histogram", this.xBins, -5.0, 5.0);
        IHistogram2D h2D = hf.createHistogram2D("AIDA 2D Histogram", this.xBins, -5.0, 5.0, this.yBins, -5.0, 5.0);
        IHistogram3D h3D = hf.createHistogram3D("AIDA 3D Histogram", this.xBins, -5.0, 5.0, this.yBins, -5.0, 5.0, this.zBins, -5.0, 5.0);
        int entries = 1347;
        int i = 0;
        while (i < entries) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            if (w > r.nextDouble()) {
                cl1D.fill(xval, w);
                h1D.fill(xval, w);
                cl2D.fill(xval, yval, w);
                h2D.fill(xval, yval, w);
                cl3D.fill(xval, yval, zval, w);
                h3D.fill(xval, yval, zval, w);
            } else {
                cl1D.fill(xval);
                h1D.fill(xval);
                cl2D.fill(xval, yval);
                h2D.fill(xval, yval);
                cl3D.fill(xval, yval, zval);
                h3D.fill(xval, yval, zval);
            }
            if (i != 0) {
                Assert.assertEquals((double)cl1D.mean(), (double)h1D.mean(), (double)0.0);
                Assert.assertEquals((double)cl1D.mean(), (double)cl2D.meanX(), (double)0.0);
                Assert.assertEquals((double)cl1D.mean(), (double)cl3D.meanX(), (double)0.0);
                Assert.assertEquals((double)cl2D.meanX(), (double)h2D.meanX(), (double)0.0);
                Assert.assertEquals((double)cl2D.meanY(), (double)h2D.meanY(), (double)0.0);
                Assert.assertEquals((double)cl2D.meanY(), (double)cl3D.meanY(), (double)0.0);
                Assert.assertEquals((double)cl3D.meanX(), (double)h3D.meanX(), (double)0.0);
                Assert.assertEquals((double)cl3D.meanY(), (double)h3D.meanY(), (double)0.0);
                Assert.assertEquals((double)cl3D.meanZ(), (double)h3D.meanZ(), (double)0.0);
                Assert.assertEquals((double)cl1D.rms(), (double)h1D.rms(), (double)0.0);
                Assert.assertEquals((double)cl1D.rms(), (double)cl2D.rmsX(), (double)0.0);
                Assert.assertEquals((double)cl1D.rms(), (double)cl3D.rmsX(), (double)0.0);
                Assert.assertEquals((double)cl2D.rmsX(), (double)h2D.rmsX(), (double)0.0);
                Assert.assertEquals((double)cl2D.rmsY(), (double)h2D.rmsY(), (double)0.0);
                Assert.assertEquals((double)cl2D.rmsY(), (double)cl3D.rmsY(), (double)0.0);
                Assert.assertEquals((double)cl3D.rmsX(), (double)h3D.rmsX(), (double)0.0);
                Assert.assertEquals((double)cl3D.rmsY(), (double)h3D.rmsY(), (double)0.0);
                Assert.assertEquals((double)cl3D.rmsZ(), (double)h3D.rmsZ(), (double)0.0);
            }
            ++i;
        }
        Assert.assertEquals((int)entries, (int)cl1D.entries());
        Assert.assertEquals((int)entries, (int)h1D.allEntries());
        Assert.assertEquals((int)entries, (int)cl2D.entries());
        Assert.assertEquals((int)entries, (int)h2D.allEntries());
        Assert.assertEquals((int)entries, (int)cl3D.entries());
        Assert.assertEquals((int)entries, (int)h3D.allEntries());
        IHistogram1D convertedH1D = cl1D.histogram();
        Assert.assertTrue((convertedH1D != null ? 1 : 0) != 0);
        Assert.assertEquals((double)convertedH1D.mean(), (double)h1D.mean(), (double)0.0);
        Assert.assertEquals((double)convertedH1D.rms(), (double)h1D.rms(), (double)0.0);
        IHistogram2D convertedH2D = cl2D.histogram();
        Assert.assertTrue((convertedH2D != null ? 1 : 0) != 0);
        Assert.assertEquals((double)convertedH2D.meanX(), (double)h2D.meanX(), (double)0.0);
        Assert.assertEquals((double)convertedH2D.meanY(), (double)h2D.meanY(), (double)0.0);
        Assert.assertEquals((double)convertedH2D.rmsX(), (double)h2D.rmsX(), (double)0.0);
        Assert.assertEquals((double)convertedH2D.rmsY(), (double)h2D.rmsY(), (double)0.0);
        IHistogram3D convertedH3D = cl3D.histogram();
        Assert.assertTrue((convertedH3D != null ? 1 : 0) != 0);
        Assert.assertEquals((double)convertedH3D.meanX(), (double)h3D.meanX(), (double)0.0);
        Assert.assertEquals((double)convertedH3D.meanY(), (double)h3D.meanY(), (double)0.0);
        Assert.assertEquals((double)convertedH3D.meanZ(), (double)h3D.meanZ(), (double)0.0);
        Assert.assertEquals((double)convertedH3D.rmsX(), (double)h3D.rmsX(), (double)0.0);
        Assert.assertEquals((double)convertedH3D.rmsY(), (double)h3D.rmsY(), (double)0.0);
        Assert.assertEquals((double)convertedH3D.rmsZ(), (double)h3D.rmsZ(), (double)0.0);
        cl1D.reset();
        cl2D.reset();
        cl3D.reset();
        Assert.assertEquals((int)cl1D.entries(), (int)0);
        Assert.assertEquals((int)cl2D.entries(), (int)0);
        Assert.assertEquals((int)cl3D.entries(), (int)0);
    }

    public void testCloudSaveRestore() throws IOException {
        Random r = this.getRandomNumberGenerator();
        String outputName = "testCloud.aida";
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree tree = tf.create(outputName, null, false, true);
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ICloud1D cl1Da = hf.createCloud1D("cl1Da", "Cloud1d Not Converted", this.maxEntries, "");
        ICloud1D cl1Db = hf.createCloud1D("cl1Db", "Cloud1D Converted", 5, "");
        ICloud2D cl2Da = hf.createCloud2D("cl2Da", "Cloud2D Not Converted", this.maxEntries, this.cloud2DOpts);
        ICloud2D cl2Db = hf.createCloud2D("cl2Db", "Cloud2D Converted", 5, this.cloud2DOpts);
        ICloud3D cl3Da = hf.createCloud3D("cl3Da", "Cloud3D Not Converted", this.maxEntries, this.cloud3DOpts);
        ICloud3D cl3Db = hf.createCloud3D("cl3Db", "Cloud3D Converted", 5, this.cloud3DOpts);
        int entries = 37;
        int i = 0;
        while (i < entries) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            if (w < r.nextDouble()) {
                cl1Da.fill(xval, w);
                cl1Db.fill(xval, w);
                cl2Da.fill(xval, yval, w);
                cl2Db.fill(xval, yval, w);
                cl3Da.fill(xval, yval, zval, w);
                cl3Db.fill(xval, yval, zval, w);
            } else {
                cl1Da.fill(xval);
                cl1Db.fill(xval);
                cl2Da.fill(xval, yval);
                cl2Db.fill(xval, yval);
                cl3Da.fill(xval, yval, zval);
                cl3Db.fill(xval, yval, zval);
            }
            ++i;
        }
        Assert.assertTrue((!cl1Da.isConverted() ? 1 : 0) != 0);
        Assert.assertTrue((!cl2Da.isConverted() ? 1 : 0) != 0);
        Assert.assertTrue((!cl3Da.isConverted() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)cl1Db.isConverted());
        Assert.assertTrue((boolean)cl2Db.isConverted());
        Assert.assertTrue((boolean)cl3Db.isConverted());
        tree.commit();
        ITree newTree = tf.create(outputName);
        ICloud1D cl1DaNew = (ICloud1D)newTree.find(((IManagedObject)cl1Da).name());
        ICloud1D cl1DbNew = (ICloud1D)newTree.find(((IManagedObject)cl1Db).name());
        ICloud2D cl2DaNew = (ICloud2D)newTree.find(((IManagedObject)cl2Da).name());
        ICloud2D cl2DbNew = (ICloud2D)newTree.find(((IManagedObject)cl2Db).name());
        ICloud3D cl3DaNew = (ICloud3D)newTree.find(((IManagedObject)cl3Da).name());
        ICloud3D cl3DbNew = (ICloud3D)newTree.find(((IManagedObject)cl3Db).name());
        AidaTestCase.assertEquals(cl1Da, cl1DaNew);
        AidaTestCase.assertEquals(cl1Db, cl1DbNew);
        AidaTestCase.assertEquals(cl2Da, cl2DaNew);
        AidaTestCase.assertEquals(cl2Db, cl2DbNew);
        AidaTestCase.assertEquals(cl3Da, cl3DaNew);
        AidaTestCase.assertEquals(cl3Db, cl3DbNew);
    }

    public void testCloudScale() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ICloud1D cl1DScaled = hf.createCloud1D("cl1DScaled", this.cloud1Dtitle, -1, this.cloud1DOpts);
        ICloud2D cl2DScaled = hf.createCloud2D("cl2DScaled", this.cloud2Dtitle, -1, this.cloud2DOpts);
        ICloud3D cl3DScaled = hf.createCloud3D("cl3DScaled", this.cloud3Dtitle, -1, this.cloud3DOpts);
        ICloud1D cl1DNotScaled = hf.createCloud1D("cl1DScaled", this.cloud1Dtitle, -1, this.cloud1DOpts);
        ICloud2D cl2DNotScaled = hf.createCloud2D("cl2DScaled", this.cloud2Dtitle, -1, this.cloud2DOpts);
        ICloud3D cl3DNotScaled = hf.createCloud3D("cl3DScaled", this.cloud3Dtitle, -1, this.cloud3DOpts);
        double scale1D = 0.8;
        double scale2D = 3.5;
        double scale3D = 0.001;
        Random r = this.getRandomNumberGenerator();
        int i = 0;
        while (i < 40) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            cl1DScaled.fill(xval, w * scale1D);
            cl1DNotScaled.fill(xval, w);
            cl2DScaled.fill(xval, yval, w * scale2D);
            cl2DNotScaled.fill(xval, yval, w);
            cl3DScaled.fill(xval, yval, zval, w * scale3D);
            cl3DNotScaled.fill(xval, yval, zval, w);
            ++i;
        }
        cl1DNotScaled.scale(scale1D);
        cl2DNotScaled.scale(scale2D);
        cl3DNotScaled.scale(scale3D);
        AidaTestCase.assertEquals(cl1DNotScaled, cl1DScaled);
        AidaTestCase.assertEquals(cl2DNotScaled, cl2DScaled);
        AidaTestCase.assertEquals(cl3DNotScaled, cl3DScaled);
        int i2 = 0;
        while (i2 < 50) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            cl1DScaled.fill(xval, w);
            cl1DNotScaled.fill(xval, w);
            cl2DScaled.fill(xval, yval, w);
            cl2DNotScaled.fill(xval, yval, w);
            cl3DScaled.fill(xval, yval, zval, w);
            cl3DNotScaled.fill(xval, yval, zval, w);
            ++i2;
        }
        AidaTestCase.assertEquals(cl1DNotScaled, cl1DScaled);
        AidaTestCase.assertEquals(cl2DNotScaled, cl2DScaled);
        AidaTestCase.assertEquals(cl3DNotScaled, cl3DScaled);
    }

    public void testCloudCopy() throws IOException {
        String inputFileName = "testCloud.aida";
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree tree = tf.create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ITree newTree = tf.create(inputFileName);
        ICloud1D cl1Da = (ICloud1D)newTree.find("cl1Da");
        ICloud1D cl1Db = (ICloud1D)newTree.find("cl1Db");
        ICloud2D cl2Da = (ICloud2D)newTree.find("cl2Da");
        ICloud2D cl2Db = (ICloud2D)newTree.find("cl2Db");
        ICloud3D cl3Da = (ICloud3D)newTree.find("cl3Da");
        ICloud3D cl3Db = (ICloud3D)newTree.find("cl3Db");
        hf.createCopy("cl1Da", cl1Da);
        hf.createCopy("cl1Db", cl1Db);
        hf.createCopy("cl2Da", cl2Da);
        hf.createCopy("cl2Db", cl2Db);
        hf.createCopy("cl3Da", cl3Da);
        hf.createCopy("cl3Db", cl3Db);
        ICloud1D cl1DaNew = (ICloud1D)tree.find("cl1Da");
        ICloud1D cl1DbNew = (ICloud1D)tree.find("cl1Db");
        ICloud2D cl2DaNew = (ICloud2D)tree.find("cl2Da");
        ICloud2D cl2DbNew = (ICloud2D)tree.find("cl2Db");
        ICloud3D cl3DaNew = (ICloud3D)tree.find("cl3Da");
        ICloud3D cl3DbNew = (ICloud3D)tree.find("cl3Db");
        AidaTestCase.assertEquals(cl1Da, cl1DaNew);
        AidaTestCase.assertEquals(cl1Db, cl1DbNew);
        AidaTestCase.assertEquals(cl2Da, cl2DaNew);
        AidaTestCase.assertEquals(cl2Db, cl2DbNew);
        AidaTestCase.assertEquals(cl3Da, cl3DaNew);
        AidaTestCase.assertEquals(cl3Db, cl3DbNew);
    }
}

