// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * User level interface to a Cloud.
 * A Cloud is an unbinned collection of points. It can be used to
 * represent scatter plots or dynamically rebinnable histograms.
 * If they number of entries in the cloud exceeds some threshold 
 * they may be automatically converted to a binned histogram.
 * 
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

public interface ICloud extends IBaseHistogram {

    /**
     * Get the sum of weights of all the entries.
     * @return The sum of the weights of all the entries.
     *
     */
    public double sumOfWeights();

    /**
     * Convert the ICloud to an IHistogram using the default number of bins.
     * @throws   AlreadyConvertedException If the ICloud has already been converted.
     *
     */
    public void convertToHistogram() throws AlreadyConvertedException;

    /**
     * Check if the ICloud has been converted to an IHistogram.
     * @return <code>true</code> if it has been converted.
     *
     */
    public boolean isConverted();

    /**
     * Get the number of entries after which the cloud will be converted to an IHistogram.
     * @return The number of entries.
     *
     */
    public int maxEntries();

    /**
     * Scale the weights by a given factor.
     * @param scaleFactor The scale factor.
     * @throws IllegalArgumentException If a non-positive scale factor is provided.
     *
     */
    public void scale(double scaleFactor) throws IllegalArgumentException;
} // class or interface

