// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * Basic user-level interface class for holding and managing
 * a single set of "data points".
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

public interface IDataPointSet {

    /**
     * Get the IAnnotation of the IDataPointSet.
     * @return The IAnnotation.
     *
     */
    public IAnnotation annotation();

    /**
     * Get the title of the IDataPointSet.
     * @return The title.
     *
     */
    public String title();

    /**
     * Set the title of the IDataPointSet.
     * @param title The new title.
     * @throws      IllegalArgumentException If the title cannot be set.
     *
     */
    public void setTitle(String title) throws IllegalArgumentException;

    /**
     * Get the dimension of the IDataPoints that can be stored in the set.
     * @return The dimension of the IDataPoints storable in the set.
     *
     */
    public int dimension();

    /**
     * Remove all the IDataPoints in the set.
     * After this the IDataPointSet is as just created.
     *
     */
    public void clear();

    /**
     * Get the current size of the IDataPointSet, i.e. the number
     * of IDataPoints contained in the set.
     * @return The size of the IDataPointSet.
     *
     */
    public int size();

    /**
     * Get the IDataPoint at a give index in the set.
     * @param index The IDataPoint index.
     * @return      The corresponding IDataPoint.
     *
     */
    public IDataPoint point(int index);

    /**
     * Set the values and errors of a given coordinate all at once.
     * If this method is called on an empty IDataPointSet, a number of points equal
     * to the size of the arrays provided is created; if the IDataPointSet is not empty
     * the dimension of the array must match with the size of the IDataPointSet.
     * @param coord The coordinate's index
     * @param val   The array of the values for the given coordinate
     * @param err   The array with the symmetric errors.
     * @throws      IllegalArgumentException if an illegal coordinate is provided or if
     *              there is a mismatch between the size of the array and the size of the IDataPointSet.
     *
     */
    public void setCoordinate(int coord, double[] val, double[] err) throws IllegalArgumentException;

    /**
     * Set the values and errors of a given coordinate all at once.
     * If this method is called on an empty IDataPointSet, a number of points equal
     * to the size of the arrays provided is created; if the IDataPointSet is not empty
     * the dimension of the array must match with the size of the IDataPointSet.
     * @param coord The coordinate's index
     * @param val   The array of the values for the given coordinate
     * @param errp  The array with the plus errors.
     * @param errm  The array with the minus errors.
     * @throws      IllegalArgumentException if an illegal coordinate is provided or if
     *              there is a mismatch between the size of the array and the size of the IDataPointSet.
     *
     */
    public void setCoordinate(int coord, double[] val, double[] errp, double[] errm) throws IllegalArgumentException;

    /**
     * Add a new empty IDataPoint at the end of the set.
     * @return The newly added point.
     * @throws RuntimeException If a new IDataPoint cannot be added to the set.
     *
     */
    public IDataPoint addPoint() throws RuntimeException;

    /**
     * Add a copy of an IDataPoint at the end of the set.
     * @param point The IDataPoint to be added.
     * @throws      IllegalArgumentException If the point has the wrong dimension or
     *                                       if the point cannot be added.
     *
     */
    public void addPoint(IDataPoint point) throws IllegalArgumentException;

    /**
     * Remove the IDataPoint at a given index.
     * @param index The index of the IDataPoint to be removed.
     * @throws      IllegalArgumentException If the index is < 0 or >= size().
     *
     */
    public void removePoint(int index) throws IllegalArgumentException;

    /**
     * Get the lower value for a give axis.
     * @param coord The coordinate of the axis.
     * @return      The lower edge of the corresponding axis.
     * @throws      IllegalArgumentException if coord < 0 or coord >= dimension() or if the set is empty.
     *
     */
      
    public double lowerExtent(int coord) throws IllegalArgumentException;

    /**
     * Get the upper value for a give axis.
     * @param coord The coordinate of the axis.
     * @return      The upper edge of the corresponding axis.
     * @throws      IllegalArgumentException if coord < 0 or coord >= dimension() or if the set is empty.
     *
     */
      
    public double upperExtent(int coord) throws IllegalArgumentException;

    /**
     * Scales the values and the errors of all the measurements
     * of each point by a given factor.
     * @param scaleFactor The scale factor.
     * @throws IllegalArgumentException If an illegal scaleFactor is provided.
     *
     */
    public void scale(double scaleFactor) throws IllegalArgumentException;

    /**
     * Scales the values of all the measurements
     * of each point by a given factor.
     * @param scaleFactor The scale factor.
     * @throws IllegalArgumentException If an illegal scaleFactor is provided.
     *
     */
    public void scaleValues(double scaleFactor) throws IllegalArgumentException;

    /**
     * Scales the errors of all the measurements
     * of each point by a given factor.
     * @param scaleFactor The scale factor.
     * @throws IllegalArgumentException If an illegal scaleFactor is provided.
     *
     */
    public void scaleErrors(double scaleFactor) throws IllegalArgumentException;
} // class or interface

