// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 *
 * Principal user-level function interface. Function is a self
 * contained object, which remembers the current value of its parameters
 * which are simple doubles. IFunction may be directly plotted or fitted.
 *
 * The standard convention of referring to variables by name:
 * "x[0]" corresponds to variable number 0 etc.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
public interface IFunction {

    /**
     * Get the Function's title.
     * @return The Function's title.
     *
     */
    public String title();

    /**
     * Set	 the histogram title.
     * @param title The title.
     * @throws      IllegalArgumentEception If title cannot be changed.
     *
     */
    public void setTitle(String title) throws IllegalArgumentException;

    /**
     * Scalar value of the function.
     */
    public double value(double[] x);

    /**
     * Dimensionality of the domain space.
     */
    public int dimension();

    /**
     * Compare if functions are the same.
     * PENDING: define exactly what it means ;)
     */
    public boolean isEqual(IFunction f);

    /**
     * Gradient of the function.
     * The result is valid only if providesGradient()==true.
     * Otherwise the result is some default (empty) vector.
     */
    public double[] gradient(double[] x);

    /**
     * Determine whether function is able to compute gradient.
     */
    public boolean providesGradient();

    /**
     * Get the symbolic name of i-th variable.
     */
    public String variableName(int i);

    /**
     * Get all the names in a vector.
     */
    public String[] variableNames();

    /**
      * Set new vector of parameters.
      */
    public void setParameters(double[] params) throws IllegalArgumentException;

    /**
     * Retrieve current vector of parameters.
     */
    public double[] parameters();

    /**
     * Number of parameters.
     */
    public int numberOfParameters();

    /**
     * Names of paramaters.
     * Names should be unique. Case-insensitive for comparison.
     * Case-sensitive for storage and output.
     * All or several names may be left blank "" if the implementation
     * does not want to provide them.
     */
    public String[] parameterNames();

    /**
     * Set parameter's value by name.
     * @param name The name of the parameter.
     * @param x    The new value of the parameter.
     * @throws     IllegalArgumentException If name does not correspond to a parameter.
     *
     */
    public void setParameter(String name, double x) throws IllegalArgumentException;

    public double parameter(String name);

  /**
   * Return -1 if parameter not found (name undefined).
   * Leave it because there are use cases - some users prefer to use numbers.
   */
    public int indexOfParameter(String name);

    public IAnnotation annotation();

  /**
   * String describing the metatype and implementation of the function.
   *
   * Generic format of the string:
   *
   * codelet:TYPE:LOCATION
   *
   * TYPE part contains only a 'typename' string
   * which is a metatype identifier (used in plugins and catalogues)
   *
   * LOCATION may be: 'file', 'verbatim', or 'catalogue'
   *
   * Detailed description:
   *
   * codelet:typename - no location specified (using 'catalogue')
   *
   * codelet:typename:file:/filename.cpp    -  a c++ source file
   * codelet:typename:file:/filename.py     -  a python source file
   * codelet:typename:file:/filename.so     -  a shared library
   *
   * codelet:typename:catalogue        - entry in a catalogue repository
   *
   * codelet:typename:verbatim:cpp \n  - c++ source file included verbatim
   *                                     after \n
   *
   * codelet:typename:verbatim:py  \n  - python source file included
   *                                     verbatim aftern \n
   *
   *
   * Comments:
   *
   * file:/filename is a relative path to $AIDA_FUNCTION_DEFAULT_DIR
   * file://filename is an absolute path
   *
   * Examples:
   *
   * codelet:G:catalogue
   * codelet:userSinus:verbatim:cpp \n { return sin(x); }
   */
    public String codeletString();

    /** @link aggregation */
    /*#  IAnnotation lnkIAnnotation; */
} // class or interface

