// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IPLOTTER_H
#define AIDA_IPLOTTER_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include <string>
#include <vector>

namespace AIDA {

class IPlotterRegion;
class ITitleStyle;

/**
 *  User level interface to plotter.
 *
 * This IPlotter interface assumes the handling of
 * multiple plotting regions. Then the IPlotter should
 * be seen as a "page" managing multiple drawing region.
 * It assumes that a "current" region mechanism is used.
 * 
 *  The keyword "region" is borrowed from the OpenInventor
 * terminology (viewing region).
 *
 *  See also the IPlotterRegion for more comments.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
class IPlotter {

public: 
    /// Destructor.
    virtual ~IPlotter() { /* nop */; }

  /**
   * Region management methods.
   */

  /**
   * Create a new region.
   * @param x, y, w, h Position and size in normal coordinates
   *                   that is to say between 0 and 1.
   *                   Then a region with (x=0,y=0,w=1,h=1) maps
   *                   the full page. "x" goes left to right. "y" bottom
   *                   to top.
   * @return The newly created region. Return null in case not failure.
   *         Note that the plotter manages the regions ; user does not
   *         have to delete a region object directly.
   */
    virtual IPlotterRegion * createRegion(double x = 0, double y = 0, double w = 1.0, double h = 1.0) = 0;

  /**
   * Create a grid of regions.
   * By default the current region is the top left one (with index 0).
   * Region are indexed from zero, with increasing order
   * left to right, top to bottom.
   * @param index Set the current region.
   */
    virtual bool createRegions(int columns = 1, int rows = 1, int index = 0) = 0;

  /**
   * @return The current region.
   */
    virtual IPlotterRegion & currentRegion() const = 0;

  /**
   * @return The current region index.
   */
    virtual int currentRegionNumber() const = 0;

  /**
   * @return The number of regions.
   */
    virtual int numberOfRegions() const = 0;

  /**
   * Set current region by giving its index [0,n-1]
   */
    virtual bool setCurrentRegionNumber(int index) = 0;

  /**
   * Set current region to be the "next" one.
   * If exceeding the number of regions,
   * the current region index return to 0.
   * @return The new current region.
   */
    virtual IPlotterRegion & next() = 0;

  /**
   * @return A region, knowing its index.
   */
    virtual IPlotterRegion * region(int index) const = 0;

  /**
   *  Destroy regions.
   */
    virtual void destroyRegions() = 0;

  /**
   * Clear all regions. It does not reset the number
   * and position of regions. This can be done through
   * a destroyRegions.
   */
    virtual void clearRegions() = 0;

  /*
   * Set various plotting paramters for the whole page.
   * Activate the graphic layer and update the screen window(s)
   * if needed.
   */
    virtual bool setParameter(const std::string & parameter, const std::string & options = "") = 0;

  /**
   * Get value of a parameter. 
   * @param paramName Name of the parameter.
   * @return the value.
   */
    virtual std::string parameterValue(const std::string & parameter) const = 0;

    virtual std::vector<std::string>  availableParameterOptions(const std::string & parameter) const = 0;

    virtual std::vector<std::string>  availableParameters() const = 0;

  /*
   * GUI related methods :
   */

  /**
   * Map the plotter on the screen.
   */
    virtual bool show() = 0;

  /**
   * Refresh the screen window(s).
   * Used when a plotted data analysis object
   * received new data.
   */
    virtual bool refresh() = 0;

  /**
   * Unmap the plotter on the screen.
   */
    virtual bool hide() = 0;

  /**
   * Give control to the plotter GUI. The plotter must be able
   * to return from this function from a user action in its GUI.
   */
    virtual bool interact() = 0;

  /*
   * Other methods.
   */

  /**
   * Produce an output file.
   * @param type  A string to describe the type of the output :
   *  "PS"  or "PostScript" for PostScript, "JPEG" for JPEG.
   *  If nothing is given, the type is guessed
   *  from the given file name suffix (.ps for PostScript,
   *  .jpg for JPEG, etc...).
   */
    virtual bool writeToFile(const std::string & filename, const std::string & type = "") = 0;

  /**
   * Set the global title of the plotter (page).
   */
    virtual void setTitle(const std::string & title) = 0;

  /**
   * Get/set title style.
   */
    virtual ITitleStyle & titleStyle() = 0;

    virtual void setTitleStyle(const ITitleStyle & style) = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IPLOTTER_H */
