// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 *
 * Abstract representation of the fit data. Serves for several purposes:
 *  - decouple fitter from the details of the particular data 
 *    objects (Histograms etc)
 *  - provide range restriction capability ("cut of the tails...")
 *  - creates the image of the virtual data source
 *
 * Design notes:
 *
 * 1)
 * we try to be explicit in the method names which should indicate the
 * dimensionality of the fit data.
 *
 * this way we have more compile-time/run-time safety and clearer code.
 * in C++ we can handle default arguments which otherwise would be ambigeous.
 *
 * 2) 
 * string names of the arguments are at the end of the methods'
 * signatures and have default (empty) values.
 * so if function argument name is missing,
 * assume the ordering is taken from the histogram axis it connects to
 * the name of the pipes then are generated automatically using 
 * the same default scheme as for functions x[1], x[2] etc.
 *
 * 3)
 * There are two ends to pipes: one connected to the
 * data source and one pouring data out. Both their orders has to be specified.
 *
 * For IHistogram, ICloud, IProfile the connections to the data source are
 * ordered as the axis (x=0, y=1, z=2); the user has to provide the order
 * with which the pipes are providing the data. So for example in the constructor
 *   create2DConnection(hist2D,xIndex,yIndex);
 * xIndex specifies the exit order of the pipe connected to the x Axis (and similarly
 * for yIndex). So the default method
 *   create2DConnection(hist2D);
 * corresponds to
 *   create2DConnection(hist2D,0,1);
 * In the methods for IHistograms, IClouds, and IProfiles one index could have
 * been dropped as the second could be inferred by the dimensionality. We
 * preferred being redundant just to avoid confusion in interpreting what
 *   create2DConnection(hist2D,1);
 * really means.
 *
 * For ITuple and IDataPointSet the order in the connection to the data source
 * is specified by the user by providing, respectively, the array of column names (or evaluators)
 * and the array of coordinate indexes to which to connect the pipes.
 * In this case we assume that the pipes are parallel, i.e. the exit order is the same
 * as the one of the connection to the data source.
 * In the createXDConnection methods to IDataPointSets we preferred not to provide
 * defaults for the valIndex to avoid confusion in interpreting it.
 * We can always add it later.
 *
 * PENDING: clarify the relation between data range and normalization range
 *
 * @author The AIDA Team.
 *
 */

public interface IFitData {

    /**
     * One dimensional connections.
     *
     */

    /**
     * Create a one dimensional connection to an IHistogram1D.
     * @param h       The 1D histogram to which to connect to.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create1DConnection(IHistogram1D h) throws IllegalArgumentException;

    /**
     * Create a one dimensional connection to an ICloud1D.
     * @param c       The 1D cloud to which to connect to.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create1DConnection(ICloud1D c) throws IllegalArgumentException;

    /**
     * Create a one dimensional connection to an IProfile1D.
     * @param p       The 1D profile to which to connect to.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create1DConnection(IProfile1D p) throws IllegalArgumentException;

    /**
     * Create a one dimensional connection to an IDataPointSet.
     * @param dp       The dataPointSet to which to connect to.
     * @param xIndex   The index of the coordinate to which the variable is connected.
     * @param valIndex The index of the coordinate used as "height".
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create1DConnection(IDataPointSet dp, int xIndex, int valIndex) throws IllegalArgumentException;

    /**
     * Two dimensional connections.
     *
     */

    /**
     * Create a two dimensional connection to an IHistogram2D.
     * @param h        The 2D histogram to which to connect to.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create2DConnection(IHistogram2D h) throws IllegalArgumentException;

    /**
     * Create a two dimensional connection to an IHistogram2D.
     * @param h        The 2D histogram to which to connect to.
     * @param xIndex   The index of the axis to which the x variable is connected.
     * @param yIndex   The index of the axis to which the y variable is connected.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create2DConnection(IHistogram2D h, int xIndex, int yIndex) throws IllegalArgumentException;

    /**
     * Create a two dimensional connection to an ICloud2D.
     * @param c        The 2D cloud to which to connect to.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create2DConnection(ICloud2D c) throws IllegalArgumentException;

    /**
     * Create a two dimensional connection to an ICloud2D.
     * @param c        The 2D cloud to which to connect to.
     * @param xIndex   The index of the axis to which the x variable is connected.
     * @param yIndex   The index of the axis to which the y variable is connected.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create2DConnection(ICloud2D c, int xIndex, int yIndex) throws IllegalArgumentException;

    /**
     * Create a two dimensional connection to an IProfile2D.
     * @param p       The 2D profile to which to connect to.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create2DConnection(IProfile2D p) throws IllegalArgumentException;

    /**
     * Create a two dimensional connection to an IProfile2D.
     * @param p        The 2D profile to which to connect to.
     * @param xIndex   The index of the axis to which the x variable is connected.
     * @param yIndex   The index of the axis to which the y variable is connected.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create2DConnection(IProfile2D p, int xIndex, int yIndex) throws IllegalArgumentException;

    /**
     * Create a two dimensional connection to an IDataPointSet.
     * @param dp       The dataPointSet to which to connect to.
     * @param xIndex   The index of the coordinate to which the x variable is connected.
     * @param yIndex   The index of the coordinate to which the y variable is connected.
     * @param valIndex The index of the coordinate used as "height".
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create2DConnection(IDataPointSet dp, int xIndex, int yIndex, int valIndex) throws IllegalArgumentException;

    /**
     * Three dimensional connections.
     *
     */

    /**
     * Create a three dimensional connection to an IHistogram3D.
     * @param h        The 3D histogram to which to connect to.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create3DConnection(IHistogram3D h) throws IllegalArgumentException;

    /**
     * Create a three dimensional connection to an IHistogram3D.
     * @param h        The 3D histogram to which to connect to.
     * @param xIndex   The index of the axis to which the x variable is connected.
     * @param yIndex   The index of the axis to which the y variable is connected.
     * @param zIndex   The index of the axis to which the z variable is connected.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create3DConnection(IHistogram3D h, int xIndex, int yIndex, int zIndex) throws IllegalArgumentException;

    /**
     * Create a three dimensional connection to an ICloud3D.
     * @param c        The 3D cloud to which to connect to.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create3DConnection(ICloud3D c) throws IllegalArgumentException;

    /**
     * Create a three dimensional connection to an ICloud3D.
     * @param c        The 3D cloud to which to connect to.
     * @param xIndex   The index of the axis to which the x variable is connected.
     * @param yIndex   The index of the axis to which the y variable is connected.
     * @param zIndex   The index of the axis to which the z variable is connected.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create3DConnection(ICloud3D c, int xIndex, int yIndex, int zIndex) throws IllegalArgumentException;

    /**
     * Create a three dimensional connection to an IDataPointSet.
     * @param dp       The dataPointSet to which to connect to.
     * @param xIndex   The index of the coordinate to which the x variable is connected.
     * @param yIndex   The index of the coordinate to which the y variable is connected.
     * @param zIndex   The index of the coordinate to which the z variable is connected.
     * @param valIndex The index of the coordinate used as "height".
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void create3DConnection(IDataPointSet dp, int xIndex, int yIndex, int zIndex, int valIndex) throws IllegalArgumentException;

    /**
     * General connections.
     *
     */

    /**
     * Tuples are for UNBINNED fits, so no value column required.
     */

    /** 
     * Create a connection to an ITuple.
     * @param t        The ITuple.
     * @param colNames The names of the columns to which to connect.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void createConnection(ITuple t, String[] colNames) throws IllegalArgumentException;

    /** 
     * Create a connection to an ITuple.
     * @param t     The ITuple.
     * @param evals The list of the IEvaluator used to calculate the variable's value.
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void createConnection(ITuple t, IEvaluator[] evals) throws IllegalArgumentException;

    /**
     * Create a connection to an IDataPointSet.
     * @param dp       The dataPointSet to which to connect to.
     * @param indeces  The indeces of the coordinates to which the variables are connected.
     * @param valIndex The index of the coordinate used as "height".
     * @throws IllegalArgumentException If something is wrong.
     *
     */
    public void createConnection(IDataPointSet dp, int[] indeces, int valIndex) throws IllegalArgumentException;

    /**
     * Remove all Ranges and connections; after this is like newly create.
     *
     */
    public void reset();

    /**
     * The dimension of this IFitData, i.e. the number of connections.
     * @return The dimension of the IFitData.
     *
     */
    public int dimension();

    /// Return a string describing the data. This should be considered as a
    /// hint to the user where to find the original data objects and how
    /// to connect the data pipes. PENDING: probably this can be part of
    /// XML streaming.
    public String dataDescription();

    /**
     * Get Range of the corresponding connection by index. 
     * The index represent the order in which
     * connections are coming out of the IFitData.
     * @param  The index of the connection.
     * @return      The Range
     * @throws      IllegalArgumentException If the Range does not exist.
     *
     */
    public IRangeSet range(int index) throws IllegalArgumentException;

    /** @link aggregation */
} // class or interface

