// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * User level interface to 1D Histogram.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
public interface IHistogram1D extends IHistogram {

    /**
     * Fill the IHistogram1D with a value and the
     * corresponding weight.
     * @param x      The value to be filled in.
     * @throws       IllegalArgumentException If the weight is <0 or >1 (?).
     *
     */
    public void fill(double x) throws IllegalArgumentException;
    /**
     * Fill the IHistogram1D with a value and the
     * corresponding weight.
     * @param x      The value to be filled in.
     * @param weight The corresponding weight (by default 1).
     * @throws       IllegalArgumentException If the weight is <0 or >1 (?).
     *
     */
    public void fill(double x, double weight) throws IllegalArgumentException;

    /**
     * The weighted mean of a bin. 
     * @param index The bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     * @return      The mean of the corresponding bin.
     * @throws      IllegalArgumentException If index is not a valid bin number.
     *
     */
    public double binMean(int index) throws IllegalArgumentException;

    /**
     * Number of entries in the corresponding bin (ie the number of times fill was called for this bin).
     * @param index The bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     * @return      The number of entries in the corresponding bin. 
     * @throws      IllegalArgumentException If index is not a valid bin number.
     *
     */
    public int binEntries(int index) throws IllegalArgumentException;

    /**
     * Total height of the corresponding bin (ie the sum of the weights in this bin).
     * @param index The bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     * @return      The height of the corresponding bin.
     * @throws      IllegalArgumentException If index is not a valid bin number.
     *
     */
    public double binHeight(int index) throws IllegalArgumentException;

    /**
     * The error of a given bin.
     * @param index The bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     * @return      The error on the corresponding bin.
     * @throws      IllegalArgumentException If index is not a valid bin number.
     *
     */
    public double binError(int index) throws IllegalArgumentException;

    /**
     * The mean of the whole IHistogram1D.
     * @return The mean of the IHistogram1D.
     *
     */
    public double mean();

    /**
     * The RMS of the whole IHistogram1D.
     * @return The RMS if the IHistogram1D.
     *
     */
    public double rms();

    /**
     * Get the x axis of the IHistogram1D.
     * @return The x coordinate IAxis.
     *
     */
    public IAxis axis();

    /**
     * Get the bin number corresponding to a given coordinate along the x axis.
     * This is a convenience method, equivalent to <tt>axis().coordToIndex(coord)</tt>.
     * @see IAxis#coordToIndex(double)
     * @param coord The coordinalte along the x axis.
     * @return      The corresponding bin number.
     *
     */
    public int coordToIndex(double coord);

    /**
     * Add to this IHistogram1D the contents of another IHistogram1D.
     * @param hist The IHistogram1D to be added to this IHistogram1D.
     * @throws     IllegalArgumentException If the IHistogram1Ds binnings are incompatible.
     *
     */
    public void add(IHistogram1D hist) throws IllegalArgumentException;
} // class or interface

