// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * User level interface to a 2-dimensional profile histogram
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

public interface IProfile2D extends IProfile {

    /**
     * Fill the IProfile2D.
     *
     */
    public void fill(double x, double y, double z) throws IllegalArgumentException;
    /**
     * Fill the IProfile2D.
     *
     */
    public void fill(double x, double y, double z, double weight) throws IllegalArgumentException;

    /**
     * The weighted mean along x of a given bin. 
     * @param indexX The x bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     * @param indexY The y bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     * @return       The mean of the corresponding bin along the x axis.
     * @throws       IllegalArgumentException If the indexes are not a valid bin number.
     *
     */
    public double binMeanX(int indexX, int indexY) throws IllegalArgumentException;

    /**
     * The weighted mean along y of a given bin. 
     * @param indexX The x bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     * @param indexY The y bin number (0...N-1) or OVERFLOW or UNDERFLOW.
     * @return       The mean of the corresponding bin along the x axis.
     * @throws       IllegalArgumentException If the indexes are not a valid bin number.
     *
     */
    public double binMeanY(int indexX, int indexY) throws IllegalArgumentException;

    /**
     * The number of entries (ie the number of times fill was called for this bin).
     * @param indexX the x bin number (0...Nx-1) or OVERFLOW or UNDERFLOW.
     * @param indexY the y bin number (0...Ny-1) or OVERFLOW or UNDERFLOW.
     *
     */
    public int binEntries(int indexX, int indexY);

    /**
     * Equivalent to <tt>projectionX().binEntries(indexX)</tt>.
     *
     */
    public int binEntriesX(int indexX);

    /**
     * Equivalent to <tt>projectionY().binEntries(indexY)</tt>.
     *
     */
    public int binEntriesY(int indexY);

    /**
     * Total height of the corresponding bin (ie the sum of the weights in this bin).
     * @param indexX the x bin number (0...Nx-1) or OVERFLOW or UNDERFLOW.
     * @param indexY the y bin number (0...Ny-1) or OVERFLOW or UNDERFLOW.
     *
     */
    public double binHeight(int indexX, int indexY);

    /**
     * Equivalent to <tt>projectionX().binHeight(indexX)</tt>.
     *
     */
    public double binHeightX(int indexX);

    /**
     * Equivalent to <tt>projectionY().binHeight(indexY)</tt>.
     *
     */
    public double binHeightY(int indexY);

    /**
     * The error on this bin.
     * @param indexX the x bin number (0...Nx-1) or OVERFLOW or UNDERFLOW.
     * @param indexY the y bin number (0...Ny-1) or OVERFLOW or UNDERFLOW.
     *
     */
    public double binError(int indexX, int indexY);

    /**
     * The spread (RMS) of this bin.
     * @param indexX the x bin number (0...Nx-1) or OVERFLOW or UNDERFLOW.
     * @param indexY the y bin number (0...Ny-1) or OVERFLOW or UNDERFLOW.
     *
     */
    public double binRms(int indexX, int indexY);

    /**
     * Returns the mean of the profile, as calculated on filling-time projected on the X axis.
     *
     */
    public double meanX();

    /**
     * Returns the mean of the profile, as calculated on filling-time projected on the Y axis.
     *
     */
    public double meanY();

    /**
     * Returns the rms of the profile as calculated on filling-time projected on the X axis.
     *
     */
    public double rmsX();

    /**
     * Returns the rms of the profile as calculated on filling-time projected on the Y axis.
     *
     */
    public double rmsY();

    /**
     * Return the X axis.
     *
     */
    public IAxis xAxis();

    /**
     * Return the Y axis.
     *
     */
    public IAxis yAxis();

    /**
     * Convenience method, equivalent to <tt>xAxis().coordToIndex(coord)</tt>.
     * @see IAxis#coordToIndex(double)
     *
     */
    public int coordToIndexX(double coordX);

    /**
     * Convenience method, equivalent to <tt>yAxis().coordToIndex(coord)</tt>.
     * @see IAxis#coordToIndex(double)
     *
     */
    public int coordToIndexY(double coordY);

    /**
     * Modifies this profile by adding the contents of profile to it.
     *
     * @param profile The IProfile2D to be added to this IProfile2D
     * @throws IllegalArgumentException if the profile binnings are incompatible
     *
     */
    public void add(IProfile2D h) throws IllegalArgumentException;
} // class or interface

