// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IANALYSISFACTORY_H
#define AIDA_IANALYSISFACTORY_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include <string>

namespace AIDA {

class IDataPointSetFactory;
class IFitFactory;
class IFunctionFactory;
class IHistogramFactory;
class IPlotterFactory;
class ITree;
class ITreeFactory;
class ITupleFactory;

/**
 * The "master" factory from which other factories are obtained.
 * Typically accessed by:
 * <pre>
 *   IAnalysisFactory af =(IAnalysisFactory) ServiceManager.create("hep.aida.IAnalysisFactory");
 * </pre>
 *
 * In C++ IAnalysisFactory* af = AIDA_createAnalysisFactory();
 *
 * @author The AIDA team (http://aida.freehep.org/)
 */

class IAnalysisFactory {

public: 
    /// Destructor.
    virtual ~IAnalysisFactory() { /* nop */; }

  /**
   * Create an ITreeFactory.
   * @return The ITreeFactory.
   *
   */
    virtual ITreeFactory * createTreeFactory() = 0;

  /**
   * Create an IHistogramFactory.
   * @param tree The ITree which created histograms will be associated to.
   * @return     The IHistogramFactory.
   *
   */
    virtual IHistogramFactory * createHistogramFactory(ITree & tree) = 0;

  /**
   * Create an IDataPointSetFactory.
   * @param tree The ITree which created IDataPointSet will be associated to.
   * @return     The IDataPointSetFactory.
   *
   */
    virtual IDataPointSetFactory * createDataPointSetFactory(ITree & tree) = 0;

  /**
   * Create an ITupleFactory.
   * @param tree The ITree which created tuples will be associated to.
   * @return     The ITupleFactory.
   *
   */
    virtual ITupleFactory * createTupleFactory(ITree & tree) = 0;

  /**
   * Create an IFunctionFactory.
   * @param tree The ITree which created functions will be associated to.
   * @return     The IFunctionFactory.
   *
   */
    virtual IFunctionFactory * createFunctionFactory(ITree & tree) = 0;

    /**
     * Create an IPlotterFactory.
     * Due to the fact that the plotter factory may activate a GUI
     * tookit, the process arguments (passed to the main function)
     * could be passed to the plotter factory. Most of the GUI
     * toolkit ask for them (Motif, gtk, Qt, FLTK).
     * @param imp The AIDA implementation to use. The default uses the current implementation one.
     * @param lib The plotter to use within the choosen AIDA implementation (an AIDA implementation may have multiple plotters based on different technologies).
     */
           
                                           
      
          
    virtual IPlotterFactory * createPlotterFactory(int argc = 0, char * * args = 0, const std::string & imp = "", const std::string & lib = "") = 0;

  /**
   * Create an IFitFactory.
   * @return     The IFitFactory.
   *
   */
    virtual IFitFactory * createFitFactory() = 0;
}; // class
} // namespace AIDA



/**
 * To hook an AIDA implementation.
 * For example :
 *   #include <AIDA/IAnalysisFactory.h>
 *   ...
 *   IAnalysisFactory* analysisFactory = AIDA_createAnalysisFactory();
 *   ...
 */

extern "C" {
 AIDA::IAnalysisFactory* AIDA_createAnalysisFactory();
}
#endif /* ifndef AIDA_IANALYSISFACTORY_H */
