// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IDATAPOINTSET_H
#define AIDA_IDATAPOINTSET_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include <string>
#include <vector>

namespace AIDA {

class IAnnotation;
class IDataPoint;

/**
 * Basic user-level interface class for holding and managing
 * a single set of "data points".
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

class IDataPointSet {

public: 
    /// Destructor.
    virtual ~IDataPointSet() { /* nop */; }

    /**
     * Get the IAnnotation of the IDataPointSet.
     * @return The IAnnotation.
     *
     */
    virtual IAnnotation & annotation() = 0;

    virtual const IAnnotation & annotation() const = 0;

    /**
     * Get the title of the IDataPointSet.
     * @return The title.
     *
     */
    virtual std::string title() const = 0;

    /**
     * Set the title of the IDataPointSet.
     * @param title The new title.
     * @return false If the title cannot be set.
     *
     */
    virtual bool setTitle(const std::string & title) = 0;

    /**
     * Get the dimension of the IDataPoints that can be stored in the set.
     * @return The dimension of the IDataPoints storable in the set.
     *
     */
    virtual int dimension() const = 0;

    /**
     * Remove all the IDataPoints in the set.
     * After this the IDataPointSet is as just created.
     *
     */
    virtual void clear() = 0;

    /**
     * Get the current size of the IDataPointSet, i.e. the number
     * of IDataPoints contained in the set.
     * @return The size of the IDataPointSet.
     *
     */
    virtual int size() const = 0;

    /**
     * Get the IDataPoint at a give index in the set.
     * @param index The IDataPoint index.
     * @return      The corresponding IDataPoint.
     *
     */
    virtual IDataPoint * point(int index) = 0;

    /**
     * Set the values and errors of a given coordinate all at once.
     * If this method is called on an empty IDataPointSet, a number of points equal
     * to the size of the arrays provided is created; if the IDataPointSet is not empty
     * the dimension of the array must match with the size of the IDataPointSet.
     * @param coord The coordinate's index
     * @param val   The array of the values for the given coordinate
     * @param err   The array with the symmetric errors.
     * @return false if an illegal coordinate is provided or if
     *              there is a mismatch between the size of the array and the size of the IDataPointSet.
     *
     */
    virtual bool setCoordinate(int coord, const std::vector<double>  & val, const std::vector<double>  & err) = 0;

    /**
     * Set the values and errors of a given coordinate all at once.
     * If this method is called on an empty IDataPointSet, a number of points equal
     * to the size of the arrays provided is created; if the IDataPointSet is not empty
     * the dimension of the array must match with the size of the IDataPointSet.
     * @param coord The coordinate's index
     * @param val   The array of the values for the given coordinate
     * @param errp  The array with the plus errors.
     * @param errm  The array with the minus errors.
     * @return false if an illegal coordinate is provided or if
     *              there is a mismatch between the size of the array and the size of the IDataPointSet.
     *
     */
    virtual bool setCoordinate(int coord, const std::vector<double>  & val, const std::vector<double>  & errp, const std::vector<double>  & errm) = 0;

    virtual const IDataPoint * point(int index) const = 0;

    /**
     * Add a new empty IDataPoint at the end of the set.
     * @return The newly added point.
     *
     */
    virtual IDataPoint * addPoint() = 0;

    /**
     * Add a copy of an IDataPoint at the end of the set.
     * @param point The IDataPoint to be added.
     * @return false If the point has the wrong dimension or
     *                                       if the point cannot be added.
     *
     */
    virtual bool addPoint(const IDataPoint & point) = 0;

    /**
     * Remove the IDataPoint at a given index.
     * @param index The index of the IDataPoint to be removed.
     * @return false If the index is < 0 or >= size().
     *
     */
    virtual bool removePoint(int index) = 0;

    /**
     * Get the lower value for a give axis.
     * @param coord The coordinate of the axis.
     * @return      The lower edge of the corresponding axis.
     *              If coord < 0 or coord >= dimension(), or if the set is empty NaN is returned.
     *
     */
      
           
       
                                           
                                               
                                                             
                                                                                                         
      
       
      
    virtual double lowerExtent(int coord) const = 0;

    /**
     * Get the upper value for a give axis.
     * @param coord The coordinate of the axis.
     * @return      The upper edge of the corresponding axis.
     *              If coord < 0 or coord >= dimension(), or if the set is empty NaN is returned.
     *
     */
      
           
       
                                           
                                               
                                                             
                                                                                                         
      
       
      
    virtual double upperExtent(int coord) const = 0;

    /**
     * Scales the values and the errors of all the measurements
     * of each point by a given factor.
     * @param scaleFactor The scale factor.
     * @return false If an illegal scaleFactor is provided.
     *
     */
    virtual bool scale(double scaleFactor) = 0;

    /**
     * Scales the values of all the measurements
     * of each point by a given factor.
     * @param scaleFactor The scale factor.
     * @return false If an illegal scaleFactor is provided.
     *
     */
    virtual bool scaleValues(double scaleFactor) = 0;

    /**
     * Scales the errors of all the measurements
     * of each point by a given factor.
     * @param scaleFactor The scale factor.
     * @return false If an illegal scaleFactor is provided.
     *
     */
    virtual bool scaleErrors(double scaleFactor) = 0;

    /**
     *  See IManagedObject for a description.
     * @param className The name of the class to cast on.
     * @return The right pointer. Return 0 if failure.
     */ 
    virtual void * cast(const std::string & className) const = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IDATAPOINTSET_H */
