// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IFITPARAMETERSETTINGS_H
#define AIDA_IFITPARAMETERSETTINGS_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include <string>

namespace AIDA {

/** @interface
 *
 * Fitting-specific settings applied to a parameter of the fitted function.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

class IFitParameterSettings {

public: 
    /// Destructor.
    virtual ~IFitParameterSettings() { /* nop */; }

  /// Name of the parameter to which settings apply.
    virtual std::string name() const = 0;

  /// Step size allows to control the "sensitivity" of the change of the parameter
  /// when fitters looks for the optimal parameter value. Default is 1.0.
    virtual double stepSize() const = 0;

  /// Bounds.
    virtual double upperBound() const = 0;

    virtual double lowerBound() const = 0;

  /// Shortcut for lowerBound() == -INF && upperBound() == +INF.
    virtual bool isBound() const = 0;

  /// Value of the parameter cannot change if isFixed() == true.
  /// Parameter can be fixed independently from setting the bounds.
    virtual bool isFixed() const = 0;

  /// Set the step size for the fitter.
    virtual void setStepSize(double step) = 0;

  /// Set bounds. If bounds not set, then default bound is (-INF,+INF).
    virtual void setBounds(double lo, double up) = 0;

  /// Shortcut for setBounds(-INF,+INF).
    virtual void removeBounds() = 0;

  /// Fix/unfix parameter.
    virtual void setFixed(bool isFixed) = 0;

  /**
   * Set the lower bound. When this method is
   * invoked any previous bound is reset. The new bounds
   * are (lowerBound, +INF).
   * @param lowerBound The lower bound.
   *
   */
    virtual void setLowerBound(double lowerBound) = 0;

  /**
   * Set the upper bound. When this method is
   * invoked any previous bound is reset. The new bounds
   * are (-INF, upperBound).
   * @param upperBound The upper bound.
   *
   */
    virtual void setUpperBound(double upperBound) = 0;

  /// Reset all settings to the default values (remove bounds, step size = 1.0, no fix).
    virtual void reset() = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IFITPARAMETERSETTINGS_H */
