// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IMODELFUNCTION_H
#define AIDA_IMODELFUNCTION_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include <vector>

#include "AIDA/IFunction.h"

namespace AIDA {

class IRangeSet;

/** @interface IModelFunction
 *
 * Interface of model function for fitting (for advanced users).
 *
 * OPEN QUESTIONS:
 *
 * How to treat normalization at user level? Two possibilities:
 * - we have "Gauss" and "NormalizedGauss", the first one user cannot
 *   use for ML fit
 * - we have only one "Gauss" function, but it's smart and when normalized,
 *   gets rid of one of its parameters
 *
 * Normalization range might be set directly on the function by the user?
 * Now we set it in the data pipe, Victor thinks that it is not very clear
 * and should be on the function ;)
 *
 * @author  The AIDA team (http://aida.freehep.org/)
 *
 */

class IModelFunction : virtual public IFunction {

public: 
    /// Destructor.
    virtual ~IModelFunction() { /* nop */; }

  /// Return false if function does not provide the normalization capability.
    virtual bool providesNormalization() const = 0;

  /**
   * Normalize by internally adjusting some of the parameters.
   * When normalization is on then integral of the function in
   * the normalization range equals to 1.
   */
    virtual void normalize(bool on) = 0;

  /**
   * Return true if normalization is currently switched on.
   */
    virtual bool isNormalized() const = 0;

  /**
   * Compute gradient with respect to parameters.
   */
    virtual const std::vector<double>  & parameterGradient(const std::vector<double>  & x) const = 0;

  /**
   * Return true if provides parameter gradient.
   */
    virtual bool providesParameterGradient() const = 0;

  /**
   * Set the normalization range from -inf to +inf in the i-th
   * axis (dimension).
   *
   * Full range is the default if not set otherwise.
   * It is still possible to evaluate function outside of the
   * normalization range.
   *
   * PENDING: no methods to retrieve current range!
   */
    virtual IRangeSet & normalizationRange(int iAxis) = 0;

  /**
   * Set full range in all axes.
   */
    virtual void includeNormalizationAll() = 0;

  /**
   * Set empty range in all axes.
   */
    virtual void excludeNormalizationAll() = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IMODELFUNCTION_H */
