// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_ITREEFACTORY_H
#define AIDA_ITREEFACTORY_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include <string>

namespace AIDA {

class ITree;

/**
 * The creator of trees.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 */
 
class ITreeFactory {

public: 
    /// Destructor.
    virtual ~ITreeFactory() { /* nop */; }

    /**
     * Creates a new tree that is not associated with a store.
     */
    virtual ITree * create() = 0;

    /**
     * Creates a new tree and associates it with a store.
     * The store is assumed to be read/write.
     * The store will be created if it does not exist.
     * @param storeName The name of the store, if empty (""), the tree is created
     *                  in memory and therefore will not be associated with a file.
     * @param storeType Implementation specific string, may control store type
     * @param readOnly If true the store is opened readonly, an exception if it does not exist
     * @param createNew If false the file must exist, if true the file will be created
     * @param options Other options, currently are not specified
     *
     */
    virtual ITree * create(const std::string & storeName, const std::string & storeType = "", bool readOnly = false, bool createNew = false, const std::string & options = "") = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_ITREEFACTORY_H */
