// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * Superclass for all styles in AIDA Plotting package.
 * All styles can be reset to their original values at construction 
 * time. In the case of styles which 'contain' other styles (like IStyle 
 * or IAxisStyle), reset() calls reset() on the aggregated styles too.
 * All styles are hierarchical, so the plotter's current style is overridden by the
 * region's current style, which is overridden by any 'associated' style 
 * which is overwritten by any style passed in explicitly at plotting time.
 * Parameters and options which have been explicitly set to 
 * non-default (or default!) values are 'sticky'. For example, if a style
 * has the default 'red' and this has been set explicitly to 'blue' at the 
 * Plotter level, then it will override the default 'red' at the Region level.
 * IF the user explicitly sets the region to 'green' (or 'red'!) then it will
 * not be overridden by the 'parent' style.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 */

public interface IBaseStyle {

  /**
   * Return to original (construction time) state. Explicitly 
   * set parameters will be set to defaults and may be overridden 
   */
    public void reset();

  /**
   * Set a parameter. 
   * @param paramName Name of the parameter.
   * @return false if parameter (or its options) unknown or invalid.
   */
    public boolean setParameter(String paramName);
  /**
   * Set a parameter. 
   * @param paramName Name of the parameter.
   * @param options String of options.
   * @return false if parameter (or its options) unknown or invalid.
   */
    public boolean setParameter(String paramName, String options);

  /**
   * Get value of a parameter. 
   * @param paramName Name of the parameter.
   * @return the value.
   */
    public String parameterValue(String parameter);

  /**
   * Get list of the available parameters (implementation-dependent)
   */
    public String[] availableParameters();

  /** 
   * Get list of the available options for a given parameter 
   * (implementation-dependent).
   */
    public String[] availableParameterOptions(String paramName);
} // class or interface

