# ===========================================================================
# File: default.tcl
# Target: latex
#                        Created: 2010-08-29 09:51:41
#              Last modification: 2011-05-29 08:01:37
# Author: Bernard Desgraupes
# e-mail: <bdesgraupes@users.sourceforge.net>
# (c) Copyright: Bernard Desgraupes 2010-2011
# All rights reserved.
# Description: default settings for target latex
# ===========================================================================

namespace eval latex {
	variable aida_head
	
	set aida_head(DocOptions) "a4paper,10pt"
	set aida_head(DocClass) "article"
	
	set aida_head(RefText) "%s (see section~\\ref{%s} p.~\\pageref{%s})"

	# Define required packages to load with \usepackage
	set aida_head(Packages) [dict create]
	dict set aida_head(Packages) graphicx ""
	dict set aida_head(Packages) makeidx ""

	# This variable lets declare additional packages via header parameters
	set aida_head(AddPackages) [dict create]

	# Insert a \maketitle macro. The \title, \author, \date macros are
	# built with the parameters of the same name.
	set aida_head(MakeTitle)		1
	
	set aida_head(NumberSections)	1
	
	set aida_head(SectionMark)		"AIDA"

	# By default, disable the navigation bar in split files
	set aida_head(NavBar)			0

}



# Chars mapping
# -------------

array set aida_map {
    "&"     "\\&"
    "_"     "\\_"
    "%"     "\\%"
    "$"     "\\$"
    "#"     "\\#"
	"\\"    "\\textbackslash{}"
	"~"     "\\textasciitilde{}"
}

