/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Sets;
import com.google.j2objc.annotations.Weak;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

class Maps$Values
extends AbstractCollection {
    @Weak
    final Map map;

    Maps$Values(Map map) {
        this.map = (Map)Preconditions.checkNotNull(map);
    }

    final Map map() {
        return this.map;
    }

    @Override
    public Iterator iterator() {
        return Maps.valueIterator(this.map().entrySet().iterator());
    }

    @Override
    public void forEach(Consumer consumer) {
        Preconditions.checkNotNull(consumer);
        this.map.forEach((? super K object, ? super V object2) -> consumer.accept(object2));
    }

    @Override
    public boolean remove(Object object) {
        try {
            return super.remove(object);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            for (Map.Entry entry : this.map().entrySet()) {
                if (!Objects.equal(object, entry.getValue())) continue;
                this.map().remove(entry.getKey());
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean removeAll(Collection collection) {
        try {
            return super.removeAll((Collection)Preconditions.checkNotNull(collection));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            HashSet hashSet = Sets.newHashSet();
            for (Map.Entry entry : this.map().entrySet()) {
                if (!collection.contains(entry.getValue())) continue;
                hashSet.add(entry.getKey());
            }
            return this.map().keySet().removeAll(hashSet);
        }
    }

    @Override
    public boolean retainAll(Collection collection) {
        try {
            return super.retainAll((Collection)Preconditions.checkNotNull(collection));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            HashSet hashSet = Sets.newHashSet();
            for (Map.Entry entry : this.map().entrySet()) {
                if (!collection.contains(entry.getValue())) continue;
                hashSet.add(entry.getKey());
            }
            return this.map().keySet().retainAll(hashSet);
        }
    }

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public boolean isEmpty() {
        return this.map().isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.map().containsValue(object);
    }

    @Override
    public void clear() {
        this.map().clear();
    }
}

