/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcCatalogSchema;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.jdbc.CachingCalciteSchema;
import org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.calcite.jdbc.MetadataSchema;
import org.apache.calcite.jdbc.SimpleCalciteSchema;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.schema.impl.StarTable;
import org.apache.calcite.util.NameMap;
import org.apache.calcite.util.NameMultimap;
import org.apache.calcite.util.NameSet;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CalciteSchema {
    private final @Nullable CalciteSchema parent;
    public final Schema schema;
    public final String name;
    protected final NameMap<TableEntry> tableMap;
    protected final NameMultimap<FunctionEntry> functionMap;
    protected final NameMap<TypeEntry> typeMap;
    protected final NameMap<LatticeEntry> latticeMap;
    protected final NameSet functionNames;
    protected final NameMap<FunctionEntry> nullaryFunctionMap;
    protected final NameMap<CalciteSchema> subSchemaMap;
    private @Nullable List<? extends List<String>> path;

    protected CalciteSchema(@Nullable CalciteSchema parent, Schema schema, String name, @Nullable NameMap<CalciteSchema> subSchemaMap, @Nullable NameMap<TableEntry> tableMap, @Nullable NameMap<LatticeEntry> latticeMap, @Nullable NameMap<TypeEntry> typeMap, @Nullable NameMultimap<FunctionEntry> functionMap, @Nullable NameSet functionNames, @Nullable NameMap<FunctionEntry> nullaryFunctionMap, @Nullable List<? extends List<String>> path) {
        this.parent = parent;
        this.schema = schema;
        this.name = name;
        this.tableMap = tableMap == null ? new NameMap() : Objects.requireNonNull(tableMap, "tableMap");
        this.latticeMap = latticeMap == null ? new NameMap() : Objects.requireNonNull(latticeMap, "latticeMap");
        this.subSchemaMap = subSchemaMap == null ? new NameMap() : Objects.requireNonNull(subSchemaMap, "subSchemaMap");
        if (functionMap == null) {
            this.functionMap = new NameMultimap();
            this.functionNames = new NameSet();
            this.nullaryFunctionMap = new NameMap();
        } else {
            this.functionMap = Objects.requireNonNull(functionMap, "functionMap");
            this.functionNames = Objects.requireNonNull(functionNames, "functionNames");
            this.nullaryFunctionMap = Objects.requireNonNull(nullaryFunctionMap, "nullaryFunctionMap");
        }
        this.typeMap = typeMap == null ? new NameMap() : Objects.requireNonNull(typeMap, "typeMap");
        this.path = path;
    }

    protected abstract @Nullable CalciteSchema getImplicitSubSchema(String var1, boolean var2);

    protected abstract @Nullable TableEntry getImplicitTable(String var1, boolean var2);

    protected abstract @Nullable TypeEntry getImplicitType(String var1, boolean var2);

    protected abstract @Nullable TableEntry getImplicitTableBasedOnNullaryFunction(String var1, boolean var2);

    protected abstract void addImplicitSubSchemaToBuilder(ImmutableSortedMap.Builder<String, CalciteSchema> var1);

    protected abstract void addImplicitTableToBuilder(ImmutableSortedSet.Builder<String> var1);

    protected abstract void addImplicitFunctionsToBuilder(ImmutableList.Builder<Function> var1, String var2, boolean var3);

    protected abstract void addImplicitFuncNamesToBuilder(ImmutableSortedSet.Builder<String> var1);

    protected abstract void addImplicitTypeNamesToBuilder(ImmutableSortedSet.Builder<String> var1);

    protected abstract void addImplicitTablesBasedOnNullaryFunctionsToBuilder(ImmutableSortedMap.Builder<String, Table> var1);

    protected abstract CalciteSchema snapshot(@Nullable CalciteSchema var1, SchemaVersion var2);

    protected abstract boolean isCacheEnabled();

    public abstract void setCache(boolean var1);

    protected TableEntryImpl tableEntry(String name, Table table) {
        return new TableEntryImpl(this, name, table, (ImmutableList<String>)ImmutableList.of());
    }

    protected TypeEntryImpl typeEntry(String name, RelProtoDataType relProtoDataType) {
        return new TypeEntryImpl(this, name, relProtoDataType);
    }

    public TableEntry add(String tableName, Table table) {
        return this.add(tableName, table, (ImmutableList<String>)ImmutableList.of());
    }

    public TableEntry add(String tableName, Table table, ImmutableList<String> sqls) {
        TableEntryImpl entry = new TableEntryImpl(this, tableName, table, sqls);
        this.tableMap.put(tableName, entry);
        return entry;
    }

    public TypeEntry add(String name, RelProtoDataType type) {
        TypeEntryImpl entry = new TypeEntryImpl(this, name, type);
        this.typeMap.put(name, entry);
        return entry;
    }

    private FunctionEntry add(String name, Function function) {
        FunctionEntryImpl entry = new FunctionEntryImpl(this, name, function);
        this.functionMap.put(name, entry);
        this.functionNames.add(name);
        if (function.getParameters().isEmpty()) {
            this.nullaryFunctionMap.put(name, entry);
        }
        return entry;
    }

    private LatticeEntry add(String name, Lattice lattice) {
        if (this.latticeMap.containsKey(name, false)) {
            throw new RuntimeException("Duplicate lattice '" + name + "'");
        }
        LatticeEntryImpl entry = new LatticeEntryImpl(this, name, lattice);
        this.latticeMap.put(name, entry);
        return entry;
    }

    public CalciteSchema root() {
        CalciteSchema schema = this;
        while (schema.parent != null) {
            schema = schema.parent;
        }
        return schema;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public List<String> path(@Nullable String name) {
        ArrayList<String> list = new ArrayList<String>();
        if (name != null) {
            list.add(name);
        }
        CalciteSchema s = this;
        while (s != null) {
            if (s.parent != null || !s.name.equals("")) {
                list.add(s.name);
            }
            s = s.parent;
        }
        return ImmutableList.copyOf((Collection)Lists.reverse(list));
    }

    public final @Nullable CalciteSchema getSubSchema(String schemaName, boolean caseSensitive) {
        Iterator iterator = this.subSchemaMap.range(schemaName, caseSensitive).entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            return (CalciteSchema)entry.getValue();
        }
        return this.getImplicitSubSchema(schemaName, caseSensitive);
    }

    public abstract CalciteSchema add(String var1, Schema var2);

    public final @Nullable TableEntry getTableBySql(String sql) {
        for (TableEntry tableEntry : this.tableMap.map().values()) {
            if (!tableEntry.sqls.contains((Object)sql)) continue;
            return tableEntry;
        }
        return null;
    }

    public final @Nullable TableEntry getTable(String tableName, boolean caseSensitive) {
        Iterator iterator = this.tableMap.range(tableName, caseSensitive).entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            return (TableEntry)entry.getValue();
        }
        return this.getImplicitTable(tableName, caseSensitive);
    }

    public String getName() {
        return this.name;
    }

    public SchemaPlus plus() {
        return new SchemaPlusImpl();
    }

    public static CalciteSchema from(SchemaPlus plus) {
        return ((SchemaPlusImpl)plus).calciteSchema();
    }

    public List<? extends List<String>> getPath() {
        if (this.path != null) {
            return this.path;
        }
        return ImmutableList.of(this.path(null));
    }

    public final NavigableMap<String, CalciteSchema> getSubSchemaMap() {
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(NameSet.COMPARATOR);
        builder.putAll(this.subSchemaMap.map());
        this.addImplicitSubSchemaToBuilder((ImmutableSortedMap.Builder<String, CalciteSchema>)builder);
        return builder.build();
    }

    public NavigableMap<String, LatticeEntry> getLatticeMap() {
        return ImmutableSortedMap.copyOf(this.latticeMap.map());
    }

    public final NavigableSet<String> getTableNames() {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(NameSet.COMPARATOR);
        builder.addAll(this.tableMap.map().keySet());
        this.addImplicitTableToBuilder((ImmutableSortedSet.Builder<String>)builder);
        return builder.build();
    }

    public final NavigableSet<String> getTypeNames() {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(NameSet.COMPARATOR);
        builder.addAll(this.typeMap.map().keySet());
        this.addImplicitTypeNamesToBuilder((ImmutableSortedSet.Builder<String>)builder);
        return builder.build();
    }

    public final @Nullable TypeEntry getType(String name, boolean caseSensitive) {
        Iterator iterator = this.typeMap.range(name, caseSensitive).entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            return (TypeEntry)entry.getValue();
        }
        return this.getImplicitType(name, caseSensitive);
    }

    public final Collection<Function> getFunctions(String name, boolean caseSensitive) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FunctionEntry functionEntry : Pair.right(this.functionMap.range(name, caseSensitive))) {
            builder.add((Object)functionEntry.getFunction());
        }
        this.addImplicitFunctionsToBuilder((ImmutableList.Builder<Function>)builder, name, caseSensitive);
        return builder.build();
    }

    public final NavigableSet<String> getFunctionNames() {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(NameSet.COMPARATOR);
        builder.addAll(this.functionMap.map().keySet());
        this.addImplicitFuncNamesToBuilder((ImmutableSortedSet.Builder<String>)builder);
        return builder.build();
    }

    public final NavigableMap<String, Table> getTablesBasedOnNullaryFunctions() {
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(NameSet.COMPARATOR);
        for (Map.Entry entry : this.nullaryFunctionMap.map().entrySet()) {
            Function function = ((FunctionEntry)entry.getValue()).getFunction();
            if (!(function instanceof TableMacro)) continue;
            assert (function.getParameters().isEmpty());
            TranslatableTable table = ((TableMacro)function).apply((List<? extends Object>)ImmutableList.of());
            builder.put(entry.getKey(), (Object)table);
        }
        this.addImplicitTablesBasedOnNullaryFunctionsToBuilder((ImmutableSortedMap.Builder<String, Table>)builder);
        return builder.build();
    }

    public final @Nullable TableEntry getTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        for (Map.Entry entry : this.nullaryFunctionMap.range(tableName, caseSensitive).entrySet()) {
            Function function = ((FunctionEntry)entry.getValue()).getFunction();
            if (!(function instanceof TableMacro)) continue;
            assert (function.getParameters().isEmpty());
            TranslatableTable table = ((TableMacro)function).apply((List<? extends Object>)ImmutableList.of());
            return this.tableEntry(tableName, table);
        }
        return this.getImplicitTableBasedOnNullaryFunction(tableName, caseSensitive);
    }

    public CalciteSchema createSnapshot(SchemaVersion version) {
        Preconditions.checkArgument((boolean)this.isRoot(), (Object)"must be root schema");
        return this.snapshot(null, version);
    }

    @Deprecated
    protected static <V> NavigableMap<String, V> find(NavigableMap<String, V> map, String s) {
        return NameMap.immutableCopyOf(map).range(s, false);
    }

    @Deprecated
    protected static Iterable<String> find(NavigableSet<String> set, String name) {
        return NameSet.immutableCopyOf(set).range(name, false);
    }

    public static CalciteSchema createRootSchema(boolean addMetadataSchema) {
        return CalciteSchema.createRootSchema(addMetadataSchema, true);
    }

    public static CalciteSchema createRootSchema(boolean addMetadataSchema, boolean cache) {
        return CalciteSchema.createRootSchema(addMetadataSchema, cache, "");
    }

    public static CalciteSchema createRootSchema(boolean addMetadataSchema, boolean cache, String name) {
        CalciteConnectionImpl.RootSchema rootSchema = new CalciteConnectionImpl.RootSchema();
        return CalciteSchema.createRootSchema(addMetadataSchema, cache, name, rootSchema);
    }

    public static CalciteSchema createRootSchema(boolean addMetadataSchema, boolean cache, String name, Schema schema) {
        CalciteSchema rootSchema = cache ? new CachingCalciteSchema(null, schema, name) : new SimpleCalciteSchema(null, schema, name);
        if (addMetadataSchema) {
            rootSchema.add("metadata", MetadataSchema.INSTANCE);
        }
        return rootSchema;
    }

    public boolean removeSubSchema(String name) {
        return this.subSchemaMap.remove(name) != null;
    }

    public boolean removeTable(String name) {
        return this.tableMap.remove(name) != null;
    }

    public boolean removeFunction(String name) {
        FunctionEntry remove = this.nullaryFunctionMap.remove(name);
        if (remove == null) {
            return false;
        }
        this.functionMap.remove(name, remove);
        return true;
    }

    public boolean removeType(String name) {
        return this.typeMap.remove(name) != null;
    }

    public static class LatticeEntryImpl
    extends LatticeEntry {
        private final Lattice lattice;
        private final TableEntry starTableEntry;

        public LatticeEntryImpl(CalciteSchema schema, String name, Lattice lattice) {
            super(schema, name);
            this.lattice = lattice;
            StarTable starTable = lattice.createStarTable();
            this.starTableEntry = schema.add(name, starTable);
        }

        @Override
        public Lattice getLattice() {
            return this.lattice;
        }

        @Override
        public TableEntry getStarTable() {
            return this.starTableEntry;
        }
    }

    public static class FunctionEntryImpl
    extends FunctionEntry {
        private final Function function;

        public FunctionEntryImpl(CalciteSchema schema, String name, Function function) {
            super(schema, name);
            this.function = function;
        }

        @Override
        public Function getFunction() {
            return this.function;
        }

        @Override
        public boolean isMaterialization() {
            return this.function instanceof MaterializedViewTable.MaterializedViewTableMacro;
        }
    }

    public static class TypeEntryImpl
    extends TypeEntry {
        private final RelProtoDataType protoDataType;

        public TypeEntryImpl(CalciteSchema schema, String name, RelProtoDataType protoDataType) {
            super(schema, name);
            this.protoDataType = protoDataType;
        }

        @Override
        public RelProtoDataType getType() {
            return this.protoDataType;
        }
    }

    public static class TableEntryImpl
    extends TableEntry {
        private final Table table;

        public TableEntryImpl(CalciteSchema schema, String name, Table table, ImmutableList<String> sqls) {
            super(schema, name, sqls);
            this.table = Objects.requireNonNull(table, "table");
        }

        @Override
        public Table getTable() {
            return this.table;
        }
    }

    private class SchemaPlusImpl
    implements SchemaPlus {
        private SchemaPlusImpl() {
        }

        CalciteSchema calciteSchema() {
            return CalciteSchema.this;
        }

        @Override
        public @Nullable SchemaPlus getParentSchema() {
            return CalciteSchema.this.parent == null ? null : CalciteSchema.this.parent.plus();
        }

        @Override
        public String getName() {
            return CalciteSchema.this.getName();
        }

        @Override
        public boolean isMutable() {
            return CalciteSchema.this.schema.isMutable();
        }

        @Override
        public void setCacheEnabled(boolean cache) {
            CalciteSchema.this.setCache(cache);
        }

        @Override
        public boolean isCacheEnabled() {
            return CalciteSchema.this.isCacheEnabled();
        }

        @Override
        public Schema snapshot(SchemaVersion version) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Expression getExpression(@Nullable SchemaPlus parentSchema, String name) {
            return CalciteSchema.this.schema.getExpression(parentSchema, name);
        }

        @Override
        public @Nullable Table getTable(String name) {
            TableEntry entry = CalciteSchema.this.getTable(name, true);
            return entry == null ? null : entry.getTable();
        }

        public NavigableSet<String> getTableNames() {
            return CalciteSchema.this.getTableNames();
        }

        @Override
        public @Nullable RelProtoDataType getType(String name) {
            TypeEntry entry = CalciteSchema.this.getType(name, true);
            return entry == null ? null : entry.getType();
        }

        @Override
        public Set<String> getTypeNames() {
            return CalciteSchema.this.getTypeNames();
        }

        @Override
        public Collection<Function> getFunctions(String name) {
            return CalciteSchema.this.getFunctions(name, true);
        }

        public NavigableSet<String> getFunctionNames() {
            return CalciteSchema.this.getFunctionNames();
        }

        @Override
        public @Nullable SchemaPlus getSubSchema(String name) {
            CalciteSchema subSchema = CalciteSchema.this.getSubSchema(name, true);
            return subSchema == null ? null : subSchema.plus();
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return CalciteSchema.this.getSubSchemaMap().keySet();
        }

        @Override
        public SchemaPlus add(String name, Schema schema) {
            CalciteSchema calciteSchema = CalciteSchema.this.add(name, schema);
            return calciteSchema.plus();
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this)) {
                return clazz.cast(this);
            }
            if (clazz.isInstance(CalciteSchema.this)) {
                return clazz.cast(CalciteSchema.this);
            }
            if (clazz.isInstance(CalciteSchema.this.schema)) {
                return clazz.cast(CalciteSchema.this.schema);
            }
            if (clazz == DataSource.class) {
                if (CalciteSchema.this.schema instanceof JdbcSchema) {
                    return clazz.cast(((JdbcSchema)CalciteSchema.this.schema).getDataSource());
                }
                if (CalciteSchema.this.schema instanceof JdbcCatalogSchema) {
                    return clazz.cast(((JdbcCatalogSchema)CalciteSchema.this.schema).getDataSource());
                }
            }
            throw new ClassCastException("not a " + clazz);
        }

        @Override
        public void setPath(ImmutableList<ImmutableList<String>> path) {
            CalciteSchema.this.path = path;
        }

        @Override
        public void add(String name, Table table) {
            CalciteSchema.this.add(name, table);
        }

        @Override
        public boolean removeTable(String name) {
            return CalciteSchema.this.removeTable(name);
        }

        @Override
        public void add(String name, Function function) {
            CalciteSchema.this.add(name, function);
        }

        @Override
        public void add(String name, RelProtoDataType type) {
            CalciteSchema.this.add(name, type);
        }

        @Override
        public void add(String name, Lattice lattice) {
            CalciteSchema.this.add(name, lattice);
        }
    }

    public static abstract class LatticeEntry
    extends Entry {
        protected LatticeEntry(CalciteSchema schema, String name) {
            super(schema, name);
        }

        public abstract Lattice getLattice();

        public abstract TableEntry getStarTable();
    }

    public static abstract class FunctionEntry
    extends Entry {
        protected FunctionEntry(CalciteSchema schema, String name) {
            super(schema, name);
        }

        public abstract Function getFunction();

        public abstract boolean isMaterialization();
    }

    public static abstract class TypeEntry
    extends Entry {
        protected TypeEntry(CalciteSchema schema, String name) {
            super(schema, name);
        }

        public abstract RelProtoDataType getType();
    }

    public static abstract class TableEntry
    extends Entry {
        public final ImmutableList<String> sqls;

        protected TableEntry(CalciteSchema schema, String name, ImmutableList<String> sqls) {
            super(schema, name);
            this.sqls = Objects.requireNonNull(sqls, "sqls");
        }

        public abstract Table getTable();
    }

    public static abstract class Entry {
        public final CalciteSchema schema;
        public final String name;

        protected Entry(CalciteSchema schema, String name) {
            this.schema = Objects.requireNonNull(schema, "schema");
            this.name = Objects.requireNonNull(name, "name");
        }

        public final List<String> path() {
            return this.schema.path(this.name);
        }
    }
}

