/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import java.util.List;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlFloorFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PostgresqlSqlDialect
extends SqlDialect {
    public static final RelDataTypeSystem POSTGRESQL_TYPE_SYSTEM = new RelDataTypeSystemImpl(){

        @Override
        public int getMaxPrecision(SqlTypeName typeName) {
            switch (typeName) {
                case VARCHAR: {
                    return 0xA00000;
                }
            }
            return super.getMaxPrecision(typeName);
        }
    };
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.POSTGRESQL).withIdentifierQuoteString("\"").withUnquotedCasing(Casing.TO_LOWER).withDataTypeSystem(POSTGRESQL_TYPE_SYSTEM);
    public static final SqlDialect DEFAULT = new PostgresqlSqlDialect(DEFAULT_CONTEXT);

    public PostgresqlSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        String castSpec;
        switch (type.getSqlTypeName()) {
            case TINYINT: {
                castSpec = "smallint";
                break;
            }
            case DOUBLE: {
                castSpec = "double precision";
                break;
            }
            default: {
                return super.getCastSpec(type);
            }
        }
        return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec(castSpec, type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
    }

    @Override
    public SqlNode rewriteSingleValueExpr(SqlNode aggCall, RelDataType relDataType) {
        Object operand = ((SqlBasicCall)aggCall).operand(0);
        SqlLiteral nullLiteral = SqlLiteral.createNull(SqlParserPos.ZERO);
        SqlSelect unionOperand = new SqlSelect(SqlParserPos.ZERO, SqlNodeList.EMPTY, SqlNodeList.of(SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, SqlNodeList.of(nullLiteral), SqlNodeList.of((SqlNode)Nullness.castNonNull((Object)this.getCastSpec(relDataType))))), null, null, null, null, SqlNodeList.EMPTY, null, null, null, null, SqlNodeList.EMPTY);
        SqlCase caseExpr = new SqlCase(SqlParserPos.ZERO, SqlStdOperatorTable.COUNT.createCall(SqlParserPos.ZERO, new SqlNode[]{operand}), SqlNodeList.of(SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO), SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO)), SqlNodeList.of(nullLiteral, SqlStdOperatorTable.MIN.createCall(SqlParserPos.ZERO, new SqlNode[]{operand})), SqlStdOperatorTable.SCALAR_QUERY.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.UNION_ALL.createCall(SqlParserPos.ZERO, unionOperand, unionOperand)));
        LOGGER.debug("SINGLE_VALUE rewritten into [{}]", (Object)caseExpr);
        return caseExpr;
    }

    @Override
    public boolean supportsFunction(SqlOperator operator, RelDataType type, List<RelDataType> paramTypes) {
        switch (operator.kind) {
            case LIKE: {
                return true;
            }
        }
        return super.supportsFunction(operator, type, paramTypes);
    }

    @Override
    public boolean requiresAliasForFromItems() {
        return true;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case FLOOR: {
                if (call.operandCount() != 2) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    return;
                }
                SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                SqlCall call2 = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                SqlFloorFunction.unparseDatetimeFunction(writer, call2, "DATE_TRUNC", false);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public boolean supportsGroupByLiteral() {
        return false;
    }
}

