/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.TriggerBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAddedTrigger
extends TriggerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Set<String> lastLiveNodes = new HashSet<String>();
    private Map<String, Long> nodeNameVsTimeAdded = new HashMap<String, Long>();
    private String preferredOp;
    private Replica.Type replicaType = Replica.Type.NRT;

    public NodeAddedTrigger(String name) {
        super(TriggerEventType.NODEADDED, name);
        TriggerUtils.validProperties(this.validProperties, "preferredOperation", "replicaType");
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.lastLiveNodes = new HashSet<String>(this.cloudManager.getClusterStateProvider().getLiveNodes());
        log.debug("NodeAddedTrigger {} - Initial livenodes: {}", (Object)this.name, this.lastLiveNodes);
        log.debug("NodeAddedTrigger {} instantiated with properties: {}", (Object)this.name, (Object)this.properties);
        try {
            List added = this.stateManager.listData("/autoscaling/nodeAdded");
            added.forEach(n -> {
                String markerPath = "/autoscaling/nodeAdded/" + n;
                try {
                    Map markerData = Utils.getJson((DistribStateManager)this.stateManager, (String)markerPath);
                    if (markerData.getOrDefault("state", "active").equals("inactive")) {
                        return;
                    }
                }
                catch (IOException | InterruptedException | KeeperException e) {
                    log.debug("-- ignoring marker {} state due to error{}", (Object)markerPath, (Object)e);
                }
                if (this.lastLiveNodes.contains(n) && !this.nodeNameVsTimeAdded.containsKey(n)) {
                    log.debug("Adding node from marker path: {}", n);
                    this.nodeNameVsTimeAdded.put((String)n, this.cloudManager.getTimeSource().getTimeNs());
                }
            });
        }
        catch (NoSuchElementException added) {
        }
        catch (Exception e) {
            log.warn("Exception retrieving nodeLost markers", (Throwable)e);
        }
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        super.configure(loader, cloudManager, properties);
        this.preferredOp = (String)properties.getOrDefault("preferredOperation", CollectionParams.CollectionAction.MOVEREPLICA.toLower());
        this.preferredOp = this.preferredOp.toLowerCase(Locale.ROOT);
        String replicaTypeStr = (String)properties.getOrDefault("replicaType", Replica.Type.NRT.name());
        try {
            this.replicaType = Replica.Type.valueOf((String)replicaTypeStr);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new TriggerValidationException("Unsupported replicaType=" + replicaTypeStr + " specified for node added trigger", new String[0]);
        }
        CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)this.preferredOp);
        switch (action) {
            case ADDREPLICA: 
            case MOVEREPLICA: 
            case NONE: {
                break;
            }
            default: {
                throw new TriggerValidationException("Unsupported preferredOperation=" + this.preferredOp + " specified for node added trigger", new String[0]);
            }
        }
    }

    @Override
    public void restoreState(AutoScaling.Trigger old) {
        NodeAddedTrigger that;
        assert (old.isClosed());
        if (old instanceof NodeAddedTrigger) {
            that = (NodeAddedTrigger)old;
            assert (this.name.equals(that.name));
        } else {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Unable to restore state from an unknown type of trigger");
        }
        this.lastLiveNodes.clear();
        this.lastLiveNodes.addAll(that.lastLiveNodes);
        this.nodeNameVsTimeAdded.clear();
        this.nodeNameVsTimeAdded.putAll(that.nodeNameVsTimeAdded);
    }

    @Override
    protected Map<String, Object> getState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("lastLiveNodes", this.lastLiveNodes);
        state.put("nodeNameVsTimeAdded", this.nodeNameVsTimeAdded);
        return state;
    }

    @Override
    protected void setState(Map<String, Object> state) {
        Map nodeNameVsTimeAdded;
        this.lastLiveNodes.clear();
        this.nodeNameVsTimeAdded.clear();
        Collection lastLiveNodes = (Collection)state.get("lastLiveNodes");
        if (lastLiveNodes != null) {
            this.lastLiveNodes.addAll(lastLiveNodes);
        }
        if ((nodeNameVsTimeAdded = (Map)state.get("nodeNameVsTimeAdded")) != null) {
            this.nodeNameVsTimeAdded.putAll(nodeNameVsTimeAdded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            NodeAddedTrigger nodeAddedTrigger = this;
            synchronized (nodeAddedTrigger) {
                if (this.isClosed) {
                    log.warn("NodeAddedTrigger ran but was already closed");
                    throw new RuntimeException("Trigger has been closed");
                }
            }
            log.debug("Running NodeAddedTrigger {}", (Object)this.name);
            HashSet newLiveNodes = new HashSet(this.cloudManager.getClusterStateProvider().getLiveNodes());
            if (log.isDebugEnabled()) {
                log.debug("Found livenodes: {}", (Object)newLiveNodes.size());
            }
            Set<String> trackingKeySet = this.nodeNameVsTimeAdded.keySet();
            trackingKeySet.retainAll(newLiveNodes);
            HashSet copyOfNew = new HashSet(newLiveNodes);
            copyOfNew.removeAll(this.lastLiveNodes);
            copyOfNew.forEach(n -> {
                long eventTime = this.cloudManager.getTimeSource().getTimeNs();
                log.debug("Tracking new node: {} at time {}", n, (Object)eventTime);
                this.nodeNameVsTimeAdded.put((String)n, eventTime);
            });
            ArrayList<String> nodeNames = new ArrayList<String>();
            ArrayList<Long> times = new ArrayList<Long>();
            for (Map.Entry<String, Long> entry : this.nodeNameVsTimeAdded.entrySet()) {
                String nodeName = entry.getKey();
                Long timeAdded = entry.getValue();
                long now = this.cloudManager.getTimeSource().getTimeNs();
                if (TimeUnit.SECONDS.convert(now - timeAdded, TimeUnit.NANOSECONDS) < (long)this.getWaitForSecond()) continue;
                nodeNames.add(nodeName);
                times.add(timeAdded);
            }
            AutoScaling.TriggerEventProcessor processor = (AutoScaling.TriggerEventProcessor)this.processorRef.get();
            if (!nodeNames.isEmpty()) {
                if (processor != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("NodeAddedTrigger {} firing registered processor for nodes: {} added at times {}, now={}", new Object[]{this.name, nodeNames, times, this.cloudManager.getTimeSource().getTimeNs()});
                    }
                    if (processor.process(new NodeAddedEvent(this.getEventType(), this.getName(), times, nodeNames, this.preferredOp, this.replicaType))) {
                        nodeNames.forEach(n -> {
                            log.debug("Removing new node from tracking: {}", n);
                            this.nodeNameVsTimeAdded.remove(n);
                        });
                    } else {
                        log.debug("Processor returned false for {}!", nodeNames);
                    }
                } else {
                    nodeNames.forEach(n -> this.nodeNameVsTimeAdded.remove(n));
                }
            }
            this.lastLiveNodes = new HashSet<String>(newLiveNodes);
        }
        catch (RuntimeException e) {
            log.error("Unexpected exception in NodeAddedTrigger", (Throwable)e);
        }
    }

    public static class NodeAddedEvent
    extends TriggerEvent {
        public NodeAddedEvent(TriggerEventType eventType, String source, List<Long> times, List<String> nodeNames, String preferredOp, Replica.Type replicaType) {
            super(eventType, source, times.get(0), null);
            this.properties.put("nodeNames", nodeNames);
            this.properties.put("eventTimes", times);
            this.properties.put("preferredOperation", preferredOp);
            this.properties.put("replicaType", replicaType);
        }
    }
}

