/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.handler.export.IntComp;
import org.apache.solr.handler.export.SortValue;

public class IntValue
implements SortValue {
    protected NumericDocValues vals;
    protected String field;
    protected int currentValue;
    protected IntComp comp;
    private int lastDocID;
    protected boolean present;

    @Override
    public Object getCurrentValue() {
        assert (this.present);
        return this.currentValue;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public IntValue copy() {
        return new IntValue(this.field, this.comp);
    }

    public IntValue(String field, IntComp comp) {
        this.field = field;
        this.comp = comp;
        this.currentValue = comp.resetValue();
        this.present = false;
    }

    @Override
    public void setNextReader(LeafReaderContext context) throws IOException {
        this.vals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        this.lastDocID = 0;
    }

    @Override
    public void setCurrentValue(int docId) throws IOException {
        if (docId < this.lastDocID) {
            throw new AssertionError((Object)("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs doc=" + docId));
        }
        this.lastDocID = docId;
        int curDocID = this.vals.docID();
        if (docId > curDocID) {
            curDocID = this.vals.advance(docId);
        }
        if (docId == curDocID) {
            this.present = true;
            this.currentValue = (int)this.vals.longValue();
        } else {
            this.present = false;
            this.currentValue = 0;
        }
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public int compareTo(SortValue o) {
        IntValue iv = (IntValue)o;
        return this.comp.compare(this.currentValue, iv.currentValue);
    }

    @Override
    public void setCurrentValue(SortValue sv) {
        IntValue iv = (IntValue)sv;
        this.currentValue = iv.currentValue;
        this.present = iv.present;
    }

    @Override
    public void reset() {
        this.currentValue = this.comp.resetValue();
        this.present = false;
    }
}

